/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.json;

import cn.com.qimingx.json.MyJsonConfig;
import cn.com.qimingx.utils.ExtTypeInfo;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

public class MyJSONUtils {
    private static final MyJSONUtils self = new MyJSONUtils();

    public static void main(String[] args) {
        ExtTypeInfo extType = new ExtTypeInfo(1);
        JSON json1 = JSONSerializer.toJSON((Object)extType);
        System.out.println("json1:" + json1);
        JSON json2 = MyJSONUtils.toJsonExclude(extType, "booleanType");
        System.out.println("json2:" + json2);
        String[] fields = new String[]{"booleanType", "dateFormat"};
        JSON json3 = MyJSONUtils.toJsonInclude(extType, fields);
        System.out.println("json3:" + json3);
    }

    public static JSON toJsonExclude(Object o, String ... excludeProperty) {
        return self.jsonExclude(o, excludeProperty);
    }

    public static JSON toJsonInclude(Object o, String ... includeProperty) {
        return self.jsonInclude(o, includeProperty);
    }

    public JSON jsonExclude(Object o, String ... excludeProperty) {
        MyJsonConfig config = new MyJsonConfig();
        NamedPropertyFilter filter = new NamedPropertyFilter(excludeProperty);
        filter.setExclude(true);
        config.setJsonPropertyFilter(filter);
        JSON json = JSONSerializer.toJSON((Object)o, (JsonConfig)config);
        return json;
    }

    public JSON jsonInclude(Object o, String ... includePropertys) {
        MyJsonConfig config = new MyJsonConfig();
        NamedPropertyFilter filter = new NamedPropertyFilter(includePropertys);
        filter.setExclude(false);
        config.setJsonPropertyFilter(filter);
        JSON json = JSONSerializer.toJSON((Object)o, (JsonConfig)config);
        return json;
    }

    private static class NamedPropertyFilter
    implements PropertyFilter {
        private String[] names;
        private boolean exclude = true;

        public void setExclude(boolean exclude) {
            this.exclude = exclude;
        }

        public NamedPropertyFilter(String[] names) {
            this.names = names;
        }

        public NamedPropertyFilter(String[] names, boolean exclude) {
            this.names = names;
            this.exclude = exclude;
        }

        public boolean apply(Object source, String property, Object value) {
            if (this.names == null || this.names.length < 1) {
                return !this.exclude;
            }
            for (String name : this.names) {
                if (!name.equals(property)) continue;
                return this.exclude;
            }
            return !this.exclude;
        }
    }
}

