/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe.service.impl;

import cn.com.qimingx.dbe.service.impl.AbstractDBInfoService;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OracleDBInfoService
extends AbstractDBInfoService {
    private static final Log log = LogFactory.getLog(OracleDBInfoService.class);

    @Override
    public String getDatabaseName() {
        String name = super.getDatabaseName();
        try {
            String version = this.meta.getDatabaseMajorVersion() + ".";
            version = version + this.meta.getDatabaseMinorVersion();
            name = name + " [" + version + "]";
        }
        catch (SQLException e) {
            log.error((Object)("meta.getDatabaseMajorVersion\u51fa\u9519\uff1a" + e.getMessage()));
        }
        return name;
    }

    @Override
    public List<String> getSchemas() {
        List<String> schemas = super.getSchemas();
        try {
            String user = this.meta.getUserName();
            if (schemas.indexOf(user) > -1) {
                schemas.clear();
                schemas.add(user);
            }
        }
        catch (SQLException e) {
            log.error((Object)("meta.getUserName\u51fa\u9519\uff1a" + e.getMessage()));
        }
        return schemas;
    }

    @Override
    public List<String> getElementTypes() {
        return super.getElementTypes();
    }

    @Override
    public List<String> getElements(String schema, String ... types) {
        return super.getElements(schema, types);
    }

    @Override
    public String getLimitSQLString(String originalSQL) {
        return originalSQL;
    }

    @Override
    public boolean supportLimit() {
        return false;
    }
}

