/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe.service.impl;

import cn.com.qimingx.dbe.service.impl.AbstractDBInfoService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;

class HelperDBInfoServiceBase {
    private Log log;
    private boolean schema = true;
    private AbstractDBInfoService service;

    public HelperDBInfoServiceBase(AbstractDBInfoService service, Log log) {
        this.service = service;
        this.log = log;
    }

    public String getDatabaseName() {
        try {
            String name = this.service.meta.getDatabaseProductName();
            name = name.replaceAll("/", "-");
            return name;
        }
        catch (SQLException e) {
            this.log.error((Object)("meta.getDatabaseProductName.ERROR\uff1a" + e.getMessage()));
            return "--ERROR--";
        }
    }

    public List<String> getSchemas() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String schema;
            ResultSet rs = this.service.meta.getSchemas();
            while (rs.next()) {
                schema = rs.getString("TABLE_SCHEM");
                list.add(schema);
            }
            rs.close();
            if (list.size() == 0) {
                rs = this.service.meta.getCatalogs();
                while (rs.next()) {
                    schema = rs.getString("TABLE_CAT");
                    list.add(schema);
                }
                this.schema = false;
            }
            rs.close();
        }
        catch (SQLException e) {
            this.log.error((Object)("meta.getSchemas\u51fa\u9519\uff1a" + e.getMessage()));
        }
        return list;
    }

    public List<String> getElementTypes() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ResultSet rs = this.service.meta.getTableTypes();
            while (rs.next()) {
                String type = rs.getString("TABLE_TYPE");
                list.add(type);
            }
            rs.close();
        }
        catch (SQLException e) {
            this.log.error((Object)("meta.getTableTypes\u51fa\u9519\uff1a" + e.getMessage()));
        }
        return list;
    }

    public List<String> getElements(String schema, String ... types) {
        ArrayList<String> list = new ArrayList<String>();
        if (types.length == 0) {
            types = new String[]{"table"};
        }
        try {
            ResultSet rs = null;
            rs = this.isSchema() ? this.service.meta.getTables(null, schema, null, types) : this.service.meta.getTables(schema, null, null, types);
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                if (name.indexOf(47) > -1 || name.indexOf(36) > -1) continue;
                list.add(name);
            }
            rs.close();
        }
        catch (SQLException e) {
            this.log.error((Object)("meta.getTableNames\u51fa\u9519\uff1a" + e.getMessage()));
        }
        return list;
    }

    public boolean supportScrollableResultSet() {
        return true;
    }

    public boolean isSchema() {
        return this.schema;
    }

    public void setSchema(boolean schema) {
        this.schema = schema;
    }
}

