/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe.action;

import cn.com.qimingx.core.ProcessResult;
import cn.com.qimingx.dbe.DBConnectionState;
import cn.com.qimingx.dbe.DBEConfig;
import cn.com.qimingx.dbe.action.bean.ConnectParamBean;
import cn.com.qimingx.spring.BaseMultiActionController;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ofbiz.base.util.UtilHttp;
import org.ofbiz.base.util.UtilProperties;

public class InitActionController
extends BaseMultiActionController {
    private static final Log log = LogFactory.getLog(InitActionController.class);
    private static final String LOGIN_COOKIE_NAME = "dbelogin";
    private static final int LOGIN_ITEM_LENGTH = 5;

    public static void init(HttpServletRequest req, HttpServletResponse resp) {
        log.debug((Object)"call InitAction.init~~");
        HttpSession sess = req.getSession();
        boolean isLogin = DBConnectionState.isConnection(sess);
        JSONObject json = new JSONObject();
        json.element("success", true);
        json.element("login", isLogin);
        InitActionController.sendJSON(resp, json.toString());
    }

    public static void dbtypes(HttpServletRequest req, HttpServletResponse resp) {
        log.debug((Object)"call InitAction.dbtypes~~");
        String json = DBEConfig.getInstance().getDBTypeOptions();
        InitActionController.sendJSON(resp, json);
    }

    public static void history(HttpServletRequest req, HttpServletResponse resp) {
        log.debug((Object)"get login history~~");
        String historys = "";
        Cookie[] cookies = req.getCookies();
        Cookie cookie = null;
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(LOGIN_COOKIE_NAME)) continue;
                cookie = cookies[i];
            }
        }
        if (cookie != null) {
            String[] loginItems;
            log.debug((Object)("Saved history...:" + cookie.getValue()));
            for (String loginItem : loginItems = cookie.getValue().split("&")) {
                ConnectParamBean param = null;
                try {
                    param = ConnectParamBean.fromCookieValue(loginItem);
                }
                catch (Throwable e) {
                    log.warn((Object)("ConnectParamBean.fromCookieValue.error:" + e.getMessage() + "[" + loginItem + "]"));
                    continue;
                }
                if (historys.length() > 0) {
                    historys = historys + ",";
                }
                historys = historys + param.getHistoryRecord();
            }
        }
        String json = null;
        json = historys != null && historys.length() > 0 ? "{root:[" + historys + "]}" : "{root:[{ history:'" + UtilProperties.getMessage((String)"JdbexplorerUILabels", (String)"NoLoginHistory", (Locale)req.getLocale()) + "'}]}";
        InitActionController.sendJSON(resp, json);
    }

    public static void login(HttpServletRequest req, HttpServletResponse resp) {
        log.debug((Object)"call InitAction.login:");
        ConnectParamBean param = InitActionController.getConnectParamBean(req);
        InitActionController.login(req, resp, param);
    }

    public static void login(HttpServletRequest req, HttpServletResponse resp, ConnectParamBean param) {
        log.debug((Object)("call InitAction.login,param:" + param));
        ProcessResult<String> pr = DBConnectionState.connect(param, req.getSession(true));
        JSONObject json = new JSONObject();
        if (pr.isSuccess()) {
            json.element("success", true);
            InitActionController.storeConnectionParam(req, resp, param);
        } else {
            json.element("success", false);
            json.element("msg", (Object)pr.getMessage());
        }
        InitActionController.sendJSON(resp, json.toString());
    }

    public static void logout(HttpServletRequest req, HttpServletResponse resp) {
        DBConnectionState dbcs;
        log.debug((Object)"call InitAction.logout~~");
        HttpSession sess = req.getSession();
        if (sess != null && (dbcs = DBConnectionState.current(sess)) != null) {
            dbcs.destroy(sess);
            sess.invalidate();
        }
        JSONObject json = new JSONObject();
        json.element("success", true);
        InitActionController.sendJSON(resp, json.toString());
    }

    public static void load(HttpServletRequest req, HttpServletResponse resp) {
        String[] loginItems;
        log.debug((Object)"call InitAction.load~~");
        Cookie[] cookies = req.getCookies();
        Cookie cookie = null;
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(LOGIN_COOKIE_NAME)) continue;
                cookie = cookies[i];
            }
        }
        if (cookie != null && (loginItems = cookie.getValue().split("&")).length > 0) {
            JSONArray jsonData = new JSONArray();
            String value = loginItems[0];
            ConnectParamBean pb = ConnectParamBean.fromCookieValue(value);
            jsonData.add((Object)JSONSerializer.toJSON((Object)pb));
            JSONObject json = new JSONObject();
            json.element("success", true);
            json.element("data", (Collection)jsonData);
            InitActionController.sendJSON(resp, json.toString());
        }
    }

    public static void welcome(HttpServletRequest req, HttpServletResponse resp) {
        log.debug((Object)"call InitAction.welcome~~");
        HttpSession sess = req.getSession(true);
        DBConnectionState dbcs = DBConnectionState.current(sess);
        if (dbcs != null) {
            Locale locale = UtilHttp.getLocale((HttpServletRequest)req);
            JSON json = dbcs.getDBProperties(locale);
            InitActionController.sendJSON(resp, json.toString());
        } else {
            JSONObject json = new JSONObject();
            json.element("success", true);
            InitActionController.sendJSON(resp, json.toString());
        }
    }

    private static void storeConnectionParam(HttpServletRequest req, HttpServletResponse resp, ConnectParamBean param) {
        String value = param.toCookieValue();
        Cookie[] cookies = req.getCookies();
        Cookie cookie = null;
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(LOGIN_COOKIE_NAME)) continue;
                cookie = cookies[i];
            }
        }
        if (cookie == null) {
            log.debug((Object)"no saved history....");
            cookie = new Cookie(LOGIN_COOKIE_NAME, value);
        } else {
            log.debug((Object)"history exist, ready to create new history table~\uff1a");
            String[] historys = cookie.getValue().split("&");
            String current = value;
            int count = 1;
            for (String history : historys) {
                if (count == 5) break;
                if (current.equalsIgnoreCase(history)) continue;
                value = value + "&";
                value = value + history;
                ++count;
            }
            cookie.setValue(value);
        }
        cookie.setMaxAge(Integer.MAX_VALUE);
        resp.addCookie(cookie);
        log.debug((Object)("Store DBConnectionInfo To Cookie:" + value));
    }

    private static ConnectParamBean getConnectParamBean(HttpServletRequest req) {
        ConnectParamBean param = new ConnectParamBean();
        try {
            BeanUtils.populate((Object)param, (Map)req.getParameterMap());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return param;
    }
}

