/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe.action;

import cn.com.qimingx.core.ProcessResult;
import cn.com.qimingx.dbe.DBConnectionState;
import cn.com.qimingx.dbe.SQLQueryOperator;
import cn.com.qimingx.dbe.action.AbstractDbeActionController;
import cn.com.qimingx.dbe.action.bean.GridQueryLoadBean;
import cn.com.qimingx.dbe.service.DBInfoService;
import cn.com.qimingx.spring.UploadFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSON;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ofbiz.base.util.FileUtil;
import org.ofbiz.base.util.UtilGenerics;

public class DbeSQLQueryActionController
extends AbstractDbeActionController {
    private static final Log log = LogFactory.getLog(DbeSQLQueryActionController.class);
    private static SQLQueryOperator sqlQueryOperator = new SQLQueryOperator();

    public static void openSqlFile(HttpServletRequest req, HttpServletResponse resp) {
        UploadFile param = new UploadFile();
        try {
            BeanUtils.populate((Object)param, (Map)req.getParameterMap());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DbeSQLQueryActionController.openSqlFile(req, resp, param);
    }

    public static void openSqlFile(HttpServletRequest req, HttpServletResponse resp, UploadFile param) {
        log.debug((Object)("open sqlfile dbeSQLQueryAction.openSqlFile," + param));
        log.debug((Object)("param.getName():" + param.getName() + "param.getType():" + param.getType()));
        String elementId = req.getParameter("ELEMENTID");
        if (elementId == null) {
            elementId = "";
        }
        ServletFileUpload dfu = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory(10240, FileUtil.getFile((String)"runtime/tmp")));
        List lst = null;
        try {
            lst = UtilGenerics.checkList((Object)dfu.parseRequest(req));
        }
        catch (FileUploadException e) {
            e.printStackTrace();
        }
        FileItem fi = null;
        String str = "";
        for (int i = 0; i < lst.size(); ++i) {
            fi = (FileItem)lst.get(i);
            if (fi.isFormField()) continue;
            String fieldName = fi.getFieldName();
            String fileName = fi.getName();
            String contentType = fi.getContentType();
            boolean isInMemory = fi.isInMemory();
            long sizeInBytes = fi.getSize();
            byte[] data = fi.get();
            try {
                str = new String(data, "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            break;
        }
        DbeSQLQueryActionController.sendJSON(resp, "ELEMENTID:" + elementId + "@" + str.toString());
    }

    public static void execSqlFile(HttpServletRequest req, HttpServletResponse resp) {
        UploadFile param = new UploadFile();
        try {
            BeanUtils.populate((Object)param, (Map)req.getParameterMap());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DbeSQLQueryActionController.execSqlFile(req, resp, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execSqlFile(HttpServletRequest req, HttpServletResponse resp, UploadFile param) {
        block9: {
            log.debug((Object)("execute sqlfile dbeSQLQueryAction.execSqlFile," + param));
            log.debug((Object)("param.getName():" + param.getName() + "param.getType():" + param.getType()));
            ProcessResult<DBConnectionState> prDBCS = DbeSQLQueryActionController.checkLogin(req);
            if (prDBCS.isFailing()) {
                log.error((Object)prDBCS.getMessage());
                DbeSQLQueryActionController.sendJSON(resp, prDBCS.toJSON());
                return;
            }
            File file = DbeSQLQueryActionController.workDirectory(req).newFile("temp.sql", null);
            FileOutputStream output = null;
            InputStream input = null;
            try {
                output = new FileOutputStream(file);
                ServletFileUpload dfu = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory(10240, FileUtil.getFile((String)"runtime/tmp")));
                List lst = null;
                lst = UtilGenerics.checkList((Object)dfu.parseRequest(req));
                FileItem fi = null;
                Object fileName = null;
                long sizeInBytes = 0L;
                for (int i = 0; i < lst.size(); ++i) {
                    fi = (FileItem)lst.get(i);
                    if (fi.isFormField()) continue;
                    input = fi.getInputStream();
                    sizeInBytes = fi.getSize();
                    break;
                }
                byte[] buf = new byte[(int)sizeInBytes];
                int length = input.read(buf);
                ((OutputStream)output).write(buf);
                DBInfoService service = prDBCS.getData().getDBInfoService();
                ProcessResult<String> pr = service.executeByFile(file);
                if (!pr.isSuccess()) {
                    DbeSQLQueryActionController.sendErrorJSON(resp, pr.toJSON());
                } else {
                    DbeSQLQueryActionController.sendJSON(resp, pr.getData().toString());
                }
                IOUtils.closeQuietly((InputStream)input);
            }
            catch (Exception e) {
                log.debug((Object)("execSqlFile.error:" + e.getMessage()));
                DbeSQLQueryActionController.sendErrorJSON(resp, e.getMessage());
                break block9;
            }
            finally {
                IOUtils.closeQuietly(input);
                IOUtils.closeQuietly((OutputStream)output);
            }
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    public static void query(HttpServletRequest req, HttpServletResponse resp) {
        GridQueryLoadBean param = new GridQueryLoadBean();
        try {
            BeanUtils.populate((Object)param, (Map)req.getParameterMap());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DbeSQLQueryActionController.query(req, resp, param);
    }

    public static void query(HttpServletRequest req, HttpServletResponse resp, GridQueryLoadBean param) {
        log.debug((Object)("call dbeSQLQueryAction.query," + param));
        ProcessResult<DBConnectionState> prDBCS = DbeSQLQueryActionController.checkLogin(req);
        if (prDBCS.isFailing()) {
            log.error((Object)prDBCS.getMessage());
            DbeSQLQueryActionController.sendJSON(resp, prDBCS.toJSON());
            return;
        }
        DBInfoService service = prDBCS.getData().getDBInfoService();
        ProcessResult<JSON> pr = sqlQueryOperator.execute(service, param);
        if (pr.isSuccess()) {
            JSON json = pr.getData();
            DbeSQLQueryActionController.sendJSON(resp, json.toString());
        } else {
            DbeSQLQueryActionController.sendErrorJSON(resp, pr.toJSON());
        }
    }

    public static void saveAsSQL(HttpServletRequest req, HttpServletResponse resp) {
        String fileName = "NewSQLDocument.sql";
        String sql = req.getParameter("sql");
        sql = sql == null ? "" : sql;
        log.debug((Object)("call dbeSQLQueryAction.saveasfile.sql:" + sql));
        DbeSQLQueryActionController.download(resp, fileName, sql.getBytes());
    }
}

