/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe;

import cn.com.qimingx.utils.ExtTypeInfo;
import cn.com.qimingx.utils.SQLTypeUtils;

public class TableColumnInfo {
    private String name;
    private int type;
    private String typeName;
    private int size;
    private int digits;
    private boolean nullable;
    private String defaultValue;
    private ExtTypeInfo extType;
    private boolean pkColumn = false;
    private boolean fkColumn = false;
    private FKColumnInfo fkInfo = null;
    private String comment;

    public TableColumnInfo() {
    }

    public TableColumnInfo(String name, int type, int size, boolean nullable) {
        this.name = name;
        this.type = type;
        this.typeName = SQLTypeUtils.getJdbcTypeName(type);
        this.size = size;
        this.nullable = nullable;
        this.extType = new ExtTypeInfo(type);
    }

    public boolean isPkColumn() {
        return this.pkColumn;
    }

    public void setPkColumn(boolean pkColumn) {
        this.pkColumn = pkColumn;
    }

    public boolean isFkColumn() {
        return this.fkColumn;
    }

    public void setFkColumn(boolean fkColumn) {
        this.fkColumn = fkColumn;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.typeName = SQLTypeUtils.getJdbcTypeName(type);
        this.extType = new ExtTypeInfo(type);
        this.type = type;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setExtType(ExtTypeInfo extType) {
        this.extType = extType;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public FKColumnInfo getFkInfo() {
        return this.fkInfo;
    }

    public void setFkInfo(FKColumnInfo fkInfo) {
        this.fkInfo = fkInfo;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public int getDigits() {
        return this.digits;
    }

    public void setDigits(int digits) {
        this.digits = digits;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public ExtTypeInfo getExtType() {
        if (this.extType == null) {
            this.extType = new ExtTypeInfo(this.type);
        }
        return this.extType;
    }

    public static class FKColumnInfo {
        private String table;
        private String column;

        public FKColumnInfo(String table, String column) {
            this.table = table;
            this.column = column;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public String getColumn() {
            return this.column;
        }

        public void setColumn(String column) {
            this.column = column;
        }
    }
}

