/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe;

import cn.com.qimingx.core.ProcessResult;
import cn.com.qimingx.dbe.LobObject;
import cn.com.qimingx.dbe.TableDataInfo;
import cn.com.qimingx.dbe.TableInfo;
import cn.com.qimingx.dbe.action.bean.DataExportBean;
import cn.com.qimingx.dbe.action.bean.GridTableFieldInfoBean;
import cn.com.qimingx.dbe.action.bean.GridTableLoadBean;
import cn.com.qimingx.dbe.action.bean.GridTableLongFieldInfoBean;
import cn.com.qimingx.dbe.action.bean.GridTableUpdateBean;
import cn.com.qimingx.dbe.action.bean.GridTableUpdateInfoBean;
import cn.com.qimingx.dbe.action.bean.PkColumnObject;
import cn.com.qimingx.dbe.service.DBInfoService;
import cn.com.qimingx.dbe.service.WorkDirectory;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GridOperator {
    private static final Log log = LogFactory.getLog(GridOperator.class);

    public ProcessResult<JSON> load(DBInfoService service, GridTableLoadBean param) {
        String type = param.getType();
        if (type.equalsIgnoreCase("table") || type.equalsIgnoreCase("view")) {
            return this.getTableData(service, param);
        }
        ProcessResult<JSON> pr = new ProcessResult<JSON>(true);
        pr.setData((JSON)new JSONArray());
        return pr;
    }

    private ProcessResult<JSON> getTableData(DBInfoService service, GridTableLoadBean param) {
        ProcessResult<JSON> pr = new ProcessResult<JSON>();
        String schema = param.getSchema();
        String name = param.getNodeName();
        int start = param.getStart();
        int limit = param.getLimit();
        String cond = param.getSearchCondition();
        log.debug((Object)("Search Condition:" + cond));
        ProcessResult<TableDataInfo> prData = service.getTableData(schema, name, start, limit, cond);
        if (prData.isFailing()) {
            pr.setMessage(prData.getMessage());
            return pr;
        }
        TableDataInfo data = prData.getData();
        JSONArray rows = new JSONArray();
        for (Map<String, Object> row : data.getRows()) {
            JSONObject jsonData = new JSONObject();
            for (String key : row.keySet()) {
                jsonData.element(key, row.get(key));
            }
            rows.add((Object)jsonData);
        }
        JSONObject json = new JSONObject();
        json.element("total", data.getTotal());
        json.element("rows", (Collection)rows);
        pr.setSuccess(true);
        pr.setData((JSON)json);
        return pr;
    }

    public ProcessResult<String> updateBlob(DBInfoService service, GridTableLongFieldInfoBean param, File file) {
        String t = param.getTablename();
        String f = param.getField();
        List<PkColumnObject> pks = param.getPkList();
        ProcessResult<String> pr = service.updateBLob(t, pks, f, file);
        return pr;
    }

    public ProcessResult<String> updateClob(DBInfoService service, GridTableFieldInfoBean param, String clob) {
        String t = param.getTablename();
        String f = param.getField();
        List<PkColumnObject> pks = param.getPkList();
        ProcessResult<String> pr = service.updateCLob(t, pks, f, clob);
        return pr;
    }

    public ProcessResult<String> update(DBInfoService service, GridTableUpdateBean param) {
        ProcessResult<String> pr = new ProcessResult<String>(false);
        try {
            GridTableUpdateInfoBean update = param.getTableUpdate();
            HashMap<String, Object> params = new HashMap<String, Object>();
            String where = "";
            for (PkColumnObject pk : update.getPkList()) {
                if (where.length() > 0) {
                    where = where + " and ";
                }
                where = where + pk.getPk() + "=:" + pk.getPk();
                params.put(pk.getPk(), pk.getPkValueObject());
            }
            String sql = "update " + param.getElementName();
            sql = sql + " SET " + update.getField() + "=:" + update.getField();
            sql = sql + " where (" + where + ")";
            log.debug((Object)("table.update.sql:" + sql));
            GridTableUpdateInfoBean.UpdateValue value = update.getUpdateValue();
            params.put(update.getField(), value.getValue());
            return service.executeUpdate(sql, params);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)("execTable.update Error:" + msg));
            pr.setMessage(msg);
            return pr;
        }
    }

    public ProcessResult<String> remove(DBInfoService service, GridTableUpdateBean params) {
        List<PkColumnObject> pkList = params.getTableUpdate().getPkList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String where = "";
        String first = null;
        for (int i = 0; i < pkList.size(); ++i) {
            PkColumnObject pk = pkList.get(i);
            if (first == null) {
                first = pk.getPk();
            } else if (first.equalsIgnoreCase(pk.getPk())) {
                where = where + ")or(";
            } else if (where.length() > 0) {
                where = where + " and ";
            }
            String pkVarName = pk.getPk() + i;
            where = where + pk.getPk() + "=:" + pkVarName;
            map.put(pkVarName, pk.getPkValueObject());
        }
        String sql = "delete from " + params.getElementName();
        sql = sql + " where (" + where + ")";
        log.debug((Object)("table.remove.sql:" + sql));
        return service.executeUpdate(sql, map);
    }

    public ProcessResult<JSON> readLob(DBInfoService service, GridTableFieldInfoBean param, WorkDirectory work) {
        String t = param.getTablename();
        String f = param.getField();
        List<PkColumnObject> pks = param.getPkList();
        ProcessResult<LobObject> lobPr = service.readLob(t, pks, f, work);
        ProcessResult<JSON> pr = new ProcessResult<JSON>(false);
        if (lobPr.isSuccess()) {
            String type = lobPr.getData().isBLOB() ? "BLOB" : "CLOB";
            JSONObject json = new JSONObject();
            json.element("success", true);
            json.element("type", (Object)type);
            json.element("isNull", lobPr.getData().isNull());
            if (lobPr.getData().isNull()) {
                json.element("name", (Object)"null");
                json.element("isImage", false);
            } else {
                json.element("name", (Object)lobPr.getData().getValue().getName());
                json.element("isImage", lobPr.getData().isImage());
            }
            pr.setSuccess(true);
            pr.setData((JSON)json);
        } else {
            pr.setMessage(lobPr.getMessage());
        }
        return pr;
    }

    public ProcessResult<JSON> export(DBInfoService service, DataExportBean param, WorkDirectory wd) {
        ProcessResult<JSON> pr = new ProcessResult<JSON>();
        String sql = param.getSql();
        if (sql == null || sql.length() < 1) {
            sql = "";
            for (String field : param.getFields()) {
                if (sql.length() > 0) {
                    sql = sql + ",";
                }
                sql = sql + field;
            }
            sql = "select " + sql + " from " + param.getElementName();
            log.debug((Object)("Table Export,sql:" + sql));
        } else {
            log.debug((Object)("Query Export,sql:" + sql));
        }
        int startNo = param.getStartPageNo();
        int endNo = param.getEndPageNo();
        int pageRange = endNo - startNo + 1;
        int start = startNo == 1 ? 1 : (startNo - 1) * param.getLimit() + 1;
        int limit = pageRange * param.getLimit();
        log.debug((Object)("start\uff1a" + start + ",limit:" + limit));
        ProcessResult<TableInfo> tpr = service.executeQuery(sql, start, limit, null);
        if (tpr.isFailing()) {
            pr.setFailing(true);
            pr.setMessage(tpr.getMessage());
            return pr;
        }
        TableInfo table = tpr.getData();
        if (param.getElementName() != null) {
            table.setTableName(param.getElementName());
        } else {
            table.setTableName("NotTableName");
        }
        ProcessResult<File> fpr = table.makeDataFile(param.getFormatType(), wd);
        if (fpr.isFailing()) {
            pr.setSuccess(false);
            pr.setMessage(fpr.getMessage());
            return pr;
        }
        String fileName = fpr.getData().getName();
        log.debug((Object)("export to:" + fpr.getData().getAbsolutePath()));
        JSONObject json = new JSONObject();
        json.element("success", true);
        json.element("file", (Object)fileName);
        pr.setData((JSON)json);
        pr.setSuccess(true);
        return pr;
    }

    public ProcessResult<JSON> getFKValues(DBInfoService service, String table, String field) {
        String sql = "select " + field + " from " + table;
        log.debug((Object)("getFKValues.sql:" + sql));
        ProcessResult<TableInfo> prTableInfo = service.executeQuery(sql, -1, -1, null);
        JSONArray jsonArray = new JSONArray();
        if (prTableInfo.isSuccess()) {
            TableDataInfo data = prTableInfo.getData().getData();
            List<Map<String, Object>> list = data.getRows();
            for (Map<String, Object> row : list) {
                JSONObject jsonRow = new JSONObject();
                jsonRow.element("key", row.get(field));
                jsonRow.element("value", row.get(field));
                jsonArray.add((Object)jsonRow);
            }
        }
        JSONObject json = new JSONObject();
        json.element("fkvalues", (Collection)jsonArray);
        ProcessResult<JSON> pr = new ProcessResult<JSON>(true);
        pr.setData((JSON)json);
        return pr;
    }
}

