/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.dbe;

import cn.com.qimingx.json.MyJSONUtils;
import cn.com.qimingx.utils.ExtTypeInfo;
import cn.com.qimingx.utils.SQLTypeUtils;
import net.sf.json.JSON;

public class FieldDataType {
    private String typeName;
    private int typeIndex;
    private ExtTypeInfo extType;
    private boolean resetLength = true;
    private boolean resetScale = false;

    public static void main(String[] args) {
        FieldDataType fdt = new FieldDataType("SMALLINT");
        System.out.println(fdt.toJSON());
        fdt = new FieldDataType("INTEGER");
        System.out.println(fdt.toJSON());
        fdt = new FieldDataType("NUMERIC");
        System.out.println(fdt.toJSON());
        fdt = new FieldDataType("TimeStamp");
        System.out.println(fdt.toJSON());
    }

    public FieldDataType(String type) {
        this.typeName = type;
        this.typeIndex = SQLTypeUtils.getJdbcType(type);
        if (this.typeIndex != 0) {
            this.extType = new ExtTypeInfo(this.typeIndex);
            this.resetLength = this.extType.isDateType() ? false : (this.extType.isNumberType() ? this.typeIndex == 3 || this.typeIndex == 2 : true);
            this.resetScale = this.extType.isNumberType() ? this.typeIndex == 3 || this.typeIndex == 2 : false;
        }
    }

    public FieldDataType(String type, boolean resetLength) {
        this(type);
        this.setResetLength(resetLength);
    }

    public JSON toJSON() {
        JSON json = MyJSONUtils.toJsonExclude(this, new String[0]);
        return json;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setResetLength(boolean resetLength) {
        this.resetLength = resetLength;
    }

    public void setResetScale(boolean resetScale) {
        this.resetScale = resetScale;
    }

    public boolean isResetLength() {
        return this.resetLength;
    }

    public boolean isResetScale() {
        return this.resetScale;
    }
}

