/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.ofbiz.attendance.punch;

import javax.mail.internet.MimeMessage;
import javax.transaction.xa.XAException;

import javolution.util.FastMap;
import java.util.regex.*;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.io.*;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.*;
import java.lang.String.*;
import javolution.util.FastList;
import javolution.util.FastMap;
import java.sql.Time;
import org.ofbiz.base.util.Debug;
import org.ofbiz.base.util.UtilDateTime;
import org.ofbiz.base.util.UtilMisc;
import org.ofbiz.base.util.UtilProperties;
import org.ofbiz.base.util.UtilValidate;
import org.ofbiz.entity.GenericDelegator;
import org.ofbiz.entity.GenericEntityException;
import org.ofbiz.entity.GenericValue;
import org.ofbiz.entity.condition.EntityCondition;
import org.ofbiz.entity.condition.EntityConditionList;
import org.ofbiz.entity.condition.EntityExpr;
import org.ofbiz.entity.condition.EntityFieldValue;
import org.ofbiz.entity.condition.EntityFunction;
import org.ofbiz.entity.condition.EntityOperator;
import org.ofbiz.entity.model.DynamicViewEntity;
import org.ofbiz.entity.model.ModelKeyMap;
import org.ofbiz.entity.util.EntityFindOptions;
import org.ofbiz.entity.util.EntityListIterator;
import org.ofbiz.entity.util.EntityTypeUtil;
import org.ofbiz.entity.util.EntityUtil;
import org.ofbiz.service.DispatchContext;
import org.ofbiz.service.GenericServiceException;
import org.ofbiz.service.LocalDispatcher;
import org.ofbiz.service.ModelService;
import org.ofbiz.service.ServiceUtil;
import org.ofbiz.service.ServiceDispatcher;

/**
 * Services for Party-punches maintenance
 */

public class PunchServices {

	public static final String module = PunchServices.class.getName();

	public static Map emplpunch(DispatchContext dctx, Map context)

	{
		GenericDelegator delegator = (GenericDelegator) dctx.getDelegator();
		LocalDispatcher dispatcher = dctx.getDispatcher();
		Locale locale = (Locale) context.get("locale");
		// String emplPunchId = (String) delegator.getNextSeqId("EmplPunch");
		// String emplPunchId = null;
		int PunchId = 0;
		String partyId = (String) context.get("partyId");
		String emplPunchId = (String) context.get("emplPunchId");
		Date punchdate = (Date) context.get("punchdate");
		Time punchtime = (Time) context.get("punchtime");
		String PunchType = (String) context.get("PunchType");
		String inout = (String) context.get("InOut");
		String note = (String) context.get("Note");
		String flag = "out";
		String date3 = punchdate.toString();
		String dateArr2[] = date3.split(Pattern.quote("-"));
		String contactMechId = null;
		GenericValue userLogin = (GenericValue) context.get("userLogin");
		int sec = 0, sec0 = 0, sec1 = 0;
		int min = 0, min0 = 0, min1 = 0;
		int hr = 0, hr0 = 0, hr1 = 0;

		String punchout = punchtime.toString();
		String punchintime = null;
		String punchouttime = null;

//		System.out.println("===================year==>[ " + dateArr2[0] + "]===== [ " + dateArr2[1] + "]======= [ " + dateArr2[2] + "]====\n\n");
		int dai = Integer.parseInt(dateArr2[2]);
//		System.out.println("===================[ " + dai + " ]=================\n\n");
		int res = dai % 7;
		if ((dai % 7) != 0) {
			PunchId = res;
		} else {
			PunchId = 7;
		}
//		System.out.println("==================this is before entering function [ " + emplPunchId + " ]  =================\n\n");

		if (emplPunchId == null) {
			try {

	            EntityConditionList<EntityExpr> conditionList = EntityCondition.makeCondition(EntityOperator.AND,
	                    EntityCondition.makeCondition("partyId", EntityOperator.EQUALS, partyId),
	                    EntityCondition.makeCondition("PunchType", EntityOperator.EQUALS, PunchType),
	                    EntityCondition.makeCondition("punchdate", EntityOperator.EQUALS, punchdate),
	                    EntityCondition.makeCondition("InOut", EntityOperator.EQUALS, inout));
	            EntityConditionList<EntityExpr> conditionList1 = EntityCondition.makeCondition(EntityOperator.AND,
	                    EntityCondition.makeCondition("partyId", EntityOperator.EQUALS, partyId),
	                    EntityCondition.makeCondition("PunchType", EntityOperator.EQUALS, PunchType),
	                    EntityCondition.makeCondition("punchdate", EntityOperator.EQUALS, punchdate));
	            Collection<GenericValue> tops1 = delegator.findList("EmplPunch", conditionList1, null, null, null, false);

				if (tops1.size() > 0) {
					if ((tops1.size() % 2 == 1) && inout.equals("IN")) {
						return ServiceUtil.returnError(UtilProperties.getMessage("AttendanceUiLabels", "AttendancePunchOutBeforeIn", locale));
					}
				}

	            Collection<GenericValue> tops = delegator.findList("EmplPunch", conditionList, null, null, null, false);

				if (tops.size() == 0) {
					emplPunchId = new Integer(PunchId).toString();
				} else {
					int e = tops.size();
					PunchId = PunchId + 7 * e;
					emplPunchId = new Integer(PunchId).toString();
//					System.out.println("==================number of records [ " + e + " ]  =================\n\n");
				}

//				System.out.println("==================value of punches [ " + emplPunchId + " ]  =================\n\n");

			} catch (GenericEntityException e) {
				return ServiceUtil.returnError(UtilProperties.getMessage("AttendanceUiLabels", "AttendanceEmplPunchIdGenarateError", locale));
			}

		}

		try {

            EntityConditionList<EntityExpr> conditionList2 = EntityCondition.makeCondition(EntityOperator.AND,
                    EntityCondition.makeCondition("partyId", EntityOperator.EQUALS, partyId),
                    EntityCondition.makeCondition("PunchType", EntityOperator.EQUALS, "Normal"),
                    EntityCondition.makeCondition("punchdate", EntityOperator.EQUALS, punchdate));
            Collection<GenericValue> south = delegator.findList("EmplPunch", conditionList2, null, null, null, false);

//			System.out.println("===================[ " + punchdate + " ]=================\n\n");
//			System.out.println("===================[ " + south.size() + " ]=================\n\n");
//			System.out.println("===================[ " + flag + " ]=================\n\n");
			int sub = south.size();

			if (sub % 2 == 0) {

				if (!PunchType.equals("Normal")) {

//					System.out.println("===================[ " + flag + " ]=================\n\n");
					return ServiceUtil.returnError(UtilProperties.getMessage("AttendanceUiLabels", "AttendanceNoNormalPunchError", UtilMisc.toMap("PunchType", PunchType), locale));
				}
			}
		} catch (GenericEntityException e) {
			return ServiceUtil.returnError(UtilProperties.getMessage("AttendanceUiLabels", "AttendancePunchTypeError", UtilMisc.toMap("PunchType", PunchType), locale));
		}

		try {

            EntityConditionList<EntityExpr> conditionListb = EntityCondition.makeCondition(EntityOperator.AND,
                    EntityCondition.makeCondition("partyId", EntityOperator.EQUALS, partyId),
                    EntityCondition.makeCondition("PunchType", EntityOperator.EQUALS, "Break"),
                    EntityCondition.makeCondition("punchdate", EntityOperator.EQUALS, punchdate));
            Collection<GenericValue> brk = delegator.findList("EmplPunch", conditionListb, null, null, null, false);

//			System.out.println("===================[ " + punchdate + " ]=================\n\n");
//			System.out.println("===================[ " + brk.size() + " ]=================\n\n");
			// System.out.println("===================[ " + flag +" ]=================\n\n");
			int subb = brk.size();

			if (subb % 2 != 0) {

				if (!PunchType.equals("Break")) {

//					System.out.println("===================[ " + flag + " ]=================\n\n");
					return ServiceUtil.returnError(UtilProperties.getMessage("AttendanceUiLabels", "AttendancePunchOutFirstError", UtilMisc.toMap("PunchType", "Break"), locale));
				}
			}
		} catch (GenericEntityException e) {
			return ServiceUtil.returnError(UtilProperties.getMessage("AttendanceUiLabels", "AttendancePunchTypeError", UtilMisc.toMap("PunchType", PunchType), locale));
		}

		try {

            EntityConditionList<EntityExpr> conditionListl = EntityCondition.makeCondition(EntityOperator.AND,
                    EntityCondition.makeCondition("partyId", EntityOperator.EQUALS, partyId),
                    EntityCondition.makeCondition("PunchType", EntityOperator.EQUALS, "Lunch"),
                    EntityCondition.makeCondition("punchdate", EntityOperator.EQUALS, punchdate));
            Collection<GenericValue> lun = delegator.findList("EmplPunch", conditionListl, null, null, null, false);

//			System.out.println("===================[ " + punchdate + " ]=================\n\n");
//			System.out.println("===================[ " + lun.size() + " ]=================\n\n");
			// System.out.println("===================[ " + flag +" ]=================\n\n");
			int subl = lun.size();

			if (subl % 2 != 0) {

				if (!PunchType.equals("Lunch")) {

//					System.out.println("===================[ " + flag + " ]=================\n\n");
					return ServiceUtil.returnError(UtilProperties.getMessage("AttendanceUiLabels", "AttendancePunchOutFirstError", UtilMisc.toMap("PunchType", "Lunch"), locale));
				}
			}
		} catch (GenericEntityException e) {
			return ServiceUtil.returnError(UtilProperties.getMessage("AttendanceUiLabels", "AttendancePunchTypeError", UtilMisc.toMap("PunchType", PunchType), locale));
		}

		try {

            EntityConditionList<EntityExpr> conditionList = EntityCondition.makeCondition(EntityOperator.AND,
                    EntityCondition.makeCondition("partyId", EntityOperator.EQUALS, partyId),
                    EntityCondition.makeCondition("PunchType", EntityOperator.EQUALS, PunchType),
                    EntityCondition.makeCondition("punchdate", EntityOperator.EQUALS, punchdate));
            Collection<GenericValue> check = delegator.findList("EmplPunch", conditionList, null, null, null, false);

//			System.out.println("===================[ " + punchdate + " ]=================\n\n");
//			System.out.println("===================[ " + check.size() + " ]=================\n\n");
//			System.out.println("===================[ " + flag + " ]=================\n\n");

			if (check.size() == 0) {

				if (inout.equals("OUT")) {

//					System.out.println("===================[ " + flag + " ]=================\n\n");
					return ServiceUtil.returnError(UtilProperties.getMessage("AttendanceUiLabels", "AttendanceNoPunchInError", locale));
				}
			}
		} catch (GenericEntityException e) {
			return ServiceUtil.returnError(UtilProperties.getMessage("AttendanceUiLabels", "AttendancePunchTypeError", UtilMisc.toMap("PunchType", PunchType), locale));
		}

		// This is to send email to admin if employee punch in after specified
		// time
		try {

			List exprList = UtilMisc.toList(EntityCondition.makeCondition(
					"partyId", EntityOperator.EQUALS, partyId), EntityCondition
					.makeCondition("contactMechTypeId", EntityOperator.EQUALS,
							"EMAIL_ADDRESS"));
			EntityCondition condition = EntityCondition.makeCondition(exprList,
					EntityOperator.AND);
			List tasks = delegator.findList("ContactPersonDetails", condition,
					null, null, null, false);
			List requirements = FastList.newInstance();
			for (Iterator iter = tasks.iterator(); iter.hasNext();) {
				Map union = FastMap.newInstance();
				GenericValue requirement = (GenericValue) iter.next();
				contactMechId = requirement.getString("contactMechId");
			}

            EntityConditionList<EntityExpr> conditionListemail = EntityCondition.makeCondition(EntityOperator.AND,
                    EntityCondition.makeCondition("partyId", EntityOperator.EQUALS, partyId),
                    EntityCondition.makeCondition("PunchType", EntityOperator.EQUALS, "Normal"),
                    EntityCondition.makeCondition("punchdate", EntityOperator.EQUALS, punchdate));
            Collection<GenericValue> notiemail = delegator.findList("EmplPunch", conditionListemail, null, null, null, false);

			if (notiemail.size() == 0) {

				String firstpunchtime = punchtime.toString();
				String subpunchtime[] = firstpunchtime.split(":");
				int hrpunchtime = Integer.parseInt(subpunchtime[0]);
				int minpunchtime = Integer.parseInt(subpunchtime[1]);
				int secpunchtime = Integer.parseInt(subpunchtime[2]);
//				System.out.println("\n\n\n=====split time==" + hrpunchtime + "=====" + minpunchtime + "====" + secpunchtime + "===\n\n\n");

				Collection<GenericValue> var1 = delegator.findList("Notification", null, null,
						null, null, false);
				Iterator t1 = var1.iterator();
				while (t1.hasNext()) {
					GenericValue gvar1 = (GenericValue) t1.next();
					String pruleid = gvar1.getString("inputParamEnumId");
//					System.out.println("\n\n=======================this is productpriceruleid=======" + pruleid + "=============\n\n\n");
					EntityExpr condition_punchin2 = EntityCondition
							.makeCondition("inputParamEnumId",
									EntityOperator.EQUALS, "LATE_PUNCH");
					Collection<GenericValue> var2 = delegator.findList("Notification",
							condition_punchin2, null, null, null, false);
					Iterator t2 = var2.iterator();
					while (t2.hasNext()) {

						GenericValue gvar2 = (GenericValue) t2.next();
						String operatorEnumId = gvar2
								.getString("operatorEnumId");
						String condValue = gvar2.getString("condValue");
						int lenofcondValue = condValue.length();
						int minvalue = 59;
						int hrvalue = 0;
						if (lenofcondValue > 2) {
							String scondValue[] = condValue.split(":");
							hrvalue = Integer.parseInt(scondValue[0]);
							minvalue = Integer.parseInt(scondValue[1]);
						}
//						System.out.println("\n=======================this is operatorEnumId=======" + operatorEnumId + "=============\n\n\n");
//						System.out.println("\n=======================this is condValue=======" + condValue + "=============\n\n\n");
						if (lenofcondValue <= 2) {
							hrvalue = Integer.parseInt(condValue);
						}
						if (operatorEnumId.equals("IS_AFT")) {
//							System.out.println("\n==================yes condition is is after==============================");
							if ((hrpunchtime > hrvalue)
									|| ((hrpunchtime == hrvalue) && (minpunchtime > minvalue))) {

								// String user=userLogin.toString();
								String tm = punchtime.toString();
								String content = "Employee Punched In Very late......Punched in at "
										+ tm;
								Map commEventMap = FastMap.newInstance();
								commEventMap.put("communicationEventTypeId",
										"AUTO_EMAIL_COMM");
								commEventMap.put("statusId", "COM_IN_PROGRESS");
								commEventMap.put("contactMechTypeId",
										"EMAIL_ADDRESS");
								commEventMap.put("partyIdFrom", partyId);
								commEventMap.put("partyIdTo", "admin");
								commEventMap.put("contactMechIdFrom",
										contactMechId);
								commEventMap.put("contactMechIdTo", "admin");
								commEventMap.put("datetimeStarted",
										UtilDateTime.nowTimestamp());
								commEventMap.put("datetimeEnded",
										UtilDateTime.nowTimestamp());
								commEventMap.put("subject", "Late Punch");
								commEventMap.put("content", content);
								commEventMap.put("userLogin", userLogin);
								commEventMap.put("contentMimeTypeId",
										"text/html");
								Map<String, Object> createResp = null;
								try {
									createResp = dispatcher.runSync(
											"createCommunicationEvent",
											commEventMap);
								} catch (GenericServiceException e) {
									Debug.logError(e, module);
									return ServiceUtil.returnError(e.getMessage());
								}
								if (ServiceUtil.isError(createResp)) {
									return ServiceUtil.returnError(ServiceUtil.getErrorMessage(createResp));
								}

//								System.out.println("\n===========yes it is really greater...=========================== ");
							}

						}

					}
					break;
				}

			} else {

//				System.out.println("\n\n\n===========================size is greater than zero========================\n\n\n");
			}

		} catch (GenericEntityException e) {
			return ServiceUtil.returnError(UtilProperties.getMessage("AttendanceUiLabels", "AttendancePunchTypeError", UtilMisc.toMap("PunchType", PunchType), locale));
		}

		// This is to send mail if employee took more than 1hr for lunch
		try {
			List exprList = UtilMisc.toList(EntityCondition.makeCondition(
					"partyId", EntityOperator.EQUALS, partyId), EntityCondition
					.makeCondition("contactMechTypeId", EntityOperator.EQUALS,
							"EMAIL_ADDRESS"));
			EntityCondition condition = EntityCondition.makeCondition(exprList,
					EntityOperator.AND);
			List tasks = delegator.findList("ContactPersonDetails", condition,
					null, null, null, false);
			List requirements = FastList.newInstance();
			for (Iterator iter = tasks.iterator(); iter.hasNext();) {
				Map union = FastMap.newInstance();
				GenericValue requirement = (GenericValue) iter.next();
				contactMechId = requirement.getString("contactMechId");
			}
		} catch (GenericEntityException e) {
			return ServiceUtil.returnError(UtilProperties.getMessage("AttendanceUiLabels", "AttendanceFindContactMechIdError", locale));
		}

		if (PunchType.equals("Lunch")) {
			if (inout.equals("OUT")) {

				try {

		            EntityConditionList<EntityExpr> conditionList = EntityCondition.makeCondition(EntityOperator.AND,
		                    EntityCondition.makeCondition("partyId", EntityOperator.EQUALS, partyId),
		                    EntityCondition.makeCondition("PunchType", EntityOperator.EQUALS, "Lunch"),
		                    EntityCondition.makeCondition("punchdate", EntityOperator.EQUALS, punchdate),
		                    EntityCondition.makeCondition("InOut", EntityOperator.EQUALS, "IN"));
		            Collection<GenericValue> tasks = delegator.findList("EmplPunch", conditionList, null, null, null, false);

					if (tasks.size() > 0) {
						Iterator tr = tasks.iterator();
						while (tr.hasNext()) {
							GenericValue supr = (GenericValue) tr.next();
							punchintime = supr.getString("punchtime");

						}
					}
					if (tasks.size() > 0) {
//						System.out.println("=============== [" + tasks.size() + "]===========> ");
//						System.out.println("=========partyid====== [" + partyId + "]==================> ");
//						System.out.println("===========In time for lunch ==== [" + punchintime + "]-------------- ");
						// String Intime = punchintime.toString();
						String dateArr[] = punchintime
								.split(Pattern.quote(":"));
						sec0 = Integer.parseInt(dateArr[2]);
						min0 = Integer.parseInt(dateArr[1]);
						hr0 = Integer.parseInt(dateArr[0]);
//						System.out.println("===================IN time ==>[ " + dateArr[0] + "]===== [ " + dateArr[1] + "]======= [ " + dateArr[2] + "]====\n\n");
					}

				} catch (GenericEntityException e) {

					return ServiceUtil.returnError(UtilProperties.getMessage("AttendanceUiLabels", "AttendanceReadPunchInTimeError", locale));

				}

				/*
				 * try { List conditionList1 = UtilMisc.toList( new
				 * EntityExpr("partyId", EntityOperator.EQUALS, partyId), new
				 * EntityExpr("PunchType",EntityOperator.EQUALS, "Lunch"), new
				 * EntityExpr("punchdate", EntityOperator.EQUALS, punchdate),
				 * new EntityExpr("InOut", EntityOperator.EQUALS, "OUT")); List
				 * tasks3=delegator.findByCondition("EmplPunch", new
				 * EntityConditionList(conditionList1,EntityOperator.AND), null,
				 * null);
				 * 
				 * 
				 * if(tasks3.size() > 0) { Iterator ltr = tasks3.iterator();
				 * while (ltr.hasNext()) { GenericValue suprr = (GenericValue)
				 * ltr.next(); punchouttime = suprr.getString("punchtime");
				 * 
				 * } } if(tasks3.size() > 0)
				 */
				punchouttime = punchout;
				String dateArr1[] = punchouttime.split(Pattern.quote(":"));
				sec0 = Integer.parseInt(dateArr1[2]);
				min1 = Integer.parseInt(dateArr1[1]);
				hr1 = Integer.parseInt(dateArr1[0]);
//				System.out.println("===================OUT TIME ==>[ " + dateArr1[0] + "]===== [ " + dateArr1[1] + "]======= [ " + dateArr1[2] + "]====\n\n");
				try {

		            EntityConditionList<EntityExpr> condition90 = EntityCondition.makeCondition(
		                    EntityCondition.makeCondition("inputParamEnumId", EntityOperator.EQUALS, "GRT_ONE_HR"));
		            Collection<GenericValue> tasks6 = delegator.findList("RuleCondAction", condition90, null, null, null, false);

					// System.out.println("\n\n===========["+ tasks6 +"]=====================\n\n");
					if (tasks6.size() <= 1) {

						Iterator ptr = tasks6.iterator();
						while (ptr.hasNext()) {
							GenericValue purp = (GenericValue) ptr.next();
							String Cond = purp.getString("condValue");
							String email = purp.getString("PartyId");

						}
					}
					sec = sec1 - sec0;
					min = min1 - min0;
					hr = hr1 - hr0;
					min = min1 - min0;
					sec = sec1 - sec0;
					if (sec < 0) {
						sec = sec + 60;
						min = min - 1;
					}
					if (min < 0) {
						min = min + 60;
						hr = hr - 1;
					}

//					System.out.println("\n\n==========email id of employee =====[" + partyId + "]=====================\n\n");
					// System.out.println("\n\n==========punch in time =====[" + punchintime + "]=====================\n\n");
//					System.out.println("\n\n==========this time difference ==[" + hr + "]=======[" + min + "]=======[" + sec + "]==============\n\n");
					// System.out.println("\n\n========= punch out time =====[" + punchouttime + "]=====================\n\n");

					if (hr >= 1 && min != 0) {
						String content = "Employee took more than specified time for Lunch "
								+ hr + ":" + min + ":" + sec;
						Map commEventMap = FastMap.newInstance();
						commEventMap.put("communicationEventTypeId",
								"AUTO_EMAIL_COMM");
						commEventMap.put("statusId", "COM_IN_PROGRESS");
						commEventMap.put("contactMechTypeId", "EMAIL_ADDRESS");
						commEventMap.put("partyIdFrom", partyId);
						commEventMap.put("partyIdTo", "admin");
						commEventMap.put("contactMechIdFrom", contactMechId);
						commEventMap.put("contactMechIdTo", "admin");
						commEventMap.put("datetimeStarted",
								UtilDateTime.nowTimestamp());
						commEventMap.put("datetimeEnded",
								UtilDateTime.nowTimestamp());
						commEventMap.put("subject", "Late Lunch Punch");
						commEventMap.put("content", content);
						commEventMap.put("userLogin", userLogin);
						commEventMap.put("contentMimeTypeId", "text/html");
						Map<String, Object> createResp = null;
						try {
							createResp = dispatcher.runSync(
									"createCommunicationEvent", commEventMap);
						} catch (GenericServiceException e) {
							Debug.logError(e, module);
							return ServiceUtil.returnError(e.getMessage());
						}
						if (ServiceUtil.isError(createResp)) {
							return ServiceUtil.returnError(ServiceUtil
									.getErrorMessage(createResp));
						}
					} else {
//						System.out.println("\n\n==========lunch time is less than one hr Dont send email notification ===============\n\n");
					}

				} catch (GenericEntityException e) {

					return ServiceUtil.returnError(UtilProperties.getMessage("AttendanceUiLabels", "AttendanceReadPunchOutTimeError", locale));

				}

			}
		}
		// this is end for lunch hr notification

		try {
//			System.out.println("===================Before generic value=================\n\n");
//			System.out.println("===================punchtype [" + PunchType	+ "]=================\n\n");
			GenericValue EmplPunch = delegator.makeValue("EmplPunch", UtilMisc
					.toMap("partyId", partyId, "emplPunchId", emplPunchId,
							"PunchType", PunchType, "punchdate", punchdate,
							"InOut", inout)); // create a generic value from id
												// we just got
//			System.out.println("===================Before Non Pk Fields=================\n\n");
			EmplPunch.setNonPKFields(context); // move non-primary key fields
												// from input parameters to
												// genericvalue
//			System.out.println("===================Before create=================\n\n");
//			System.out.println("===================[ " + flag + " ]=================\n\n");
//			System.out.println("===================[ " + emplPunchId + " ] ====partyId====>[ " + partyId + " ]=====punchdate==>[ " + punchdate + " ]==\n\n");
//			System.out.println("============PunchType=======>[ " + PunchType + " ]=====inout===>[ " + inout + " ]=========\n\n");
			delegator.create(EmplPunch);
//			System.out.println("===================After create=================\n\n");
			return ServiceUtil.returnSuccess(UtilProperties.getMessage("AttendanceUiLabels", "AttendanceSuccessfully", locale));

		} catch (GenericEntityException e) {

			return ServiceUtil.returnError(UtilProperties.getMessage("AttendanceUiLabels", "AttendanceAddFailed", locale));

		}

	}

}
