/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNUUIDGenerator;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNSynchronizeEditor;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.replicator.SVNRepositoryReplicator;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNAdminClient
extends SVNBasicClient {
    private ISVNLogEntryHandler mySyncHandler;

    public SVNAdminClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    protected SVNAdminClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public void setReplayHandler(ISVNLogEntryHandler handler) {
        this.mySyncHandler = handler;
    }

    public SVNURL doCreateRepository(File path, String uuid, boolean enableRevisionProperties, boolean force) throws SVNException {
        return SVNRepositoryFactory.createLocalRepository(path, uuid, enableRevisionProperties, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCopyRevisionProperties(SVNURL toURL, long revision) throws SVNException {
        SVNRepository toRepos = this.createRepository(toURL, true);
        this.checkIfRepositoryIsAtRoot(toRepos, toURL);
        SVNException error = null;
        SVNException error2 = null;
        this.lock(toRepos);
        try {
            SessionInfo info = this.openSourceRepository(toRepos);
            if (revision > info.myLastMergedRevision) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot copy revprops for a revision that has not been synchronized yet");
                SVNErrorManager.error((SVNErrorMessage)err);
            }
            this.copyRevisionProperties(info.myRepository, toRepos, revision, false);
        }
        catch (SVNException svne) {
            error = svne;
        }
        finally {
            try {
                this.unlock(toRepos);
            }
            catch (SVNException svne) {
                error2 = svne;
            }
        }
        if (error != null) {
            throw error;
        }
        if (error2 != null) {
            throw error2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInitialize(SVNURL fromURL, SVNURL toURL) throws SVNException {
        SVNRepository toRepos = this.createRepository(toURL, true);
        this.checkIfRepositoryIsAtRoot(toRepos, toURL);
        SVNException error = null;
        SVNException error2 = null;
        this.lock(toRepos);
        try {
            String fromURLProp;
            long latestRevision = toRepos.getLatestRevision();
            if (latestRevision != 0L) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot initialize a repository with content in it");
                SVNErrorManager.error((SVNErrorMessage)err);
            }
            if ((fromURLProp = toRepos.getRevisionPropertyValue(0L, "svn:sync-from-url")) != null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Destination repository is already synchronizing from ''{0}''", fromURLProp);
                SVNErrorManager.error((SVNErrorMessage)err);
            }
            SVNRepository fromRepos = this.createRepository(fromURL, false);
            this.checkIfRepositoryIsAtRoot(fromRepos, fromURL);
            toRepos.setRevisionPropertyValue(0L, "svn:sync-from-url", fromURL.toDecodedString());
            String uuid = fromRepos.getRepositoryUUID(true);
            toRepos.setRevisionPropertyValue(0L, "svn:sync-from-uuid", uuid);
            toRepos.setRevisionPropertyValue(0L, "svn:sync-last-merged-rev", "0");
            this.copyRevisionProperties(fromRepos, toRepos, 0L, false);
        }
        catch (SVNException svne) {
            error = svne;
        }
        finally {
            try {
                this.unlock(toRepos);
            }
            catch (SVNException svne) {
                error2 = svne;
            }
        }
        if (error != null) {
            throw error;
        }
        if (error2 != null) {
            throw error2;
        }
    }

    public void doCompleteSynchronize(SVNURL fromURL, SVNURL toURL) throws SVNException {
        try {
            this.doInitialize(fromURL, toURL);
            this.doSynchronize(toURL);
            return;
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() != SVNErrorCode.RA_NOT_IMPLEMENTED) {
                throw svne;
            }
            SVNRepositoryReplicator replicator = SVNRepositoryReplicator.newInstance();
            SVNRepository fromRepos = this.createRepository(fromURL, true);
            SVNRepository toRepos = this.createRepository(toURL, false);
            replicator.replicateRepository(fromRepos, toRepos, 1L, -1L);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSynchronize(SVNURL toURL) throws SVNException {
        SVNRepository toRepos = this.createRepository(toURL, true);
        this.checkIfRepositoryIsAtRoot(toRepos, toURL);
        SVNException error = null;
        SVNException error2 = null;
        this.lock(toRepos);
        try {
            SessionInfo info = this.openSourceRepository(toRepos);
            SVNRepository fromRepos = info.myRepository;
            long lastMergedRevision = info.myLastMergedRevision;
            String currentlyCopying = toRepos.getRevisionPropertyValue(0L, "svn:sync-currently-copying");
            long toLatestRevision = toRepos.getLatestRevision();
            if (currentlyCopying != null) {
                long copyingRev = Long.parseLong(currentlyCopying);
                if (copyingRev < lastMergedRevision || copyingRev > lastMergedRevision + 1L || toLatestRevision != lastMergedRevision && toLatestRevision != copyingRev) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Revision being currently copied ({0,number,integer}), last merged revision ({1,number,integer}), and destination HEAD ({2,number,integer}) are inconsistent; have you committed to the destination without using svnsync?", new Long[]{new Long(copyingRev), new Long(lastMergedRevision), new Long(toLatestRevision)});
                    SVNErrorManager.error((SVNErrorMessage)err);
                } else if (copyingRev == toLatestRevision) {
                    if (copyingRev > lastMergedRevision) {
                        this.copyRevisionProperties(fromRepos, toRepos, toLatestRevision, true);
                        lastMergedRevision = copyingRev;
                    }
                    toRepos.setRevisionPropertyValue(0L, "svn:sync-last-merged-rev", SVNProperty.toString(lastMergedRevision));
                    toRepos.setRevisionPropertyValue(0L, "svn:sync-currently-copying", null);
                }
            } else if (toLatestRevision != lastMergedRevision) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Destination HEAD ({0,number,integer}) is not the last merged revision ({1,number,integer}); have you committed to the destination without using svnsync?", new Long[]{new Long(toLatestRevision), new Long(lastMergedRevision)});
                SVNErrorManager.error((SVNErrorMessage)err);
            }
            long fromLatestRevision = fromRepos.getLatestRevision();
            if (fromLatestRevision < lastMergedRevision) {
                return;
            }
            for (long currentRev = lastMergedRevision + 1L; currentRev <= fromLatestRevision; ++currentRev) {
                toRepos.setRevisionPropertyValue(0L, "svn:sync-currently-copying", SVNProperty.toString(currentRev));
                SVNSynchronizeEditor syncEditor = new SVNSynchronizeEditor(toRepos, this.mySyncHandler, currentRev - 1L);
                ISVNEditor cancellableEditor = SVNCancellableEditor.newInstance((ISVNEditor)syncEditor, (ISVNEventHandler)this, (ISVNDebugLog)this.getDebugLog());
                fromRepos.replay(0L, currentRev, true, cancellableEditor);
                cancellableEditor.closeEdit();
                if (syncEditor.getCommitInfo().getNewRevision() != currentRev) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Commit created rev {0,number,integer} but should have created {1,number,integer}", new Long[]{new Long(syncEditor.getCommitInfo().getNewRevision()), new Long(currentRev)});
                    SVNErrorManager.error((SVNErrorMessage)err);
                }
                this.copyRevisionProperties(fromRepos, toRepos, currentRev, true);
                toRepos.setRevisionPropertyValue(0L, "svn:sync-last-merged-rev", SVNProperty.toString(currentRev));
                toRepos.setRevisionPropertyValue(0L, "svn:sync-currently-copying", null);
            }
        }
        catch (SVNException svne) {
            error = svne;
        }
        finally {
            try {
                this.unlock(toRepos);
            }
            catch (SVNException svne) {
                error2 = svne;
            }
        }
        if (error != null) {
            throw error;
        }
        if (error2 != null) {
            throw error2;
        }
    }

    private void copyRevisionProperties(SVNRepository fromRepository, SVNRepository toRepository, long revision, boolean sync) throws SVNException {
        String propName;
        Map existingRevProps = null;
        if (sync) {
            existingRevProps = toRepository.getRevisionProperties(revision, null);
        }
        boolean sawSyncProperties = false;
        Map revProps = fromRepository.getRevisionProperties(revision, null);
        Iterator propNames = revProps.keySet().iterator();
        while (propNames.hasNext()) {
            propName = (String)propNames.next();
            String propValue = (String)revProps.get(propName);
            if (propName.startsWith("sync-")) {
                sawSyncProperties = true;
            } else {
                toRepository.setRevisionPropertyValue(revision, propName, propValue);
            }
            if (!sync) continue;
            existingRevProps.remove(propName);
        }
        if (sync) {
            propNames = existingRevProps.keySet().iterator();
            while (propNames.hasNext()) {
                propName = (String)propNames.next();
                toRepository.setRevisionPropertyValue(revision, propName, null);
            }
        }
        if (sawSyncProperties) {
            SVNDebugLog.getDefaultLog().info("Copied properties for revision " + revision + " (sync-* properties skipped).\n");
        } else {
            SVNDebugLog.getDefaultLog().info("Copied properties for revision " + revision + ".\n");
        }
    }

    private SessionInfo openSourceRepository(SVNRepository targetRepos) throws SVNException {
        String fromURL = targetRepos.getRevisionPropertyValue(0L, "svn:sync-from-url");
        String fromUUID = targetRepos.getRevisionPropertyValue(0L, "svn:sync-from-uuid");
        String lastMergedRev = targetRepos.getRevisionPropertyValue(0L, "svn:sync-last-merged-rev");
        if (fromURL == null || fromUUID == null || lastMergedRev == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Destination repository has not been initialized");
            SVNErrorManager.error((SVNErrorMessage)err);
        }
        SVNURL srcURL = SVNURL.parseURIDecoded(fromURL);
        SVNRepository srcRepos = this.createRepository(srcURL, false);
        this.checkIfRepositoryIsAtRoot(srcRepos, srcURL);
        String reposUUID = srcRepos.getRepositoryUUID(true);
        if (!fromUUID.equals(reposUUID)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "UUID of destination repository ({0}) does not match expected UUID ({1})", new String[]{reposUUID, fromUUID});
            SVNErrorManager.error((SVNErrorMessage)err);
        }
        return new SessionInfo(srcRepos, Long.parseLong(lastMergedRev));
    }

    private void checkIfRepositoryIsAtRoot(SVNRepository repos, SVNURL url) throws SVNException {
        SVNURL reposRoot = repos.getRepositoryRoot(true);
        if (!reposRoot.equals(url)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Session is rooted at ''{0}'' but the repos root is ''{1}''", new SVNURL[]{url, reposRoot});
            SVNErrorManager.error((SVNErrorMessage)err);
        }
    }

    private void lock(SVNRepository repos) throws SVNException {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can't get local hostname");
            SVNErrorManager.error((SVNErrorMessage)err, (Throwable)e);
        }
        if (hostName.length() > 256) {
            hostName = hostName.substring(0, 256);
        }
        String lockToken = hostName + ":" + SVNUUIDGenerator.formatUUID(SVNUUIDGenerator.generateUUID());
        int i = 0;
        for (i = 0; i < 10; ++i) {
            String reposLockToken = repos.getRevisionPropertyValue(0L, "svn:sync-lock");
            if (reposLockToken != null) {
                if (reposLockToken.equals(lockToken)) {
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
                continue;
            }
            repos.setRevisionPropertyValue(0L, "svn:sync-lock", lockToken);
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Couldn''t get lock on destination repos after {0,number,integer} attempts\n", new Integer(i));
        SVNErrorManager.error((SVNErrorMessage)err);
    }

    private void unlock(SVNRepository repos) throws SVNException {
        repos.setRevisionPropertyValue(0L, "svn:sync-lock", null);
    }

    private class SessionInfo {
        SVNRepository myRepository;
        long myLastMergedRevision;

        public SessionInfo(SVNRepository repos, long lastMergedRev) {
            this.myRepository = repos;
            this.myLastMergedRevision = lastMergedRev;
        }
    }
}

