/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;

public class SVNTimeUtil {
    private static final DateFormat ISO8601_FORMAT_OUT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'000Z'");
    private static final Calendar CALENDAR = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private static final Date NULL = new Date(0L);
    private static final char[] DATE_SEPARATORS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void formatDate(Date date, StringBuffer buffer) {
        DateFormat dateFormat = ISO8601_FORMAT_OUT;
        synchronized (dateFormat) {
            ISO8601_FORMAT_OUT.format(date, buffer, new FieldPosition(0));
        }
    }

    public static String formatDate(Date date) {
        return SVNTimeUtil.formatDate(date, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Date date, boolean formatZeroDate) {
        if (date == null) {
            return null;
        }
        if (!formatZeroDate && date.getTime() == 0L) {
            return null;
        }
        DateFormat dateFormat = ISO8601_FORMAT_OUT;
        synchronized (dateFormat) {
            return ISO8601_FORMAT_OUT.format(date);
        }
    }

    public static Date parseDate(String str) {
        if (str == null) {
            return NULL;
        }
        try {
            return new Date(SVNTimeUtil.parseDateAsLong(str));
        }
        catch (Throwable throwable) {
            return NULL;
        }
    }

    public static Date parseDateString(String str) throws SVNException {
        if (str == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_DATE);
            SVNErrorManager.error((SVNErrorMessage)err);
        }
        try {
            return new Date(SVNTimeUtil.parseDateAsLong(str));
        }
        catch (Throwable th) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_DATE);
            SVNErrorManager.error((SVNErrorMessage)err, (Throwable)th);
            return NULL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parseDateAsLong(String str) {
        if (str == null) {
            return -1L;
        }
        int index = 0;
        int startIndex = 0;
        int[] result = new int[7];
        for (int charIndex = 0; index < DATE_SEPARATORS.length && charIndex < str.length(); ++charIndex) {
            if (str.charAt(charIndex) != DATE_SEPARATORS[index]) continue;
            String segment = str.substring(startIndex, charIndex);
            result[index] = segment.length() == 0 ? 0 : (index + 1 < DATE_SEPARATORS.length ? Integer.parseInt(segment) : Integer.parseInt(segment.substring(0, Math.min(3, segment.length()))));
            startIndex = charIndex + 1;
            ++index;
        }
        int year = result[0];
        int month = result[1];
        int date = result[2];
        int hour = result[3];
        int min = result[4];
        int sec = result[5];
        int ms = result[6];
        Calendar calendar = CALENDAR;
        synchronized (calendar) {
            CALENDAR.clear();
            CALENDAR.set(year, month - 1, date, hour, min, sec);
            CALENDAR.set(14, ms);
            return CALENDAR.getTimeInMillis();
        }
    }

    static {
        ISO8601_FORMAT_OUT.setTimeZone(TimeZone.getTimeZone("GMT"));
        DATE_SEPARATORS = new char[]{'-', '-', 'T', ':', ':', '.', 'Z'};
    }
}

