/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.command.SVNCommandEventProcessor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class UpdateCommand
extends SVNCommand {
    public void run(PrintStream out, PrintStream err) throws SVNException {
        boolean error = false;
        for (int i = 0; i < this.getCommandLine().getPathCount(); ++i) {
            File parent;
            String path = this.getCommandLine().getPathAt(i);
            SVNRevision revision = UpdateCommand.parseRevision(this.getCommandLine());
            this.getClientManager().setEventHandler(new SVNCommandEventProcessor(out, err, false));
            SVNUpdateClient updater = this.getClientManager().getUpdateClient();
            File file = new File(path).getAbsoluteFile();
            if (!(file.exists() || (parent = file.getParentFile()).exists() && SVNWCUtil.isVersionedDirectory(parent))) {
                if (this.getCommandLine().hasArgument(SVNArgument.QUIET)) continue;
                UpdateCommand.println(out, "Skipped '" + SVNFormatUtil.formatPath((File)file).replace('/', File.separatorChar) + "'");
                continue;
            }
            try {
                updater.doUpdate(file.getAbsoluteFile(), revision, !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE));
                continue;
            }
            catch (Throwable th) {
                updater.getDebugLog().info(th);
                UpdateCommand.println(err, th.getMessage());
                UpdateCommand.println(err);
                error = true;
            }
        }
        if (error) {
            System.exit(1);
        }
    }
}

