/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.command.SVNCommandEventProcessor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class SwitchCommand
extends SVNCommand {
    public void run(PrintStream out, PrintStream err) throws SVNException {
        String url = this.getCommandLine().getURL(0);
        String absolutePath = this.getCommandLine().getPathAt(0);
        SVNRevision revision = SwitchCommand.parseRevision(this.getCommandLine());
        if (!revision.isValid()) {
            revision = SVNRevision.HEAD;
        }
        this.getClientManager().setEventHandler(new SVNCommandEventProcessor(out, err, false, false));
        SVNUpdateClient updater = this.getClientManager().getUpdateClient();
        try {
            SVNURL switchURL = SVNURL.parseURIEncoded(url);
            if (this.getCommandLine().hasArgument(SVNArgument.RELOCATE)) {
                SVNURL targetURL = SVNURL.parseURIEncoded(this.getCommandLine().getURL(1));
                updater.doRelocate(new File(absolutePath).getAbsoluteFile(), switchURL, targetURL, !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE));
            } else {
                updater.doSwitch(new File(absolutePath).getAbsoluteFile(), switchURL, revision, !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE));
            }
        }
        catch (Throwable th) {
            updater.getDebugLog().info(th);
            SwitchCommand.println(err, th.getMessage());
            SwitchCommand.println(err);
            System.exit(1);
        }
    }
}

