/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.SVNCommandLine;
import org.tmatesoft.svn.cli.SVNCommandStatusHandler;
import org.tmatesoft.svn.cli.command.SVNCommandEventProcessor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc.xml.SVNXMLSerializer;
import org.tmatesoft.svn.core.wc.xml.SVNXMLStatusHandler;

public class StatusCommand
extends SVNCommand {
    public void run(PrintStream out, PrintStream err) throws SVNException {
        SVNXMLSerializer serializer;
        int i;
        SVNCommandLine line = this.getCommandLine();
        boolean isEmpty = true;
        String[] paths = new String[line.getPathCount()];
        for (i = 0; i < line.getPathCount(); ++i) {
            paths[i] = line.getPathAt(i).trim();
        }
        for (i = 0; i < paths.length; ++i) {
            String path = paths[i];
            File validatedPath = new File(SVNPathUtil.validateFilePath(new File(path).getAbsolutePath()));
            if (SVNFileType.getType(validatedPath) == SVNFileType.DIRECTORY && !SVNWCUtil.isVersionedDirectory(validatedPath) && !SVNWCUtil.isVersionedDirectory(validatedPath.getParentFile())) {
                err.println("svn: warning: '" + path + "' is not a working copy");
                paths[i] = null;
                continue;
            }
            if (SVNFileType.getType(validatedPath) == SVNFileType.DIRECTORY && !SVNWCUtil.isVersionedDirectory(validatedPath) && "..".equals(path)) {
                err.println("svn: warning: '" + path + "' is not a working copy");
                paths[i] = null;
                continue;
            }
            if ("..".equals(path)) {
                isEmpty = false;
                paths[i] = "..";
                continue;
            }
            paths[i] = validatedPath.getAbsolutePath();
            isEmpty = false;
        }
        if (isEmpty) {
            return;
        }
        boolean showUpdates = this.getCommandLine().hasArgument(SVNArgument.SHOW_UPDATES);
        if (this.getCommandLine().getPathCount() == 0) {
            this.getCommandLine().setPathAt(0, ".");
        }
        boolean recursive = !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE);
        boolean reportAll = this.getCommandLine().hasArgument(SVNArgument.VERBOSE);
        boolean ignored = this.getCommandLine().hasArgument(SVNArgument.NO_IGNORE);
        boolean quiet = this.getCommandLine().hasArgument(SVNArgument.QUIET);
        if (!this.getCommandLine().hasArgument(SVNArgument.XML)) {
            this.getClientManager().setEventHandler(new SVNCommandEventProcessor(out, err, false));
        }
        SVNStatusClient stClient = this.getClientManager().getStatusClient();
        ISVNStatusHandler handler = new SVNCommandStatusHandler(System.out, reportAll || showUpdates, reportAll, quiet, showUpdates);
        SVNXMLSerializer sVNXMLSerializer = serializer = this.getCommandLine().hasArgument(SVNArgument.XML) ? new SVNXMLSerializer(System.out) : null;
        if (serializer != null) {
            handler = new SVNXMLStatusHandler(serializer);
            if (!this.getCommandLine().hasArgument(SVNArgument.INCREMENTAL)) {
                ((SVNXMLStatusHandler)handler).startDocument();
            }
        }
        boolean error = false;
        for (int i2 = 0; i2 < paths.length; ++i2) {
            String path = paths[i2];
            if (path == null) continue;
            File file = new File(path).getAbsoluteFile();
            if (serializer != null) {
                ((SVNXMLStatusHandler)handler).startTarget(new File(this.getCommandLine().getPathAt(i2)));
            }
            long rev = -1L;
            try {
                rev = stClient.doStatus(file, recursive, showUpdates, reportAll, ignored, handler);
            }
            catch (SVNException e) {
                stClient.getDebugLog().info(e);
                err.println(e.getMessage());
                error = true;
            }
            if (serializer == null) continue;
            ((SVNXMLStatusHandler)handler).endTarget(rev);
        }
        if (serializer != null) {
            if (!this.getCommandLine().hasArgument(SVNArgument.INCREMENTAL)) {
                ((SVNXMLStatusHandler)handler).endDocument();
            }
            try {
                serializer.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (error) {
            System.exit(1);
        }
    }
}

