/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class PropgetCommand
extends SVNCommand
implements ISVNPropertyHandler {
    private boolean myIsStrict;
    private boolean myIsRecursive;
    private PrintStream myOut;

    public final void run(PrintStream out, PrintStream err) throws SVNException {
        String propertyName = this.getCommandLine().getPathAt(0);
        this.myIsRecursive = this.getCommandLine().hasArgument(SVNArgument.RECURSIVE);
        boolean revProp = this.getCommandLine().hasArgument(SVNArgument.REV_PROP);
        this.myIsStrict = this.getCommandLine().hasArgument(SVNArgument.STRICT);
        this.myOut = out;
        this.myIsRecursive &= !revProp;
        SVNRevision revision = SVNRevision.UNDEFINED;
        if (this.getCommandLine().hasArgument(SVNArgument.REVISION)) {
            revision = SVNRevision.parse((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION));
        }
        SVNWCClient wcClient = this.getClientManager().getWCClient();
        if (this.getCommandLine().hasURLs()) {
            String url = this.getCommandLine().getURL(0);
            if (revProp) {
                wcClient.doGetRevisionProperty(SVNURL.parseURIEncoded(url), propertyName, revision, this);
            } else {
                SVNRevision pegRevision = this.getCommandLine().getPegRevision(0);
                wcClient.doGetProperty(SVNURL.parseURIEncoded(url), propertyName, pegRevision, revision, this.myIsRecursive, (ISVNPropertyHandler)this);
            }
        } else if (this.getCommandLine().getPathCount() > 1) {
            String path = this.getCommandLine().getPathAt(1);
            SVNRevision pegRevision = this.getCommandLine().getPathPegRevision(1);
            if (revProp) {
                wcClient.doGetRevisionProperty(new File(path), propertyName, revision, (ISVNPropertyHandler)this);
            } else {
                wcClient.doGetProperty(new File(path), propertyName, pegRevision, revision, this.myIsRecursive, (ISVNPropertyHandler)this);
            }
        }
    }

    public void handleProperty(File path, SVNPropertyData property) throws SVNException {
        if (!this.myIsStrict && this.myIsRecursive) {
            this.myOut.print(SVNFormatUtil.formatPath((File)path) + " - ");
        }
        this.myOut.print(property.getValue());
        if (!this.myIsStrict) {
            this.myOut.println();
        }
    }

    public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
        if (!this.myIsStrict && this.myIsRecursive) {
            this.myOut.print(url + " - ");
        }
        this.myOut.print(property.getValue());
        if (!this.myIsStrict) {
            this.myOut.println();
        }
    }

    public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
        this.myOut.print(property.getValue());
        if (!this.myIsStrict) {
            this.myOut.println();
        }
    }
}

