/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.command.SVNCommandEventProcessor;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class MkDirCommand
extends SVNCommand {
    public final void run(PrintStream out, PrintStream err) throws SVNException {
        if (!this.getCommandLine().hasURLs()) {
            if (this.getCommandLine().getArgumentValue(SVNArgument.MESSAGE) != null) {
                SVNErrorMessage msg = SVNErrorMessage.create(SVNErrorCode.CL_UNNECESSARY_LOG_MESSAGE, "Local, non-commit operations do not take a log message.");
                throw new SVNException(msg);
            }
            this.createLocalDirectories(out, err);
        } else {
            this.createRemoteDirectories(out, err);
        }
    }

    private void createLocalDirectories(PrintStream out, PrintStream err) {
        ArrayList<File> paths = new ArrayList<File>();
        for (int i = 0; i < this.getCommandLine().getPathCount(); ++i) {
            if (MkDirCommand.matchTabsInPath(this.getCommandLine().getPathAt(i), err)) continue;
            paths.add(new File(this.getCommandLine().getPathAt(i)));
        }
        if (paths.isEmpty()) {
            return;
        }
        this.getClientManager().setEventHandler(new SVNCommandEventProcessor(out, err, false));
        SVNWCClient wcClient = this.getClientManager().getWCClient();
        boolean recursive = !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE);
        Iterator files = paths.iterator();
        while (files.hasNext()) {
            File file = (File)files.next();
            try {
                wcClient.doAdd(file, false, true, false, recursive, false);
            }
            catch (SVNException e) {
                err.println(e.getMessage());
            }
        }
    }

    private void createRemoteDirectories(PrintStream out, PrintStream err) throws SVNException {
        ArrayList<String> urls = new ArrayList<String>();
        for (int i = 0; i < this.getCommandLine().getURLCount(); ++i) {
            if (MkDirCommand.matchTabsInURL(this.getCommandLine().getURL(i), err)) continue;
            urls.add(this.getCommandLine().getURL(i));
        }
        if (urls.isEmpty()) {
            return;
        }
        String message = (String)this.getCommandLine().getArgumentValue(SVNArgument.MESSAGE);
        this.getClientManager().setEventHandler(new SVNCommandEventProcessor(out, err, false));
        SVNCommitClient client = this.getClientManager().getCommitClient();
        String[] paths = urls.toArray(new String[urls.size()]);
        SVNURL[] svnURLs = new SVNURL[paths.length];
        for (int i = 0; i < svnURLs.length; ++i) {
            svnURLs[i] = SVNURL.parseURIEncoded(paths[i]);
        }
        SVNCommitInfo info = client.doMkDir(svnURLs, message == null ? "" : message);
        if (info != SVNCommitInfo.NULL) {
            out.println();
            out.println("Committed revision " + info.getNewRevision() + ".");
        }
    }
}

