/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.xml.AbstractXMLHandler;
import org.tmatesoft.svn.core.wc.xml.SVNXMLLogHandler;
import org.tmatesoft.svn.core.wc.xml.SVNXMLSerializer;

public class LogCommand
extends SVNCommand
implements ISVNLogEntryHandler {
    private static final String SEPARATOR = "------------------------------------------------------------------------\n";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private PrintStream myPrintStream;
    private boolean myReportPaths;
    private boolean myIsQuiet;
    private boolean myHasLogEntries;

    public void run(PrintStream out, PrintStream err) throws SVNException {
        String revStr = (String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION);
        SVNRevision startRevision = SVNRevision.UNDEFINED;
        SVNRevision endRevision = SVNRevision.UNDEFINED;
        if (revStr != null && revStr.indexOf(58) > 0) {
            startRevision = SVNRevision.parse(revStr.substring(0, revStr.indexOf(58)));
            endRevision = SVNRevision.parse(revStr.substring(revStr.indexOf(58) + 1));
        } else if (revStr != null) {
            startRevision = SVNRevision.parse(revStr);
        }
        boolean stopOnCopy = this.getCommandLine().hasArgument(SVNArgument.STOP_ON_COPY);
        this.myReportPaths = this.getCommandLine().hasArgument(SVNArgument.VERBOSE);
        this.myIsQuiet = this.getCommandLine().hasArgument(SVNArgument.QUIET);
        String limitStr = (String)this.getCommandLine().getArgumentValue(SVNArgument.LIMIT);
        this.myPrintStream = out;
        long limit = 0L;
        if (limitStr != null) {
            try {
                limit = Long.parseLong(limitStr);
                if (limit <= 0L) {
                    System.err.println("svn: Argument to --limit must be positive number");
                    return;
                }
            }
            catch (NumberFormatException nfe) {
                System.err.println("svn: Argument to --limit must be positive number");
                return;
            }
        }
        SVNLogClient logClient = this.getClientManager().getLogClient();
        ISVNLogEntryHandler handler = this;
        SVNXMLSerializer serializer = null;
        if (this.getCommandLine().hasArgument(SVNArgument.XML)) {
            serializer = new SVNXMLSerializer(System.out);
            handler = new SVNXMLLogHandler(serializer);
            if (!this.getCommandLine().hasArgument(SVNArgument.INCREMENTAL)) {
                ((AbstractXMLHandler)((Object)handler)).startDocument();
            }
        }
        if (this.getCommandLine().hasURLs()) {
            String url = this.getCommandLine().getURL(0);
            SVNRevision pegRevision = this.getCommandLine().getPegRevision(0);
            ArrayList<String> targets = new ArrayList<String>();
            for (int i = 0; i < this.getCommandLine().getPathCount(); ++i) {
                targets.add(this.getCommandLine().getPathAt(i));
            }
            String[] paths = targets.toArray(new String[targets.size()]);
            logClient.doLog(SVNURL.parseURIEncoded(url), paths, pegRevision, startRevision, endRevision, stopOnCopy, this.myReportPaths, limit, handler);
        } else if (this.getCommandLine().hasPaths()) {
            ArrayList<File> targets = new ArrayList<File>();
            SVNRevision[] pegRevisions = new SVNRevision[this.getCommandLine().getPathCount()];
            for (int i = 0; i < this.getCommandLine().getPathCount(); ++i) {
                targets.add(new File(this.getCommandLine().getPathAt(i)).getAbsoluteFile());
                pegRevisions[i] = this.getCommandLine().getPathPegRevision(i);
            }
            File[] paths = targets.toArray(new File[targets.size()]);
            logClient.doLog(paths, pegRevisions[0], startRevision, endRevision, stopOnCopy, this.myReportPaths, limit, handler);
        }
        if (this.getCommandLine().hasArgument(SVNArgument.XML)) {
            if (!this.getCommandLine().hasArgument(SVNArgument.INCREMENTAL)) {
                ((AbstractXMLHandler)((Object)handler)).endDocument();
            }
            try {
                serializer.flush();
            }
            catch (IOException e) {}
        } else if (this.myHasLogEntries) {
            this.myPrintStream.print(SEPARATOR);
            this.myPrintStream.flush();
        }
    }

    public void handleLogEntry(SVNLogEntry logEntry) {
        if (logEntry == null || logEntry.getMessage() == null && logEntry.getRevision() == 0L) {
            return;
        }
        this.myHasLogEntries = true;
        StringBuffer result = new StringBuffer();
        String author = logEntry.getAuthor() == null ? "(no author)" : logEntry.getAuthor();
        String date = logEntry.getDate() == null ? "(no date)" : DATE_FORMAT.format(logEntry.getDate());
        String message = logEntry.getMessage();
        if (!this.myIsQuiet && message == null) {
            message = "";
        }
        result.append(SEPARATOR);
        result.append("r" + Long.toString(logEntry.getRevision()) + " | " + author + " | " + date);
        if (!this.myIsQuiet) {
            int count = LogCommand.getLinesCount(message);
            result.append(" | " + count + (count == 1 ? " line" : " lines"));
        }
        result.append("\n");
        if (this.myReportPaths && logEntry.getChangedPaths() != null) {
            TreeMap sortedPaths = new TreeMap(logEntry.getChangedPaths());
            result.append("Changed paths:\n");
            Iterator paths = sortedPaths.keySet().iterator();
            while (paths.hasNext()) {
                String path = (String)paths.next();
                SVNLogEntryPath lPath = (SVNLogEntryPath)sortedPaths.get(path);
                result.append("   " + lPath.getType() + " " + path);
                if (lPath.getCopyPath() != null) {
                    result.append(" (from " + lPath.getCopyPath() + ":" + lPath.getCopyRevision() + ")");
                }
                result.append("\n");
            }
        }
        if (!this.myIsQuiet) {
            result.append("\n" + message + "\n");
        }
        this.myPrintStream.print(result.toString());
        this.myPrintStream.flush();
    }
}

