/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.command.SVNCommandEventProcessor;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNCommitClient;

public class ImportCommand
extends SVNCommand {
    public void run(PrintStream out, PrintStream err) throws SVNException {
        String path = ".";
        if (this.getCommandLine().getPathCount() >= 1) {
            path = this.getCommandLine().getPathAt(0);
        }
        String url = this.getCommandLine().getURL(0);
        boolean recursive = !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE);
        boolean disableAutoProps = this.getCommandLine().hasArgument(SVNArgument.NO_AUTO_PROPS);
        boolean enableAutoProps = this.getCommandLine().hasArgument(SVNArgument.AUTO_PROPS);
        String message = (String)this.getCommandLine().getArgumentValue(SVNArgument.MESSAGE);
        this.getClientManager().setEventHandler(new SVNCommandEventProcessor(out, err, false));
        SVNCommitClient commitClient = this.getClientManager().getCommitClient();
        if (disableAutoProps) {
            commitClient.getOptions().setUseAutoProperties(false);
        }
        if (enableAutoProps) {
            commitClient.getOptions().setUseAutoProperties(true);
        }
        boolean useGlobalIgnores = !this.getCommandLine().hasArgument(SVNArgument.NO_IGNORE);
        SVNCommitInfo info = commitClient.doImport(new File(path), SVNURL.parseURIEncoded(url), message, useGlobalIgnores, recursive);
        if (info != SVNCommitInfo.NULL) {
            out.println();
            out.println("Imported revision " + info.getNewRevision() + ".");
        }
    }
}

