/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.DefaultSVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffStatusHandler;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNDiffStatus;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class DiffCommand
extends SVNCommand
implements ISVNDiffStatusHandler {
    private PrintStream myOut;

    public void run(PrintStream out, PrintStream err) throws SVNException {
        this.myOut = out;
        boolean error = false;
        SVNDiffClient differ = this.getClientManager().getDiffClient();
        if (this.getCommandLine().hasArgument(SVNArgument.EXTENSIONS)) {
            SVNDiffOptions diffOptions = new SVNDiffOptions(this.getCommandLine().hasArgument(SVNArgument.IGNORE_ALL_WS), this.getCommandLine().hasArgument(SVNArgument.IGNORE_WS_CHANGE), this.getCommandLine().hasArgument(SVNArgument.IGNORE_EOL_STYLE));
            ISVNDiffGenerator generator = differ.getDiffGenerator();
            if (generator instanceof DefaultSVNDiffGenerator) {
                ((DefaultSVNDiffGenerator)generator).setDiffOptions(diffOptions);
            }
        }
        File userDir = new File(".").getAbsoluteFile().getParentFile();
        differ.getDiffGenerator().setBasePath(userDir);
        boolean useAncestry = this.getCommandLine().hasArgument(SVNArgument.USE_ANCESTRY);
        boolean recursive = !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE);
        boolean summarize = this.getCommandLine().hasArgument(SVNArgument.SUMMARIZE);
        differ.getDiffGenerator().setDiffDeleted(!this.getCommandLine().hasArgument(SVNArgument.NO_DIFF_DELETED));
        differ.getDiffGenerator().setForcedBinaryDiff(this.getCommandLine().hasArgument(SVNArgument.FORCE));
        if (this.getCommandLine().getURLCount() == 2 && !this.getCommandLine().hasPaths()) {
            SVNURL url1 = SVNURL.parseURIEncoded(this.getCommandLine().getURL(0));
            SVNURL url2 = SVNURL.parseURIEncoded(this.getCommandLine().getURL(1));
            SVNRevision peg1 = this.getCommandLine().getPegRevision(0);
            SVNRevision peg2 = this.getCommandLine().getPegRevision(1);
            if (peg1 == SVNRevision.UNDEFINED) {
                peg1 = SVNRevision.HEAD;
            }
            if (peg2 == SVNRevision.UNDEFINED) {
                peg2 = SVNRevision.HEAD;
            }
            differ.doDiff(url1, peg1, url2, peg2, recursive, useAncestry, (OutputStream)out);
        } else {
            SVNRevision rN = SVNRevision.UNDEFINED;
            SVNRevision rM = SVNRevision.UNDEFINED;
            String revStr = (String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION);
            if (revStr != null && revStr.indexOf(58) > 0) {
                rN = SVNRevision.parse(revStr.substring(0, revStr.indexOf(58)));
                rM = SVNRevision.parse(revStr.substring(revStr.indexOf(58) + 1));
            } else if (revStr != null) {
                rN = SVNRevision.parse(revStr);
            } else if (revStr == null && this.getCommandLine().hasArgument(SVNArgument.CHANGE)) {
                long changeRev = Long.parseLong((String)this.getCommandLine().getArgumentValue(SVNArgument.CHANGE));
                if (changeRev >= 0L) {
                    rM = SVNRevision.create(changeRev);
                    rN = SVNRevision.create(changeRev - 1L);
                } else {
                    rN = SVNRevision.create(-changeRev);
                    rM = SVNRevision.create(-changeRev - 1L);
                }
            }
            if (this.getCommandLine().hasArgument(SVNArgument.OLD)) {
                String oldPath = (String)this.getCommandLine().getArgumentValue(SVNArgument.OLD);
                String newPath = (String)this.getCommandLine().getArgumentValue(SVNArgument.NEW);
                if (newPath == null) {
                    newPath = oldPath;
                }
                if (oldPath.startsWith("=")) {
                    oldPath = oldPath.substring(1);
                }
                if (newPath.startsWith("=")) {
                    newPath = newPath.substring(1);
                }
                if (oldPath.indexOf(64) > 0) {
                    rN = SVNRevision.parse(oldPath.substring(oldPath.lastIndexOf(64) + 1));
                    oldPath = oldPath.substring(0, oldPath.lastIndexOf(64));
                }
                if (newPath.indexOf(64) > 0) {
                    rM = SVNRevision.parse(newPath.substring(newPath.lastIndexOf(64) + 1));
                    newPath = newPath.substring(0, newPath.lastIndexOf(64));
                }
                if (this.getCommandLine().getPathCount() == 0) {
                    this.getCommandLine().setPathAt(0, "");
                }
                if (rN == SVNRevision.UNDEFINED) {
                    SVNRevision sVNRevision = rN = this.getCommandLine().isURL(oldPath) ? SVNRevision.HEAD : SVNRevision.BASE;
                }
                if (rM == SVNRevision.UNDEFINED) {
                    rM = this.getCommandLine().isURL(newPath) ? SVNRevision.HEAD : SVNRevision.WORKING;
                }
                for (int i = 0; i < this.getCommandLine().getPathCount(); ++i) {
                    String p = this.getCommandLine().getPathAt(i);
                    if (".".equals(p = p.replace(File.separatorChar, '/'))) {
                        p = "";
                    }
                    String oP = SVNPathUtil.append(oldPath, p);
                    String nP = SVNPathUtil.append(newPath, p);
                    try {
                        SVNURL url2;
                        File path1;
                        if (!this.getCommandLine().isURL(oP) && this.getCommandLine().isURL(nP)) {
                            path1 = new File(oP).getAbsoluteFile();
                            url2 = SVNURL.parseURIEncoded(nP);
                            if (summarize) {
                                differ.doDiffStatus(path1, rN, url2, rM, recursive, useAncestry, (ISVNDiffStatusHandler)this);
                                continue;
                            }
                            differ.doDiff(path1, rN, url2, rM, recursive, useAncestry, (OutputStream)out);
                            continue;
                        }
                        if (this.getCommandLine().isURL(oP) && !this.getCommandLine().isURL(nP)) {
                            File path2 = new File(nP).getAbsoluteFile();
                            SVNURL url1 = SVNURL.parseURIEncoded(oP);
                            if (summarize) {
                                differ.doDiffStatus(url1, rN, path2, rM, recursive, useAncestry, (ISVNDiffStatusHandler)this);
                                continue;
                            }
                            differ.doDiff(url1, rN, path2, rM, recursive, useAncestry, (OutputStream)out);
                            continue;
                        }
                        if (this.getCommandLine().isURL(oP) && this.getCommandLine().isURL(nP)) {
                            SVNURL url1 = SVNURL.parseURIEncoded(oP);
                            url2 = SVNURL.parseURIEncoded(nP);
                            if (summarize) {
                                differ.doDiffStatus(url1, rN, url2, rM, recursive, useAncestry, (ISVNDiffStatusHandler)this);
                                continue;
                            }
                            differ.doDiff(url1, rN, url2, rM, recursive, useAncestry, (OutputStream)out);
                            continue;
                        }
                        path1 = new File(oP).getAbsoluteFile();
                        File path2 = new File(nP).getAbsoluteFile();
                        if (summarize) {
                            differ.doDiffStatus(path1, rN, path2, rM, recursive, useAncestry, (ISVNDiffStatusHandler)this);
                            continue;
                        }
                        differ.doDiff(path1, rN, path2, rM, recursive, useAncestry, (OutputStream)out);
                        continue;
                    }
                    catch (SVNException e) {
                        differ.getDebugLog().info(e);
                        error = true;
                        DiffCommand.println(err, e.getMessage());
                    }
                }
            } else {
                SVNRevision peg;
                int i;
                SVNRevision r1 = rN;
                SVNRevision r2 = rM;
                r1 = r1 == SVNRevision.UNDEFINED ? SVNRevision.BASE : r1;
                r2 = r2 == SVNRevision.UNDEFINED ? SVNRevision.WORKING : r2;
                boolean peggedDiff = r1 != SVNRevision.WORKING && r1 != SVNRevision.BASE && r1 != SVNRevision.PREVIOUS;
                peggedDiff &= !summarize;
                for (i = 0; i < this.getCommandLine().getPathCount(); ++i) {
                    String path = this.getCommandLine().getPathAt(i);
                    File path1 = new File(path).getAbsoluteFile();
                    if (peggedDiff) {
                        peg = this.getCommandLine().getPathPegRevision(i);
                        peg = peg == SVNRevision.UNDEFINED ? SVNRevision.WORKING : peg;
                        differ.doDiff(path1, peg, r1, r2, recursive, useAncestry, (OutputStream)out);
                        continue;
                    }
                    if (summarize) {
                        differ.doDiffStatus(path1, r1, path1, r2, recursive, useAncestry, (ISVNDiffStatusHandler)this);
                        continue;
                    }
                    differ.doDiff(path1, r1, path1, r2, recursive, useAncestry, (OutputStream)out);
                }
                r1 = rN;
                r2 = rM;
                peggedDiff = r1 != SVNRevision.WORKING && r1 != SVNRevision.BASE;
                peggedDiff &= !summarize;
                r2 = r2 == SVNRevision.UNDEFINED ? SVNRevision.HEAD : r2;
                for (i = 0; i < this.getCommandLine().getURLCount(); ++i) {
                    String url = this.getCommandLine().getURL(i);
                    SVNURL url1 = SVNURL.parseURIEncoded(url);
                    if (peggedDiff) {
                        peg = this.getCommandLine().getPegRevision(i);
                        peg = peg == SVNRevision.UNDEFINED ? SVNRevision.HEAD : peg;
                        differ.doDiff(url1, peg, r1, r2, recursive, useAncestry, (OutputStream)out);
                        continue;
                    }
                    if (summarize) {
                        differ.doDiffStatus(url1, r1, url1, r2, recursive, useAncestry, (ISVNDiffStatusHandler)this);
                        continue;
                    }
                    differ.doDiff(url1, r1, url1, r2, recursive, useAncestry, (OutputStream)out);
                }
            }
        }
        out.flush();
        if (error) {
            System.exit(1);
        }
    }

    public void handleDiffStatus(SVNDiffStatus diffStatus) throws SVNException {
        if (diffStatus.getModificationType() == SVNStatusType.STATUS_NONE && !diffStatus.isPropertiesModified()) {
            return;
        }
        StringBuffer result = new StringBuffer();
        result.append(diffStatus.getModificationType().getCode());
        result.append(diffStatus.isPropertiesModified() ? (char)'M' : ' ');
        result.append("     ");
        if (diffStatus.getFile() != null) {
            result.append(SVNFormatUtil.formatPath((File)diffStatus.getFile()));
        } else {
            result.append(diffStatus.getPath());
        }
        this.myOut.println(result.toString());
    }
}

