/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.command.SVNCommandEventProcessor;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class DeleteCommand
extends SVNCommand {
    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (this.getCommandLine().hasURLs()) {
            this.runRemote(out);
        } else {
            if (this.getCommandLine().getArgumentValue(SVNArgument.MESSAGE) != null) {
                SVNErrorMessage msg = SVNErrorMessage.create(SVNErrorCode.CL_UNNECESSARY_LOG_MESSAGE, "Local, non-commit operations do not take a log message.");
                throw new SVNException(msg);
            }
            this.runLocally(out, err);
        }
    }

    private void runRemote(PrintStream out) throws SVNException {
        String commitMessage = (String)this.getCommandLine().getArgumentValue(SVNArgument.MESSAGE);
        SVNCommitClient client = this.getClientManager().getCommitClient();
        ArrayList<String> urls = new ArrayList<String>(this.getCommandLine().getURLCount());
        for (int i = 0; i < this.getCommandLine().getURLCount(); ++i) {
            urls.add(this.getCommandLine().getURL(i));
        }
        String[] urlsArray = urls.toArray(new String[urls.size()]);
        SVNURL[] svnUrls = new SVNURL[urlsArray.length];
        for (int i = 0; i < svnUrls.length; ++i) {
            svnUrls[i] = SVNURL.parseURIEncoded(urlsArray[i]);
        }
        SVNCommitInfo info = client.doDelete(svnUrls, commitMessage);
        if (info != SVNCommitInfo.NULL) {
            out.println();
            out.println("Committed revision " + info.getNewRevision() + ".");
        }
    }

    private void runLocally(PrintStream out, PrintStream err) {
        boolean force = this.getCommandLine().hasArgument(SVNArgument.FORCE);
        this.getClientManager().setEventHandler(new SVNCommandEventProcessor(out, err, false));
        SVNWCClient client = this.getClientManager().getWCClient();
        boolean error = false;
        for (int i = 0; i < this.getCommandLine().getPathCount(); ++i) {
            String absolutePath = this.getCommandLine().getPathAt(i);
            try {
                client.doDelete(new File(absolutePath), force, false);
                continue;
            }
            catch (SVNException e) {
                err.println(e.getMessage());
                error = true;
            }
        }
        if (error) {
            System.exit(1);
        }
    }
}

