/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.command.SVNCommandEventProcessor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class AddCommand
extends SVNCommand {
    public final void run(PrintStream out, PrintStream err) throws SVNException {
        boolean recursive = !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE);
        boolean force = this.getCommandLine().hasArgument(SVNArgument.FORCE);
        boolean disableAutoProps = this.getCommandLine().hasArgument(SVNArgument.NO_AUTO_PROPS);
        boolean enableAutoProps = this.getCommandLine().hasArgument(SVNArgument.AUTO_PROPS);
        this.getClientManager().setEventHandler(new SVNCommandEventProcessor(out, err, false));
        SVNWCClient wcClient = this.getClientManager().getWCClient();
        if (disableAutoProps) {
            wcClient.getOptions().setUseAutoProperties(false);
        }
        if (enableAutoProps) {
            wcClient.getOptions().setUseAutoProperties(true);
        }
        boolean noIgnore = this.getCommandLine().hasArgument(SVNArgument.NO_IGNORE);
        for (int i = 0; i < this.getCommandLine().getPathCount(); ++i) {
            String absolutePath = this.getCommandLine().getPathAt(i);
            AddCommand.matchTabsInPath(absolutePath, err);
            wcClient.doAdd(new File(absolutePath), force, false, false, recursive, noIgnore);
        }
    }
}

