/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.xml.dom.parser;

import java.io.EOFException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class XMLStreamReader
extends FilterReader {
    private int currentLine = 1;
    private int currentColumn = 1;
    private int lastLineLastColumnIndex = 0;
    private int currentOffset = 0;
    private List<Character> pushbackBuffer = new ArrayList<Character>();

    public XMLStreamReader(Reader reader) {
        super(reader);
    }

    @Override
    public int read() throws IOException {
        int c = -1;
        c = this.pushbackBuffer.isEmpty() ? super.read() : (int)this.pushbackBuffer.remove(this.pushbackBuffer.size() - 1).charValue();
        if (c == 10) {
            this.lastLineLastColumnIndex = this.currentColumn;
            ++this.currentLine;
            this.currentColumn = 1;
        } else if (c != 13) {
            ++this.currentColumn;
        }
        ++this.currentOffset;
        return c;
    }

    public void unread(char c) {
        this.pushbackBuffer.add(Character.valueOf(c));
        if (c == '\n') {
            --this.currentLine;
            this.currentColumn = this.lastLineLastColumnIndex;
        } else if (c != '\r') {
            --this.currentColumn;
        }
        --this.currentOffset;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public int getCurrentColumn() {
        return this.currentColumn;
    }

    public int getCurrentOffset() {
        return this.currentOffset;
    }

    public char readValidXmlCharacter() throws IOException {
        int c = this.read();
        if (c == -1) {
            throw new EOFException();
        }
        if (c == 0 || c >= 55296 && c <= 57343 || c == 65534 | c == 65535) {
            throw new RuntimeException("Illegal character");
        }
        return (char)c;
    }

    public static boolean isNameChar(char c) {
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c == ':' || c == '_' || c == '-' || c == '.' || c == '\u00b7') {
            return true;
        }
        if (c >= '\u00c0' && c <= '\u00d6') {
            return true;
        }
        if (c >= '\u00d8' && c <= '\u00f6') {
            return true;
        }
        if (c >= '\u00f8' && c <= '\u02ff') {
            return true;
        }
        if (c >= '\u0300' && c <= '\u036f') {
            return true;
        }
        if (c >= '\u0370' && c <= '\u037d') {
            return true;
        }
        if (c >= '\u037f' && c <= '\u1fff') {
            return true;
        }
        if (c >= '\u200c' && c <= '\u200d') {
            return true;
        }
        if (c >= '\u203f' && c <= '\u2040') {
            return true;
        }
        if (c >= '\u2070' && c <= '\u218f') {
            return true;
        }
        if (c >= '\u2c00' && c <= '\u2fef') {
            return true;
        }
        if (c >= '\u3001' && c <= '\ud7ff') {
            return true;
        }
        if (c >= '\uf900' && c <= '\ufdcf') {
            return true;
        }
        return c >= '\ufdf0' && c <= '\ufffd';
    }

    public static boolean isNameStartChar(char c) {
        if (XMLStreamReader.isNameChar(c)) {
            if (c == '-' || c == '.' || c == '\u00b7') {
                return false;
            }
            if (c >= '0' && c <= '9') {
                return false;
            }
            if (c >= '\u0300' && c <= '\u036f') {
                return false;
            }
            return c < '\u203f' || c > '\u2040';
        }
        return false;
    }
}

