/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.xml.dom.parser;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import org.neogia.addonmanager.xml.dom.AttributeEqualNode;
import org.neogia.addonmanager.xml.dom.AttributeNode;
import org.neogia.addonmanager.xml.dom.AttributeValueNode;
import org.neogia.addonmanager.xml.dom.ByteOrderMarkNode;
import org.neogia.addonmanager.xml.dom.CDataSectionNode;
import org.neogia.addonmanager.xml.dom.CommentNode;
import org.neogia.addonmanager.xml.dom.DoctypeNode;
import org.neogia.addonmanager.xml.dom.DocumentNode;
import org.neogia.addonmanager.xml.dom.ElementNode;
import org.neogia.addonmanager.xml.dom.EndElementNode;
import org.neogia.addonmanager.xml.dom.MiscNode;
import org.neogia.addonmanager.xml.dom.NameNode;
import org.neogia.addonmanager.xml.dom.Node;
import org.neogia.addonmanager.xml.dom.ProcessingInstructionNode;
import org.neogia.addonmanager.xml.dom.SpaceNode;
import org.neogia.addonmanager.xml.dom.TextNode;
import org.neogia.addonmanager.xml.dom.XmlDeclNode;
import org.neogia.addonmanager.xml.dom.parser.XMLParserException;
import org.neogia.addonmanager.xml.dom.parser.XMLStreamReader;
import org.w3c.dom.Document;

public class XMLParser {
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private static final String XML_DECL_START = "<?xml";
    private static final String DOCTYPE_START = "<!DOCTYPE";
    private static final String PI_START = "<?";
    private static final String PI_END = "?>";
    private static final String COMMENT_START = "<!--";
    private static final String COMMENT_END = "-->";
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String LT = "<";
    private static final String GT = ">";
    private static final String LTSL = "</";
    private static final String SLGT = "/>";
    private XMLStreamReader xmlReader;

    public XMLParser(Reader reader) {
        this.xmlReader = new XMLStreamReader(reader);
    }

    XMLStreamReader getReader() {
        return this.xmlReader;
    }

    public boolean matchCharacter(char c) throws IOException {
        try {
            char r = this.xmlReader.readValidXmlCharacter();
            if (r != c) {
                this.xmlReader.unread(r);
            }
            return r == c;
        }
        catch (EOFException ex) {
            return false;
        }
    }

    public void unreadCharacter(char c) throws IOException {
        this.xmlReader.unread(c);
    }

    public void unreadString(String s) throws IOException {
        for (int j = s.length() - 1; j >= 0; --j) {
            this.xmlReader.unread(s.charAt(j));
        }
    }

    public void unreadNode(Node n) throws IOException {
        this.unreadString(n.toString());
    }

    public boolean matchString(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            if (this.matchCharacter(s.charAt(i))) continue;
            for (int j = i - 1; j >= 0; --j) {
                this.unreadCharacter(s.charAt(j));
            }
            return false;
        }
        return true;
    }

    public String readStringUntil(String untilString) throws IOException {
        StringBuilder builder = new StringBuilder();
        boolean matched = false;
        char stopChar = untilString.charAt(0);
        String remainingStringToMatch = untilString.substring(1);
        do {
            char c = '\u0000';
            while ((c = this.xmlReader.readValidXmlCharacter()) != stopChar) {
                builder.append(c);
            }
            if (remainingStringToMatch.length() > 0) {
                if (this.matchString(remainingStringToMatch)) {
                    matched = true;
                    continue;
                }
                builder.append(c);
                continue;
            }
            matched = true;
        } while (!matched);
        return builder.toString();
    }

    public ByteOrderMarkNode parseByteOrderMark() throws IOException {
        if (this.matchCharacter('\ufeff')) {
            return new ByteOrderMarkNode(String.valueOf('\ufeff'));
        }
        return null;
    }

    public boolean readPiStart() throws IOException {
        return this.matchString(PI_START);
    }

    public boolean readPiEnd() throws IOException {
        return this.matchString(PI_END);
    }

    public SpaceNode parseSpaces() throws IOException {
        StringBuilder builder;
        block4: {
            builder = new StringBuilder();
            int c = -1;
            while (true) {
                try {
                    c = this.xmlReader.readValidXmlCharacter();
                }
                catch (EOFException ex) {
                    break block4;
                }
                if (c != 32 && c != 9 && c != 13 && c != 10) break;
                builder.append((char)c);
            }
            this.unreadCharacter((char)c);
        }
        SpaceNode spaceNode = null;
        if (builder.length() > 0) {
            spaceNode = new SpaceNode(builder.toString());
        }
        return spaceNode;
    }

    public NameNode parseName() throws IOException {
        StringBuilder builder = new StringBuilder();
        try {
            char c = this.xmlReader.readValidXmlCharacter();
            if (!XMLStreamReader.isNameStartChar(c)) {
                this.unreadCharacter(c);
                return null;
            }
            builder.append(c);
            while (XMLStreamReader.isNameChar(c = this.xmlReader.readValidXmlCharacter())) {
                builder.append(c);
            }
            this.unreadCharacter(c);
            return new NameNode(builder.toString());
        }
        catch (EOFException ex) {
            if (builder.length() > 0) {
                return new NameNode(builder.toString());
            }
            return null;
        }
    }

    public TextNode parseCharacterData() throws IOException {
        StringBuilder builder = new StringBuilder();
        try {
            while (true) {
                char c;
                if ((c = this.xmlReader.readValidXmlCharacter()) == '<') {
                    this.unreadCharacter(c);
                    if (builder.length() > 0) {
                        return new TextNode(builder.toString());
                    }
                    return null;
                }
                builder.append(c);
            }
        }
        catch (EOFException ex) {
            if (builder.length() > 0) {
                return new TextNode(builder.toString());
            }
            return null;
        }
    }

    public ProcessingInstructionNode parseProcessingInstruction() throws IOException, XMLParserException {
        if (this.matchString(PI_START)) {
            ProcessingInstructionNode piNode = new ProcessingInstructionNode();
            NameNode nameNode = this.parseName();
            if (nameNode == null) {
                throw new XMLParserException(this, "processing intruction target missing after <?", new Object[0]);
            }
            piNode.appendInternalChild(nameNode);
            SpaceNode spaceNode = this.parseSpaces();
            if (spaceNode != null) {
                piNode.appendInternalChild(spaceNode);
            }
            piNode.appendInternalChild(new TextNode(this.readStringUntil(PI_END)));
            return piNode;
        }
        return null;
    }

    public CommentNode parseComment() throws IOException {
        CommentNode commentNode = null;
        if (this.matchString(COMMENT_START)) {
            commentNode = new CommentNode(this.readStringUntil(COMMENT_END));
        }
        return commentNode;
    }

    public CDataSectionNode parseCDataSection() throws IOException {
        CDataSectionNode cdataSectionNode = null;
        if (this.matchString(CDATA_START)) {
            cdataSectionNode = new CDataSectionNode(this.readStringUntil(CDATA_END));
        }
        return cdataSectionNode;
    }

    public MiscNode parseMisc() throws IOException, XMLParserException {
        Node miscNode = this.parseSpaces();
        if (miscNode == null && (miscNode = this.parseComment()) == null) {
            miscNode = this.parseProcessingInstruction();
        }
        return miscNode;
    }

    public AttributeValueNode parseAttributeValue() throws IOException {
        char quoteChar = this.xmlReader.readValidXmlCharacter();
        if (quoteChar != '\'' && quoteChar != '\"') {
            this.unreadCharacter(quoteChar);
            return null;
        }
        StringBuilder attrValueBuilder = new StringBuilder();
        try {
            char c = this.xmlReader.readValidXmlCharacter();
            while (c != quoteChar) {
                if (c == '<') {
                    System.out.println("forbidden '<' character in attribute value");
                    this.unreadCharacter(c);
                    this.unreadString(attrValueBuilder.toString());
                    this.unreadCharacter(quoteChar);
                    return null;
                }
                attrValueBuilder.append(c);
                c = this.xmlReader.readValidXmlCharacter();
            }
        }
        catch (EOFException ex) {
            this.unreadString(attrValueBuilder.toString());
            this.unreadCharacter(quoteChar);
            return null;
        }
        AttributeValueNode.QuoteStyle s = quoteChar == '\'' ? AttributeValueNode.QuoteStyle.SIMPLE_QUOTE : AttributeValueNode.QuoteStyle.DBL_QUOTE;
        return new AttributeValueNode(s, attrValueBuilder.toString());
    }

    public AttributeEqualNode parseAttributeEqual() throws IOException {
        StringBuilder builder = new StringBuilder();
        SpaceNode preEqSpace = this.parseSpaces();
        if (preEqSpace != null) {
            builder.append(preEqSpace.getRawData());
        }
        if (!this.matchCharacter('=')) {
            if (preEqSpace != null) {
                this.unreadNode(preEqSpace);
            }
            return null;
        }
        builder.append('=');
        SpaceNode postEqSpace = this.parseSpaces();
        if (postEqSpace != null) {
            builder.append(postEqSpace.getRawData());
        }
        return new AttributeEqualNode(builder.toString());
    }

    public AttributeNode parseAttribute() throws IOException {
        SpaceNode spaceNode = this.parseSpaces();
        if (spaceNode == null) {
            return null;
        }
        NameNode nameNode = this.parseName();
        if (nameNode == null) {
            this.unreadNode(spaceNode);
            return null;
        }
        AttributeEqualNode equalNode = this.parseAttributeEqual();
        if (equalNode == null) {
            this.unreadNode(nameNode);
            this.unreadNode(spaceNode);
            return null;
        }
        AttributeValueNode valueNode = this.parseAttributeValue();
        if (valueNode == null) {
            this.unreadNode(equalNode);
            this.unreadNode(nameNode);
            this.unreadNode(spaceNode);
            return null;
        }
        AttributeNode attributeNode = new AttributeNode();
        attributeNode.appendInternalChild(spaceNode);
        attributeNode.appendInternalChild(nameNode);
        attributeNode.appendInternalChild(equalNode);
        attributeNode.appendInternalChild(valueNode);
        return attributeNode;
    }

    public XmlDeclNode parseXmlDecl() throws IOException, XMLParserException {
        XmlDeclNode xmlDeclNode = null;
        if (this.matchString(XML_DECL_START)) {
            xmlDeclNode = new XmlDeclNode();
            AttributeNode versionAttribute = this.parseAttribute();
            if (versionAttribute == null || !"version".equals(versionAttribute.getNodeName())) {
                throw new XMLParserException(this, "missing version attribute in xml declaration", new Object[0]);
            }
            xmlDeclNode.appendInternalChild(versionAttribute);
            AttributeNode nextAttribute = this.parseAttribute();
            if (nextAttribute != null && "encoding".equals(nextAttribute.getNodeName())) {
                xmlDeclNode.appendInternalChild(nextAttribute);
                nextAttribute = this.parseAttribute();
            }
            if (nextAttribute != null && "standalone".equals(nextAttribute.getNodeName())) {
                xmlDeclNode.appendInternalChild(nextAttribute);
                nextAttribute = null;
            }
            if (nextAttribute != null) {
                throw new XMLParserException(this, "unexpected attribute '" + nextAttribute.getNodeName() + "' in xml declaration", new Object[0]);
            }
            SpaceNode spaceNode = this.parseSpaces();
            if (spaceNode != null) {
                xmlDeclNode.appendInternalChild(spaceNode);
            }
            if (!this.matchString(PI_END)) {
                throw new XMLParserException(this, "missing ?> to close xml declaration", new Object[0]);
            }
        }
        return xmlDeclNode;
    }

    public DoctypeNode parseDoctypeNode() throws IOException, XMLParserException {
        DoctypeNode doctypeNode = null;
        if (this.matchString(DOCTYPE_START)) {
            doctypeNode = new DoctypeNode();
            SpaceNode spaceNode = this.parseSpaces();
            if (spaceNode == null) {
                throw new XMLParserException(this, "space(s) required after <!DOCTYPE", new Object[0]);
            }
            doctypeNode.appendInternalChild(spaceNode);
            NameNode nameNode = this.parseName();
            if (nameNode == null) {
                throw new XMLParserException(this, "missing name in DOCTYPE declaration", new Object[0]);
            }
            doctypeNode.appendInternalChild(nameNode);
            doctypeNode.appendInternalChild(new TextNode(this.readStringUntil(GT)));
        }
        return doctypeNode;
    }

    public ElementNode parseElement() throws IOException, XMLParserException {
        ElementNode elementNode = null;
        if (this.matchString(LT)) {
            elementNode = new ElementNode();
            NameNode nameNode = this.parseName();
            if (nameNode == null) {
                throw new XMLParserException(this, "missing name in element", new Object[0]);
            }
            elementNode.appendInternalChild(nameNode);
            AttributeNode attributeNode = this.parseAttribute();
            while (attributeNode != null) {
                elementNode.appendInternalChild(attributeNode);
                attributeNode = this.parseAttribute();
            }
            SpaceNode spaceNode = this.parseSpaces();
            if (spaceNode != null) {
                elementNode.appendInternalChild(spaceNode);
            }
            elementNode.initPrefixLookups();
            if (this.matchString(SLGT)) {
                return elementNode;
            }
            if (this.matchString(GT)) {
                TextNode characterData = this.parseCharacterData();
                if (characterData != null) {
                    elementNode.appendInternalChild(characterData);
                }
                Node child = null;
                do {
                    if (this.matchString(LTSL)) continue;
                    child = this.parseCDataSection();
                    if (child == null && (child = this.parseComment()) == null && (child = this.parseProcessingInstruction()) == null && child == null) {
                        child = this.parseElement();
                    }
                    if (child == null) continue;
                    elementNode.appendChild(child);
                    characterData = this.parseCharacterData();
                    if (characterData == null) continue;
                    elementNode.appendInternalChild(characterData);
                } while (child != null);
                EndElementNode endElementNode = new EndElementNode();
                nameNode = this.parseName();
                if (nameNode == null) {
                    throw new XMLParserException(this, "missing name in close tag of element '" + elementNode.getNodeName() + "'", new Object[0]);
                }
                endElementNode.appendInternalChild(nameNode);
                spaceNode = this.parseSpaces();
                if (spaceNode != null) {
                    endElementNode.appendInternalChild(spaceNode);
                }
                if (!this.matchString(GT)) {
                    throw new XMLParserException(this, "'>' expected", new Object[0]);
                }
                elementNode.appendInternalChild(endElementNode);
                elementNode.initNodeLinks(elementNode.getChildNodes());
            } else {
                throw new XMLParserException(this, "Missing '/>' or '>' for start tag of element '" + nameNode.getRawData() + "'", new Object[0]);
            }
        }
        return elementNode;
    }

    public Document parse() throws IOException, XMLParserException {
        ElementNode rootElement;
        XmlDeclNode xmlDeclNode;
        DocumentNode docNode = new DocumentNode();
        ByteOrderMarkNode bomNode = this.parseByteOrderMark();
        if (bomNode != null) {
            docNode.appendInternalChild(bomNode);
        }
        if ((xmlDeclNode = this.parseXmlDecl()) != null) {
            docNode.appendInternalChild(xmlDeclNode);
        }
        MiscNode miscNode = null;
        while ((miscNode = this.parseMisc()) != null) {
            docNode.appendInternalChild((Node)((Object)miscNode));
        }
        DoctypeNode doctypeNode = this.parseDoctypeNode();
        if (doctypeNode != null) {
            docNode.appendInternalChild(doctypeNode);
            while ((miscNode = this.parseMisc()) != null) {
                docNode.appendInternalChild((Node)((Object)miscNode));
            }
        }
        if ((rootElement = this.parseElement()) == null) {
            throw new XMLParserException(this, "Missing root element", new Object[0]);
        }
        docNode.appendInternalChild(rootElement);
        while ((miscNode = this.parseMisc()) != null) {
            docNode.appendInternalChild((Node)((Object)miscNode));
        }
        docNode.initNodeLinks(docNode.getChildNodes());
        return docNode;
    }
}

