/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.xml.dom;

import java.util.LinkedHashMap;
import org.neogia.addonmanager.xml.dom.AttributeNode;
import org.neogia.addonmanager.xml.dom.Node;
import org.neogia.addonmanager.xml.dom.ProcessingInstructionNode;
import org.neogia.addonmanager.xml.dom.SpaceNode;
import org.w3c.dom.DOMException;

public class XmlDeclNode
extends ProcessingInstructionNode {
    public static final String VERSION = "version";
    public static final String ENCODING = "encoding";
    public static final String STANDALONE = "standalone";
    private LinkedHashMap<String, AttributeNode> attributes = new LinkedHashMap();
    private SpaceNode finalSpaceNode;

    @Override
    public short getNodeType() {
        return 10003;
    }

    public String getXmlEncoding() {
        AttributeNode encodingNode = this.attributes.get(ENCODING);
        return encodingNode != null ? encodingNode.getValue() : null;
    }

    public void setXmlEncoding(String encoding) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    public boolean getXmlStandalone() {
        AttributeNode standaloneNode = this.attributes.get(STANDALONE);
        return standaloneNode != null ? "yes".equals(standaloneNode.getValue()) : false;
    }

    public void setXmlStandalone(boolean arg0) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    public String getXmlVersion() {
        AttributeNode versionNode = this.attributes.get(VERSION);
        return versionNode != null ? versionNode.getValue() : null;
    }

    public void setXmlVersion(String arg0) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Node appendInternalChild(Node child) throws DOMException {
        switch (child.getNodeType()) {
            case 2: {
                AttributeNode attributeNode = (AttributeNode)child;
                if (this.attributes.get(attributeNode.getName()) != null) break;
                this.attributes.put(attributeNode.getName(), attributeNode);
                break;
            }
            case 10001: {
                if (this.finalSpaceNode != null) break;
                this.finalSpaceNode = (SpaceNode)child;
                break;
            }
            default: {
                throw new DOMException(3, "invalid node type " + child.getNodeType());
            }
        }
        child.setParentNode(this);
        return child;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml");
        for (AttributeNode node : this.attributes.values()) {
            builder.append(node);
        }
        if (this.finalSpaceNode != null) {
            builder.append(this.finalSpaceNode);
        }
        builder.append("?>");
        return builder.toString();
    }
}

