/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.xml.dom;

import org.neogia.addonmanager.xml.dom.NodeList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.UserDataHandler;

public abstract class Node
implements org.w3c.dom.Node {
    public static final short NIL_NODE = 10000;
    public static final short SPACE_NODE = 10001;
    public static final short NAME_NODE = 10002;
    public static final short XML_DECL_NODE = 10003;
    public static final short ATTR_EQ_NODE = 10004;
    public static final short END_ELEMENT_NODE = 10005;
    public static final short BYTE_ORDER_MARK_NODE = 10006;
    private Node parentNode;
    private Node firstChildNode;
    private Node previousSiblingNode;
    private Node nextSiblingNode;

    public void initNodeLinks(org.w3c.dom.NodeList nodeList) {
        Node previousNode = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = (Node)nodeList.item(i);
            node.parentNode = this;
            if (i == 0) {
                this.firstChildNode = node;
            }
            if (previousNode != null) {
                previousNode.nextSiblingNode = node;
            }
            node.previousSiblingNode = previousNode;
            previousNode = node;
        }
    }

    @Override
    public org.w3c.dom.Node getParentNode() {
        return this.parentNode;
    }

    void setParentNode(Node parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public org.w3c.dom.Node getNextSibling() {
        return this.nextSiblingNode;
    }

    void setNextSibling(Node nextSiblingNode) {
        this.nextSiblingNode = nextSiblingNode;
    }

    void setPreviousSibling(Node previousSiblingNode) {
        this.previousSiblingNode = previousSiblingNode;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return null;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            return "xmlns";
        }
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return false;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public final org.w3c.dom.Node appendChild(org.w3c.dom.Node child) throws DOMException {
        return this.appendInternalChild((Node)child);
    }

    public abstract Node appendInternalChild(Node var1) throws DOMException;

    public NodeList getInternalChildNodes() {
        return new NodeList();
    }

    @Override
    public String getBaseURI() {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Document getOwnerDocument() {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public org.w3c.dom.Node getPreviousSibling() {
        return this.previousSiblingNode;
    }

    @Override
    public Object getFeature(String arg0, String arg1) {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node newChild, org.w3c.dom.Node refChild) throws DOMException {
        NodeList l = (NodeList)this.getChildNodes();
        if (refChild == null) {
            l.add((Node)newChild);
            this.setChildNodes(l);
            this.initNodeLinks(l);
            return l.item(0);
        }
        for (int i = 0; i < l.getLength(); ++i) {
            org.w3c.dom.Node n = l.item(i);
            if (!n.equals(refChild)) continue;
            l.add(i, (Node)newChild);
            this.setChildNodes(l);
            this.initNodeLinks(l);
            return l.item(i);
        }
        throw new DOMException(8, refChild.getNodeName() + " not found in " + this.getNodeName());
    }

    public abstract void setChildNodes(org.w3c.dom.NodeList var1);

    @Override
    public org.w3c.dom.Node getFirstChild() {
        if (this.hasChildNodes()) {
            return this.getChildNodes().item(0);
        }
        return null;
    }

    @Override
    public org.w3c.dom.Node getLastChild() {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public org.w3c.dom.Node removeChild(org.w3c.dom.Node child) throws DOMException {
        NodeList childList = (NodeList)this.getChildNodes();
        childList.remove(child);
        this.setChildNodes(childList);
        return child;
    }

    @Override
    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node arg0, org.w3c.dom.Node arg1) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public String getTextContent() throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public void setTextContent(String content) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Object getUserData(String arg0) {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Object setUserData(String arg0, Object arg1, UserDataHandler arg2) {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public org.w3c.dom.Node cloneNode(boolean arg0) {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public short compareDocumentPosition(org.w3c.dom.Node arg0) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public void normalize() {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public boolean isEqualNode(org.w3c.dom.Node arg0) {
        if (arg0 == this) {
            return true;
        }
        if (arg0.getNodeType() != this.getNodeType()) {
            return false;
        }
        if (this.getNodeName() == null ? arg0.getNodeName() != null : !this.getNodeName().equals(arg0.getNodeName())) {
            return false;
        }
        if (this.getLocalName() == null ? arg0.getLocalName() != null : !this.getLocalName().equals(arg0.getLocalName())) {
            return false;
        }
        if (this.getNamespaceURI() == null ? arg0.getNamespaceURI() != null : !this.getNamespaceURI().equals(arg0.getNamespaceURI())) {
            return false;
        }
        if (this.getPrefix() == null ? arg0.getPrefix() != null : !this.getPrefix().equals(arg0.getPrefix())) {
            return false;
        }
        if (this.getNodeValue() == null ? arg0.getNodeValue() != null : !this.getNodeValue().equals(arg0.getNodeValue())) {
            return false;
        }
        NamedNodeMap attrListToCompare = arg0.getAttributes();
        NamedNodeMap attrList = this.getAttributes();
        if (attrList == null) {
            if (attrListToCompare != null) {
                return false;
            }
        } else {
            if (attrListToCompare == null) {
                return false;
            }
            int nb = attrList.getLength();
            if (nb != attrListToCompare.getLength()) {
                return false;
            }
            for (int i = 0; i < nb; ++i) {
                if (attrList.item(i).isEqualNode(attrListToCompare.item(i))) continue;
                return false;
            }
        }
        org.w3c.dom.NodeList nodeList = this.getChildNodes();
        org.w3c.dom.NodeList nodeListToCompare = arg0.getChildNodes();
        if (nodeList == null) {
            if (nodeListToCompare != null) {
                return false;
            }
        } else {
            if (nodeListToCompare == null) {
                return false;
            }
            int nb = nodeList.getLength();
            if (nb != nodeListToCompare.getLength()) {
                return false;
            }
            for (int i = 0; i < nb; ++i) {
                if (nodeList.item(i).isEqualNode(nodeListToCompare.item(i))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSameNode(org.w3c.dom.Node arg0) {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public boolean isSupported(String arg0, String arg1) {
        throw new UnsupportedOperationException("operation not yet implemented");
    }
}

