/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.xml.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.neogia.addonmanager.xml.dom.AttributeNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class NamedNodeMap
extends ArrayList<AttributeNode>
implements org.w3c.dom.NamedNodeMap {
    private static final long serialVersionUID = -3114275727760964914L;
    private Map<String, AttributeNode> attributesByName = new HashMap<String, AttributeNode>();

    @Override
    public boolean add(AttributeNode attribute) {
        if (super.add(attribute)) {
            this.attributesByName.put(attribute.getNodeName(), attribute);
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, AttributeNode attribute) {
        super.add(index, attribute);
        this.attributesByName.put(attribute.getNodeName(), attribute);
    }

    @Override
    public AttributeNode remove(int index) {
        AttributeNode attribute = (AttributeNode)super.remove(index);
        this.attributesByName.remove(attribute.getNodeName());
        return attribute;
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            AttributeNode attribute = (AttributeNode)o;
            this.attributesByName.remove(attribute.getNodeName());
            return true;
        }
        return false;
    }

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public Node getNamedItem(String name) {
        return this.attributesByName.get(name);
    }

    @Override
    public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
        if (namespaceURI == null) {
            return this.getNamedItem(localName);
        }
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Node item(int index) {
        return (Node)this.get(index);
    }

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        AttributeNode attribute = this.attributesByName.remove(name);
        if (attribute != null) {
            super.remove(attribute);
        }
        return attribute;
    }

    @Override
    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        if (namespaceURI == null) {
            return this.removeNamedItem(localName);
        }
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Node setNamedItem(Node node) throws DOMException {
        AttributeNode attribute = (AttributeNode)node;
        AttributeNode oldAttribute = (AttributeNode)this.getNamedItem(node.getNodeName());
        if (oldAttribute != null) {
            throw new UnsupportedOperationException("operation not yet implemented");
        }
        this.add(attribute);
        return attribute;
    }

    @Override
    public Node setNamedItemNS(Node node) throws DOMException {
        if (node.getNamespaceURI() != null) {
            throw new UnsupportedOperationException("operation not yet implemented");
        }
        return this.setNamedItem(node);
    }
}

