/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.xml.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neogia.addonmanager.xml.dom.AttributeNode;
import org.neogia.addonmanager.xml.dom.ContentNode;
import org.neogia.addonmanager.xml.dom.EndElementNode;
import org.neogia.addonmanager.xml.dom.NameNode;
import org.neogia.addonmanager.xml.dom.NamedNodeMap;
import org.neogia.addonmanager.xml.dom.Node;
import org.neogia.addonmanager.xml.dom.NodeList;
import org.neogia.addonmanager.xml.dom.SpaceNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.TypeInfo;

public class ElementNode
extends Node
implements Element,
ContentNode {
    private NameNode tagNode;
    private NamedNodeMap attributes;
    private SpaceNode startTagFinalSpaceNode;
    private List<ContentNode> contents = new ArrayList<ContentNode>();
    private EndElementNode endElementNode;
    private Map<String, String> prefixToNS = null;
    private Map<String, String> NSToPrefix = null;

    public ElementNode() {
        this.attributes = new NamedNodeMap();
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
    }

    public List<ContentNode> getContents() {
        return this.contents;
    }

    public EndElementNode getEndElementNode() {
        return this.endElementNode;
    }

    public NameNode getNameNode() {
        return this.tagNode;
    }

    @Override
    public String getNamespaceURI() {
        return this.tagNode.getNamespaceURI();
    }

    @Override
    public String getLocalName() {
        return this.tagNode.getLocalName();
    }

    @Override
    public String getPrefix() {
        return this.tagNode.getPrefix();
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        this.tagNode.setPrefix(prefix);
    }

    @Override
    public org.w3c.dom.NamedNodeMap getAttributes() {
        return this.attributes;
    }

    public SpaceNode getSpaceNode() {
        return this.startTagFinalSpaceNode;
    }

    @Override
    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        String prefix;
        if (this.NSToPrefix != null && "".equals(prefix = this.NSToPrefix.get(namespaceURI))) {
            return true;
        }
        if (this.getParentNode() != null) {
            return this.getParentNode().isDefaultNamespace(namespaceURI);
        }
        return false;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        String namespaceURI = null;
        if (this.prefixToNS != null) {
            namespaceURI = this.prefixToNS.get(prefix == null ? "" : prefix);
        }
        if (namespaceURI == null && this.getParentNode() != null) {
            namespaceURI = this.getParentNode().lookupNamespaceURI(prefix);
        }
        return namespaceURI;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        String prefix = null;
        if (this.NSToPrefix != null) {
            prefix = this.NSToPrefix.get(namespaceURI);
        }
        if (prefix == null && this.getParentNode() != null) {
            prefix = this.getParentNode().lookupPrefix(namespaceURI);
        }
        return prefix;
    }

    @Override
    public Node appendInternalChild(Node child) throws DOMException {
        switch (child.getNodeType()) {
            case 10002: {
                if (this.tagNode != null) break;
                this.tagNode = (NameNode)child;
                break;
            }
            case 2: {
                AttributeNode attribute = (AttributeNode)child;
                this.attributes.setNamedItem(attribute);
                break;
            }
            case 10001: {
                if (this.startTagFinalSpaceNode != null) break;
                this.startTagFinalSpaceNode = (SpaceNode)child;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                this.contents.add((ContentNode)((Object)child));
                break;
            }
            case 10005: {
                if (this.endElementNode != null) break;
                this.endElementNode = (EndElementNode)child;
                break;
            }
            default: {
                throw new DOMException(3, "invalid node type " + child.getNodeType());
            }
        }
        child.setParentNode(this);
        return child;
    }

    @Override
    public boolean hasChildNodes() {
        return !this.contents.isEmpty();
    }

    @Override
    public org.w3c.dom.NodeList getChildNodes() {
        NodeList l = new NodeList();
        for (ContentNode n : this.contents) {
            l.add((Node)((Object)n));
        }
        return l;
    }

    @Override
    public void setChildNodes(org.w3c.dom.NodeList c) {
        this.contents.clear();
        for (int i = 0; i < c.getLength(); ++i) {
            this.contents.add((ContentNode)c.item(i));
        }
    }

    @Override
    public boolean hasAttribute(String arg0) {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public String getAttribute(String name) {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public String getAttributeNS(String arg0, String arg1) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Attr getAttributeNode(String arg0) {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Attr getAttributeNodeNS(String arg0, String arg1) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public org.w3c.dom.NodeList getElementsByTagName(String arg0) {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public org.w3c.dom.NodeList getElementsByTagNameNS(String arg0, String arg1) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public String getTagName() {
        return this.tagNode != null ? this.tagNode.getData() : null;
    }

    @Override
    public boolean hasAttributeNS(String arg0, String arg1) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public void removeAttribute(String attrName) throws DOMException {
        NamedNodeMap attrList = (NamedNodeMap)this.getAttributes();
        attrList.remove(this.getAttributes().getNamedItem(attrName));
    }

    @Override
    public void removeAttributeNS(String arg0, String arg1) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Attr removeAttributeNode(Attr arg0) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public void setAttribute(String arg0, String arg1) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public void setAttributeNS(String arg0, String arg1, String arg2) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Attr setAttributeNode(Attr arg0) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Attr setAttributeNodeNS(Attr arg0) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public void setIdAttribute(String arg0, boolean arg1) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public void setIdAttributeNS(String arg0, String arg1, boolean arg2) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public void setIdAttributeNode(Attr arg0, boolean arg1) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    public void initPrefixLookups() {
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            AttributeNode node = (AttributeNode)this.attributes.item(i);
            if (!node.getNodeName().startsWith("xmlns")) continue;
            String[] split = node.getNodeName().split(":", 2);
            String prefix = "";
            if (split.length == 2) {
                prefix = split[1];
            }
            if (this.prefixToNS == null) {
                this.prefixToNS = new HashMap<String, String>();
                this.NSToPrefix = new HashMap<String, String>();
            }
            this.prefixToNS.put(prefix, node.getNodeValue());
            this.NSToPrefix.put(node.getNodeValue(), prefix);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        if (this.tagNode != null) {
            builder.append(this.tagNode);
        }
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            builder.append(this.attributes.get(i));
        }
        if (this.startTagFinalSpaceNode != null) {
            builder.append(this.startTagFinalSpaceNode);
        }
        if (this.contents.isEmpty() && this.endElementNode == null) {
            builder.append("/>");
        } else {
            builder.append(">");
            for (ContentNode contentNode : this.contents) {
                builder.append(contentNode);
            }
            if (this.endElementNode != null) {
                builder.append(this.endElementNode);
            }
        }
        return builder.toString();
    }
}

