/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.xml.dom;

import java.util.ArrayList;
import java.util.List;
import org.neogia.addonmanager.xml.dom.AttributeNode;
import org.neogia.addonmanager.xml.dom.ByteOrderMarkNode;
import org.neogia.addonmanager.xml.dom.CDataSectionNode;
import org.neogia.addonmanager.xml.dom.CommentNode;
import org.neogia.addonmanager.xml.dom.ContentNode;
import org.neogia.addonmanager.xml.dom.DoctypeNode;
import org.neogia.addonmanager.xml.dom.ElementNode;
import org.neogia.addonmanager.xml.dom.MiscNode;
import org.neogia.addonmanager.xml.dom.NameNode;
import org.neogia.addonmanager.xml.dom.Node;
import org.neogia.addonmanager.xml.dom.NodeList;
import org.neogia.addonmanager.xml.dom.ProcessingInstructionNode;
import org.neogia.addonmanager.xml.dom.SpaceNode;
import org.neogia.addonmanager.xml.dom.TextNode;
import org.neogia.addonmanager.xml.dom.XmlDeclNode;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentNode
extends Node
implements Document {
    private ByteOrderMarkNode bomNode;
    private XmlDeclNode xmlDeclNode;
    private List<MiscNode> preMiscNodes = new ArrayList<MiscNode>();
    private DoctypeNode doctypeNode;
    private List<MiscNode> dtMiscNodes = new ArrayList<MiscNode>();
    private ElementNode rootElement;
    private List<MiscNode> postMiscNodes = new ArrayList<MiscNode>();

    @Override
    public short getNodeType() {
        return 9;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
    }

    @Override
    public org.w3c.dom.NodeList getChildNodes() {
        NodeList list = new NodeList();
        for (MiscNode miscNode : this.preMiscNodes) {
            if (!(miscNode instanceof CommentNode) && !(miscNode instanceof ProcessingInstructionNode)) continue;
            list.add((Node)((Object)miscNode));
        }
        if (this.doctypeNode != null) {
            list.add(this.doctypeNode);
        }
        for (MiscNode miscNode : this.dtMiscNodes) {
            if (!(miscNode instanceof CommentNode) && !(miscNode instanceof ProcessingInstructionNode)) continue;
            list.add((Node)((Object)miscNode));
        }
        list.add(this.rootElement);
        for (MiscNode miscNode : this.postMiscNodes) {
            if (!(miscNode instanceof CommentNode) && !(miscNode instanceof ProcessingInstructionNode)) continue;
            list.add((Node)((Object)miscNode));
        }
        return list;
    }

    @Override
    public boolean hasChildNodes() {
        return this.rootElement != null;
    }

    @Override
    public org.w3c.dom.Node adoptNode(org.w3c.dom.Node arg0) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        AttributeNode a = new AttributeNode();
        a.setNameNode(new NameNode(name));
        a.setSpaceNode(new SpaceNode(" "));
        a.setNodeValue("");
        return a;
    }

    @Override
    public Attr createAttributeNS(String arg0, String arg1) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public CDATASection createCDATASection(String arg0) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Comment createComment(String arg0) {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Element createElement(String arg0) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Element createElementNS(String arg0, String arg1) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public EntityReference createEntityReference(String arg0) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String arg0, String arg1) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Text createTextNode(String text) {
        return new TextNode(text);
    }

    @Override
    public DocumentType getDoctype() {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Element getDocumentElement() {
        return this.rootElement;
    }

    @Override
    public String getDocumentURI() {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public DOMConfiguration getDomConfig() {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Element getElementById(String arg0) {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public org.w3c.dom.NodeList getElementsByTagName(String arg0) {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public org.w3c.dom.NodeList getElementsByTagNameNS(String arg0, String arg1) {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public DOMImplementation getImplementation() {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public String getInputEncoding() {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public String getXmlEncoding() {
        return this.xmlDeclNode != null ? this.xmlDeclNode.getXmlEncoding() : null;
    }

    @Override
    public boolean getXmlStandalone() {
        return this.xmlDeclNode != null ? this.xmlDeclNode.getXmlStandalone() : false;
    }

    @Override
    public String getXmlVersion() {
        return this.xmlDeclNode != null ? this.xmlDeclNode.getXmlVersion() : "1.0";
    }

    @Override
    public org.w3c.dom.Node importNode(org.w3c.dom.Node importedNode, boolean deep) throws DOMException {
        Node result = null;
        switch (importedNode.getNodeType()) {
            case 2: {
                AttributeNode attr = (AttributeNode)importedNode;
                result = new AttributeNode();
                result.appendChild(attr.getSpaceNode());
                result.appendChild(attr.getNameNode());
                result.appendChild(attr.getEqualNode());
                result.appendChild(attr.getValueNode());
                break;
            }
            case 1: {
                ElementNode element = (ElementNode)importedNode;
                result = new ElementNode();
                result.appendChild(element.getNameNode());
                if (element.hasAttributes()) {
                    NamedNodeMap attrList = element.getAttributes();
                    for (int i = 0; i < attrList.getLength(); ++i) {
                        result.appendChild(attrList.item(i));
                    }
                }
                if (element.getSpaceNode() != null) {
                    result.appendChild(element.getSpaceNode());
                }
                List<ContentNode> l = element.getContents();
                for (ContentNode c : l) {
                    result.appendChild(c);
                }
                if (element.getEndElementNode() == null) break;
                result.appendChild(element.getEndElementNode());
                break;
            }
            case 7: {
                ProcessingInstructionNode pin = (ProcessingInstructionNode)importedNode;
                result = new ProcessingInstructionNode();
                result.appendChild(pin.getTargetNode());
                result.appendChild(pin.getSpaceNode());
                result.appendChild(pin.getDataNode());
                break;
            }
            case 3: {
                result = new TextNode(importedNode.getNodeValue());
                break;
            }
            case 4: {
                result = new CDataSectionNode(importedNode.getNodeValue());
                break;
            }
            case 8: {
                result = new CommentNode(importedNode.getNodeValue());
                break;
            }
            default: {
                throw new DOMException(9, "Unable to import node type: " + importedNode.getNodeType());
            }
        }
        return result;
    }

    @Override
    public void normalizeDocument() {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public org.w3c.dom.Node renameNode(org.w3c.dom.Node arg0, String arg1, String arg2) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public void setDocumentURI(String arg0) {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public void setStrictErrorChecking(boolean arg0) {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public void setXmlStandalone(boolean arg0) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public void setXmlVersion(String arg0) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public void setChildNodes(org.w3c.dom.NodeList arg0) {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Node appendInternalChild(Node child) throws DOMException {
        switch (child.getNodeType()) {
            case 10006: {
                if (this.bomNode != null) break;
                this.bomNode = (ByteOrderMarkNode)child;
                break;
            }
            case 10003: {
                if (this.xmlDeclNode != null) break;
                this.xmlDeclNode = (XmlDeclNode)child;
                break;
            }
            case 10: {
                if (this.doctypeNode != null) break;
                this.doctypeNode = (DoctypeNode)child;
                break;
            }
            case 1: {
                if (this.rootElement != null) break;
                this.rootElement = (ElementNode)child;
                break;
            }
            case 7: 
            case 8: 
            case 10001: {
                if (this.rootElement == null) {
                    if (this.doctypeNode == null) {
                        this.preMiscNodes.add((MiscNode)((Object)child));
                        break;
                    }
                    this.dtMiscNodes.add((MiscNode)((Object)child));
                    break;
                }
                this.postMiscNodes.add((MiscNode)((Object)child));
                break;
            }
            default: {
                throw new DOMException(3, "invalid node type " + child.getNodeType());
            }
        }
        child.setParentNode(this);
        return child;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.bomNode != null) {
            builder.append(this.bomNode);
        }
        if (this.xmlDeclNode != null) {
            builder.append(this.xmlDeclNode);
        }
        for (MiscNode miscNode : this.preMiscNodes) {
            builder.append(miscNode);
        }
        if (this.doctypeNode != null) {
            builder.append(this.doctypeNode);
        }
        for (MiscNode miscNode : this.dtMiscNodes) {
            builder.append(miscNode);
        }
        if (this.rootElement != null) {
            builder.append(this.rootElement);
        }
        for (MiscNode miscNode : this.postMiscNodes) {
            builder.append(miscNode);
        }
        return builder.toString();
    }
}

