/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.xml.dom;

import org.neogia.addonmanager.xml.dom.ContentNode;
import org.neogia.addonmanager.xml.dom.Node;
import org.neogia.addonmanager.xml.dom.NodeList;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;

public abstract class CharacterDataNode
extends Node
implements CharacterData,
ContentNode {
    protected String rawdata;
    protected String data;

    public CharacterDataNode(String value) {
        this.rawdata = value;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getData();
    }

    @Override
    public void setNodeValue(String value) throws DOMException {
        this.setData(value);
    }

    @Override
    public Node appendInternalChild(Node child) throws DOMException {
        throw new DOMException(3, "invalid node type " + child.getNodeType());
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public org.w3c.dom.NodeList getChildNodes() {
        return new NodeList();
    }

    @Override
    public void appendData(String arg) throws DOMException {
        this.setData(this.getData() + arg);
    }

    @Override
    public void deleteData(int offset, int count) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    public String getRawData() {
        return this.rawdata;
    }

    @Override
    public String getData() throws DOMException {
        if (this.data == null) {
            this.data = this.convertRawdataToData(this.rawdata);
            if (this.data.equals(this.rawdata)) {
                this.data = this.rawdata;
            }
        }
        return this.data;
    }

    @Override
    public int getLength() {
        return this.getData().length();
    }

    @Override
    public void insertData(int offset, String arg) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public void replaceData(int offset, int count, String arg) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public void setData(String data) throws DOMException {
        this.rawdata = data;
        this.data = data;
    }

    @Override
    public String substringData(int offset, int count) throws DOMException {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    protected String convertRawdataToData(String rawdata) {
        return rawdata.replaceAll("\r\n", "\n").replaceAll("\r\u0085", "\n").replaceAll("\u0085", "\n").replaceAll("\u2028", "\n").replaceAll("\r", "\n");
    }

    public String toString() {
        return this.rawdata;
    }
}

