/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.xml.dom;

import org.neogia.addonmanager.xml.dom.AttributeEqualNode;
import org.neogia.addonmanager.xml.dom.AttributeValueNode;
import org.neogia.addonmanager.xml.dom.NameNode;
import org.neogia.addonmanager.xml.dom.Node;
import org.neogia.addonmanager.xml.dom.NodeList;
import org.neogia.addonmanager.xml.dom.SpaceNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.TypeInfo;

public class AttributeNode
extends Node
implements Attr {
    private SpaceNode spaceNode;
    private NameNode nameNode;
    private AttributeEqualNode equalNode;
    private AttributeValueNode valueNode;

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.nameNode != null ? this.nameNode.getRawData() : null;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.valueNode != null ? this.valueNode.getNodeValue() : null;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        if (this.valueNode == null) {
            if (this.equalNode == null) {
                this.equalNode = new AttributeEqualNode("=");
            }
            this.valueNode = new AttributeValueNode(nodeValue);
        } else {
            this.valueNode.setNodeValue(nodeValue);
        }
    }

    @Override
    public String getNamespaceURI() {
        if ("xmlns".equals(this.nameNode.getNodeValue())) {
            return this.lookupNamespaceURI("xmlns");
        }
        return this.nameNode.getNamespaceURI();
    }

    @Override
    public String getLocalName() {
        return this.nameNode.getLocalName();
    }

    @Override
    public String getPrefix() {
        return this.nameNode.getPrefix();
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        this.nameNode.setPrefix(prefix);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        if (this.getParentNode() != null) {
            return this.getParentNode().lookupNamespaceURI(prefix);
        }
        return super.lookupNamespaceURI(prefix);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        if (this.getParentNode() != null) {
            return this.getParentNode().lookupPrefix(namespaceURI);
        }
        return super.lookupPrefix(namespaceURI);
    }

    @Override
    public boolean hasChildNodes() {
        return true;
    }

    @Override
    public org.w3c.dom.NodeList getChildNodes() {
        NodeList children = new NodeList();
        children.add(this.valueNode);
        return children;
    }

    @Override
    public void setChildNodes(org.w3c.dom.NodeList c) {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public Element getOwnerElement() {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public boolean getSpecified() {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public String getValue() {
        return this.valueNode != null ? this.valueNode.getNodeValue() : null;
    }

    @Override
    public boolean isId() {
        throw new UnsupportedOperationException("operation not yet implemented");
    }

    @Override
    public void setValue(String value) throws DOMException {
        this.valueNode.setData(value);
    }

    @Override
    public Node appendInternalChild(Node child) throws DOMException {
        switch (child.getNodeType()) {
            case 10001: {
                if (this.spaceNode != null) break;
                this.spaceNode = (SpaceNode)child;
                break;
            }
            case 10002: {
                if (this.nameNode != null) break;
                this.nameNode = (NameNode)child;
                break;
            }
            case 10004: {
                if (this.equalNode != null) break;
                this.equalNode = (AttributeEqualNode)child;
                break;
            }
            case 3: {
                if (this.valueNode != null) break;
                this.valueNode = (AttributeValueNode)child;
                break;
            }
            default: {
                throw new DOMException(3, "invalid node type " + child.getNodeType());
            }
        }
        child.setParentNode(this);
        return child;
    }

    public SpaceNode getSpaceNode() {
        return this.spaceNode;
    }

    public void setSpaceNode(SpaceNode spaceNode) {
        this.spaceNode = spaceNode;
    }

    public NameNode getNameNode() {
        return this.nameNode;
    }

    public void setNameNode(NameNode nameNode) {
        this.nameNode = nameNode;
    }

    public AttributeEqualNode getEqualNode() {
        return this.equalNode;
    }

    public void setEqualNode(AttributeEqualNode equalNode) {
        this.equalNode = equalNode;
    }

    public AttributeValueNode getValueNode() {
        return this.valueNode;
    }

    public void setValueNode(AttributeValueNode valueNode) {
        this.valueNode = valueNode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.spaceNode != null) {
            builder.append(this.spaceNode);
        }
        if (this.nameNode != null) {
            builder.append(this.nameNode);
        }
        if (this.equalNode != null) {
            builder.append(this.equalNode);
        }
        if (this.valueNode != null) {
            builder.append(this.valueNode);
        }
        return builder.toString();
    }
}

