/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xml.serialize.OutputFormat;
import org.neogia.addonmanager.AddOnManagerException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class UtilXml {
    public static final String module = UtilXml.class.getName();
    private static final Log logger = LogFactory.getLog("addonmanager.addon");

    public static Transformer createOutputTransformer(String encoding, boolean omitXmlDeclaration, boolean indent, int indentAmount) throws TransformerConfigurationException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xalan=\"http://xml.apache.org/xslt\" version=\"1.0\">\n");
        sb.append("<xsl:output method=\"xml\" encoding=\"");
        sb.append(encoding == null ? "UTF-8" : encoding);
        sb.append("\"");
        if (omitXmlDeclaration) {
            sb.append(" omit-xml-declaration=\"yes\"");
        }
        sb.append(" indent=\"");
        sb.append(indent ? "yes" : "no");
        sb.append("\"");
        if (indent) {
            sb.append(" xalan:indent-amount=\"");
            sb.append(indentAmount <= 0 ? 4 : indentAmount);
            sb.append("\"");
        }
        sb.append("/>\n<xsl:strip-space elements=\"*\"/>\n");
        sb.append("<xsl:template match=\"@*|node()\">\n");
        sb.append("<xsl:copy><xsl:apply-templates select=\"@*|node()\"/></xsl:copy>\n");
        sb.append("</xsl:template>\n</xsl:stylesheet>\n");
        ByteArrayInputStream bis = new ByteArrayInputStream(sb.toString().getBytes());
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(bis));
        transformer.setOutputProperty("standalone", "yes");
        return transformer;
    }

    public static void transformDomDocument(Transformer transformer, Node node, OutputStream os) throws TransformerException {
        DOMSource source = new DOMSource(node);
        StreamResult result = new StreamResult(os);
        transformer.transform(source, result);
    }

    public static void writeXmlDocument(Node node, OutputStream os, String encoding, boolean omitXmlDeclaration, boolean indent, int indentAmount) throws TransformerException {
        Transformer transformer = UtilXml.createOutputTransformer(encoding, omitXmlDeclaration, indent, indentAmount);
        UtilXml.transformDomDocument(transformer, node, os);
    }

    public static String writeXmlDocument(Node node) throws IOException {
        if (node == null) {
            logger.warn("[UtilXml.writeXmlDocument] Node was null, doing nothing");
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        UtilXml.writeXmlDocument(bos, node);
        return bos.toString("UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXmlDocument(String filename, Node node) throws FileNotFoundException, IOException {
        if (node == null) {
            logger.warn("[UtilXml.writeXmlDocument] Node was null, doing nothing");
            return;
        }
        if (filename == null) {
            logger.warn("[UtilXml.writeXmlDocument] Filename was null, doing nothing");
            return;
        }
        File outFile = new File(filename);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outFile);
            UtilXml.writeXmlDocument(fos, node);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static void writeXmlDocument(OutputStream os, Node node) throws IOException {
        if (node == null) {
            logger.warn("[UtilXml.writeXmlDocument] Node was null, doing nothing");
            return;
        }
        try {
            UtilXml.writeXmlDocument(node, os, "UTF-8", false, true, 4);
        }
        catch (TransformerException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Deprecated
    public static void writeXmlDocument(OutputStream os, Element element, OutputFormat format) throws IOException {
        if (element == null) {
            logger.warn("[UtilXml.writeXmlDocument] Element was null, doing nothing");
            return;
        }
        if (os == null) {
            logger.warn("[UtilXml.writeXmlDocument] OutputStream was null, doing nothing");
            return;
        }
        try {
            UtilXml.writeXmlDocument(element, os, format.getEncoding(), format.getOmitXMLDeclaration(), format.getIndenting(), format.getIndent());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static Document readXmlDocument(String content) throws SAXException, ParserConfigurationException, IOException {
        return UtilXml.readXmlDocument(content, true);
    }

    public static Document readXmlDocument(String content, boolean validate) throws SAXException, ParserConfigurationException, IOException {
        if (content == null) {
            logger.warn("[UtilXml.readXmlDocument] content was null, doing nothing");
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(content.getBytes("UTF-8"));
        return UtilXml.readXmlDocument((InputStream)bis, validate, "Internal Content");
    }

    public static Document readXmlDocument(String content, boolean validate, boolean withPosition) throws SAXException, ParserConfigurationException, IOException {
        if (content == null) {
            logger.warn("[UtilXml.readXmlDocument] content was null, doing nothing");
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(content.getBytes("UTF-8"));
        return UtilXml.readXmlDocument(bis, validate, "Internal Content", withPosition);
    }

    public static Document readXmlDocument(URL url) throws SAXException, ParserConfigurationException, IOException {
        return UtilXml.readXmlDocument(url, true);
    }

    public static Document readXmlDocument(URL url, boolean validate) throws SAXException, ParserConfigurationException, IOException {
        if (url == null) {
            logger.warn("[UtilXml.readXmlDocument] URL was null, doing nothing");
            return null;
        }
        InputStream is = url.openStream();
        Document document = UtilXml.readXmlDocument(is, validate, url.toString());
        is.close();
        return document;
    }

    public static Document readXmlDocument(URL url, boolean validate, boolean withPosition) throws SAXException, ParserConfigurationException, IOException {
        if (url == null) {
            logger.warn("[UtilXml.readXmlDocument] URL was null, doing nothing");
            return null;
        }
        InputStream is = url.openStream();
        Document document = UtilXml.readXmlDocument(is, validate, url.toString(), withPosition);
        is.close();
        return document;
    }

    @Deprecated
    public static Document readXmlDocument(InputStream is) throws SAXException, ParserConfigurationException, IOException {
        return UtilXml.readXmlDocument(is, true, null);
    }

    public static Document readXmlDocument(InputStream is, String docDescription) throws SAXException, ParserConfigurationException, IOException {
        return UtilXml.readXmlDocument(is, true, docDescription);
    }

    public static Document readXmlDocument(InputStream is, String docDescription, boolean withPosition) throws SAXException, ParserConfigurationException, IOException {
        return UtilXml.readXmlDocument(is, true, docDescription, withPosition);
    }

    public static Document readXmlDocument(InputStream is, boolean validate, String docDescription) throws SAXException, ParserConfigurationException, IOException {
        if (is == null) {
            logger.warn("[UtilXml.readXmlDocument] InputStream was null, doing nothing");
            return null;
        }
        long startTime = System.currentTimeMillis();
        Document document = null;
        DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
        factory.setValidating(validate);
        factory.setNamespaceAware(true);
        ((DocumentBuilderFactory)factory).setAttribute("http://xml.org/sax/features/validation", validate);
        ((DocumentBuilderFactory)factory).setAttribute("http://apache.org/xml/features/validation/schema", validate);
        DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
        if (validate) {
            LocalResolver lr = new LocalResolver(new DefaultHandler());
            LocalErrorHandler eh = new LocalErrorHandler(docDescription, lr);
            builder.setEntityResolver(lr);
            builder.setErrorHandler(eh);
        }
        document = builder.parse(is);
        double totalSeconds = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        if (logger.isDebugEnabled()) {
            logger.debug("XML Read " + totalSeconds + "s: " + docDescription);
        }
        return document;
    }

    public static Document readXmlDocument(InputStream is, boolean validate, String docDescription, boolean withPosition) throws SAXException, ParserConfigurationException, IOException {
        if (!withPosition) {
            return UtilXml.readXmlDocument(is, validate, docDescription);
        }
        if (is == null) {
            logger.warn("[UtilXml.readXmlDocument] InputStream was null, doing nothing");
            return null;
        }
        long startTime = System.currentTimeMillis();
        Document document = null;
        DOMParser parser = new DOMParser(){
            private XMLLocator locator;

            private void setLineColumn(Node node) {
                if (node.getUserData("startLine") != null) {
                    return;
                }
                node.setUserData("startLine", this.locator.getLineNumber(), null);
                node.setUserData("startColumn", this.locator.getColumnNumber(), null);
            }

            private void setLineColumn() {
                try {
                    Node node = (Node)this.getProperty("http://apache.org/xml/properties/dom/current-element-node");
                    if (node != null) {
                        this.setLineColumn(node);
                    }
                }
                catch (SAXException ex) {
                    logger.warn(ex);
                }
            }

            private void setLastChildLineColumn() {
                try {
                    Node node = (Node)this.getProperty("http://apache.org/xml/properties/dom/current-element-node");
                    if (node != null) {
                        this.setLineColumn(node.getLastChild());
                    }
                }
                catch (SAXException ex) {
                    logger.warn(ex);
                }
            }

            @Override
            public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
                super.startGeneralEntity(name, identifier, encoding, augs);
                this.setLineColumn();
            }

            @Override
            public void comment(XMLString text, Augmentations augs) throws XNIException {
                super.comment(text, augs);
                this.setLastChildLineColumn();
            }

            @Override
            public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
                super.processingInstruction(target, data, augs);
                this.setLastChildLineColumn();
            }

            @Override
            public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
                super.startDocument(locator, encoding, namespaceContext, augs);
                this.locator = locator;
                this.setLineColumn();
            }

            @Override
            public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
                super.doctypeDecl(rootElement, publicId, systemId, augs);
            }

            @Override
            public void startElement(QName elementQName, XMLAttributes attrList, Augmentations augs) throws XNIException {
                super.startElement(elementQName, attrList, augs);
                this.setLineColumn();
            }

            @Override
            public void characters(XMLString text, Augmentations augs) throws XNIException {
                super.characters(text, augs);
                this.setLastChildLineColumn();
            }

            @Override
            public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
                super.ignorableWhitespace(text, augs);
                this.setLastChildLineColumn();
            }
        };
        parser.setFeature("http://xml.org/sax/features/namespaces", true);
        parser.setFeature("http://xml.org/sax/features/validation", validate);
        parser.setFeature("http://apache.org/xml/features/validation/schema", validate);
        parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        if (validate) {
            LocalResolver lr = new LocalResolver(new DefaultHandler());
            LocalErrorHandler eh = new LocalErrorHandler(docDescription, lr);
            parser.setEntityResolver(lr);
            parser.setErrorHandler(eh);
        }
        parser.parse(new InputSource(is));
        document = parser.getDocument();
        double totalSeconds = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        if (logger.isDebugEnabled()) {
            logger.debug("XML Read " + totalSeconds + "s: " + docDescription);
        }
        return document;
    }

    public static Document makeEmptyXmlDocument() {
        return UtilXml.makeEmptyXmlDocument(null);
    }

    public static Document makeEmptyXmlDocument(String rootElementName) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }
        catch (Exception e) {
            logger.error(e);
        }
        if (document == null) {
            return null;
        }
        if (rootElementName != null) {
            Element rootElement = document.createElement(rootElementName);
            document.appendChild(rootElement);
        }
        return document;
    }

    public static Element addChildElement(Element element, String childElementName, Document document) {
        Element newElement = document.createElement(childElementName);
        element.appendChild(newElement);
        return newElement;
    }

    public static Element addChildElementValue(Element element, String childElementName, String childElementValue, Document document) {
        Element newElement = UtilXml.addChildElement(element, childElementName, document);
        newElement.appendChild(document.createTextNode(childElementValue));
        return newElement;
    }

    public static Element addChildElementNSElement(Element element, String childElementName, Document document, String nameSpaceUrl) {
        Element newElement = document.createElementNS(nameSpaceUrl, childElementName);
        element.appendChild(newElement);
        return element;
    }

    public static Element addChildElementNSValue(Element element, String childElementName, String childElementValue, Document document, String nameSpaceUrl) {
        Element newElement = document.createElementNS(nameSpaceUrl, childElementName);
        newElement.appendChild(document.createTextNode(childElementValue));
        element.appendChild(newElement);
        return element;
    }

    public static Element addChildElementCDATAValue(Element element, String childElementName, String childElementValue, Document document) {
        Element newElement = UtilXml.addChildElement(element, childElementName, document);
        newElement.appendChild(document.createCDATASection(childElementValue));
        return newElement;
    }

    public static List<? extends Element> childElementList(Element element) {
        if (element == null) {
            return null;
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        Node node = element.getFirstChild();
        if (node != null) {
            do {
                if (node.getNodeType() != 1) continue;
                Element childElement = (Element)node;
                elements.add(childElement);
            } while ((node = node.getNextSibling()) != null);
        }
        return elements;
    }

    public static List<? extends Element> childElementList(Element element, String childElementName) {
        if (element == null) {
            return null;
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        Node node = element.getFirstChild();
        if (node != null) {
            do {
                if (node.getNodeType() != 1 || childElementName != null && !childElementName.equals(node.getNodeName())) continue;
                Element childElement = (Element)node;
                elements.add(childElement);
            } while ((node = node.getNextSibling()) != null);
        }
        return elements;
    }

    public static List<? extends Element> childElementList(Element element, Set<String> childElementNames) {
        if (element == null) {
            return null;
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        if (childElementNames == null) {
            return elements;
        }
        Node node = element.getFirstChild();
        if (node != null) {
            do {
                if (node.getNodeType() != 1 || !childElementNames.contains(node.getNodeName())) continue;
                Element childElement = (Element)node;
                elements.add(childElement);
            } while ((node = node.getNextSibling()) != null);
        }
        return elements;
    }

    public static List<? extends Element> childElementList(Element element, String ... childElementNames) {
        return UtilXml.childElementList(element, UtilXml.toSetArray(childElementNames));
    }

    public static <T> Set<T> toSetArray(T[] data) {
        if (data == null) {
            return null;
        }
        HashSet<T> set = new HashSet<T>();
        for (T value : data) {
            set.add(value);
        }
        return set;
    }

    public static List<? extends Element> childElementList(DocumentFragment fragment) {
        if (fragment == null) {
            return null;
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        Node node = fragment.getFirstChild();
        if (node != null) {
            do {
                if (node.getNodeType() != 1) continue;
                Element childElement = (Element)node;
                elements.add(childElement);
            } while ((node = node.getNextSibling()) != null);
        }
        return elements;
    }

    public static List<? extends Node> childNodeList(Node node) {
        if (node == null) {
            return null;
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (node != null) {
            do {
                if (node.getNodeType() != 1 && node.getNodeType() != 8) continue;
                nodes.add(node);
            } while ((node = node.getNextSibling()) != null);
        }
        return nodes;
    }

    public static Element firstChildElement(Element element, Set<String> childElementNames) {
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        if (node != null) {
            do {
                if (node.getNodeType() != 1 || !childElementNames.contains(node.getLocalName())) continue;
                Element childElement = (Element)node;
                return childElement;
            } while ((node = node.getNextSibling()) != null);
        }
        return null;
    }

    public static Element firstChildElement(Element element, String ... childElementNames) {
        return UtilXml.firstChildElement(element, UtilXml.toSetArray(childElementNames));
    }

    public static Element firstChildElement(Element element) {
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        if (node != null) {
            do {
                if (node.getNodeType() != 1) continue;
                Element childElement = (Element)node;
                return childElement;
            } while ((node = node.getNextSibling()) != null);
        }
        return null;
    }

    public static Element firstChildElement(Element element, String childElementName) {
        if (element == null) {
            return null;
        }
        if (childElementName != null && childElementName.length() > 0) {
            return null;
        }
        Node node = element.getFirstChild();
        if (node != null) {
            do {
                if (node.getNodeType() != 1 || childElementName != null && !childElementName.equals(node.getLocalName())) continue;
                Element childElement = (Element)node;
                return childElement;
            } while ((node = node.getNextSibling()) != null);
        }
        return null;
    }

    public static Element firstChildElement(Element element, String childElementName, String attrName, String attrValue) {
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        if (node != null) {
            do {
                Element childElement;
                String value;
                if (node.getNodeType() != 1 || childElementName != null && !childElementName.equals(node.getNodeName()) || (value = (childElement = (Element)node).getAttribute(attrName)) == null || !value.equals(attrValue)) continue;
                return childElement;
            } while ((node = node.getNextSibling()) != null);
        }
        return null;
    }

    public static String childElementValue(Element element, String childElementName) {
        if (element == null) {
            return null;
        }
        Element childElement = UtilXml.firstChildElement(element, childElementName);
        return UtilXml.elementValue(childElement);
    }

    public static String childElementValue(Element element, String childElementName, String defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        Element childElement = UtilXml.firstChildElement(element, childElementName);
        String elementValue = UtilXml.elementValue(childElement);
        if (elementValue != null && elementValue.length() > 0) {
            return defaultValue;
        }
        return elementValue;
    }

    public static String elementValue(Element element) {
        if (element == null) {
            return null;
        }
        element.normalize();
        Node textNode = element.getFirstChild();
        if (textNode == null) {
            return null;
        }
        StringBuilder valueBuffer = new StringBuilder();
        do {
            if (textNode.getNodeType() != 4 && textNode.getNodeType() != 3) continue;
            valueBuffer.append(textNode.getNodeValue());
        } while ((textNode = textNode.getNextSibling()) != null);
        return valueBuffer.toString();
    }

    public static String nodeValue(Node node) {
        if (node == null) {
            return null;
        }
        StringBuilder valueBuffer = new StringBuilder();
        do {
            if (node.getNodeType() != 4 && node.getNodeType() != 3 && node.getNodeType() != 8) continue;
            valueBuffer.append(node.getNodeValue());
        } while ((node = node.getNextSibling()) != null);
        return valueBuffer.toString();
    }

    public static String elementAttribute(Element element, String attrName, String defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        String attrValue = element.getAttribute(attrName);
        return attrValue != null && attrValue.length() > 0 ? attrValue : defaultValue;
    }

    public static String checkEmpty(String string) {
        if (string != null && string.length() > 0) {
            return string;
        }
        return "";
    }

    public static String checkEmpty(String string1, String string2) {
        if (string1 != null && string1.length() > 0) {
            return string1;
        }
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return "";
    }

    public static String checkEmpty(String string1, String string2, String string3) {
        if (string1 != null && string1.length() > 0) {
            return string1;
        }
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        if (string3 != null && string3.length() > 0) {
            return string3;
        }
        return "";
    }

    public static boolean checkBoolean(String str) {
        return UtilXml.checkBoolean(str, false);
    }

    public static boolean checkBoolean(String str, boolean defaultValue) {
        if (defaultValue) {
            return !"false".equals(str);
        }
        return "true".equals(str);
    }

    public static URL fromResource(String resourceName, ClassLoader loader) {
        URL url = null;
        if (loader != null && url == null) {
            url = loader.getResource(resourceName);
        }
        if (loader != null && url == null) {
            url = loader.getResource(resourceName + ".properties");
        }
        if (loader == null && url == null) {
            try {
                loader = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException e) {
                UtilXml utilXml = new UtilXml();
                loader = utilXml.getClass().getClassLoader();
            }
        }
        if (url == null) {
            url = loader.getResource(resourceName);
        }
        if (url == null) {
            url = loader.getResource(resourceName + ".properties");
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(resourceName);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(resourceName + ".properties");
        }
        if (url == null) {
            url = UtilXml.fromFilename(resourceName);
        }
        if (url == null) {
            url = UtilXml.fromOfbizHomePath(resourceName);
        }
        if (url == null) {
            url = UtilXml.fromUrlString(resourceName);
        }
        return url;
    }

    public static URL fromFilename(String filename) {
        if (filename == null) {
            return null;
        }
        File file = new File(filename);
        URL url = null;
        try {
            if (file.exists()) {
                url = file.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            url = null;
        }
        return url;
    }

    public static URL fromOfbizHomePath(String filename) {
        String ofbizHome = System.getProperty("ofbiz.home");
        if (ofbizHome == null) {
            logger.warn("No ofbiz.home property set in environment");
            return null;
        }
        String newFilename = ofbizHome;
        if (!newFilename.endsWith("/") && !filename.startsWith("/")) {
            newFilename = newFilename + "/";
        }
        newFilename = newFilename + filename;
        return UtilXml.fromFilename(newFilename);
    }

    public static URL fromUrlString(String urlString) {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    public static String getSplitPropertyValue(URL url, String name) {
        if (url == null) {
            return "";
        }
        if (name == null || name.length() <= 0) {
            return "";
        }
        Properties properties = new Properties();
        try {
            properties.load(url.openStream());
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
        if (properties == null) {
            logger.warn("[UtilProperties.getProperties] could not find resource: " + url);
            return null;
        }
        if (properties == null) {
            return null;
        }
        String value = null;
        try {
            int curIdx = 1;
            String curName = null;
            while ((curName = properties.getProperty("name." + curIdx)) != null) {
                if (name.equals(curName)) {
                    value = properties.getProperty("value." + curIdx);
                    break;
                }
                ++curIdx;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return value == null ? "" : value.trim();
    }

    public static class LocalErrorHandler
    implements ErrorHandler {
        private String docDescription;
        private LocalResolver localResolver;

        public LocalErrorHandler(String docDescription, LocalResolver localResolver) {
            this.docDescription = docDescription;
            this.localResolver = localResolver;
        }

        @Override
        public void error(SAXParseException exception) {
            String exceptionMessage = exception.getMessage();
            Pattern valueFlexExpr = Pattern.compile("value '\\$\\{.*\\}'");
            Matcher matcher = valueFlexExpr.matcher(exceptionMessage.toLowerCase());
            if (this.localResolver.hasDTD() && !matcher.find()) {
                logger.error("XmlFileLoader: File " + this.docDescription + " process error. Line: " + String.valueOf(exception.getLineNumber()) + ". Error message: " + exceptionMessage);
            }
        }

        @Override
        public void fatalError(SAXParseException exception) {
            if (this.localResolver.hasDTD()) {
                logger.error("XmlFileLoader: File " + this.docDescription + " process fatal error. Line: " + String.valueOf(exception.getLineNumber()) + ". Error message: " + exception.getMessage());
            }
        }

        @Override
        public void warning(SAXParseException exception) {
            if (this.localResolver.hasDTD()) {
                logger.error("XmlFileLoader: File " + this.docDescription + " process warning. Line: " + String.valueOf(exception.getLineNumber()) + ". Error message: " + exception.getMessage());
            }
        }
    }

    public static class LocalResolver
    implements EntityResolver {
        private boolean hasDTD = false;
        private EntityResolver defaultResolver;

        public LocalResolver(EntityResolver defaultResolver) {
            this.defaultResolver = defaultResolver;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            this.hasDTD = false;
            String dtd = UtilXml.getSplitPropertyValue(UtilXml.fromResource("localdtds.properties", null), publicId);
            if (dtd != null && dtd.length() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("[UtilXml.LocalResolver.resolveEntity] resolving DTD with publicId [" + publicId + "], systemId [" + systemId + "] and the dtd file is [" + dtd + "]");
                }
                try {
                    URL dtdURL = UtilXml.fromResource(dtd, null);
                    if (dtdURL == null) {
                        throw new AddOnManagerException("Local DTD not found - " + dtd, new Object[0]);
                    }
                    InputStream dtdStream = dtdURL.openStream();
                    InputSource inputSource = new InputSource(dtdStream);
                    inputSource.setPublicId(publicId);
                    this.hasDTD = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug("[UtilXml.LocalResolver.resolveEntity] got LOCAL DTD input source with publicId [" + publicId + "] and the dtd file is [" + dtd + "]");
                    }
                    return inputSource;
                }
                catch (Exception e) {
                    logger.warn(e);
                }
            } else {
                int lastSlash = systemId.lastIndexOf("/");
                String filename = null;
                filename = lastSlash == -1 ? systemId : systemId.substring(lastSlash + 1);
                URL resourceUrl = UtilXml.fromResource(filename, null);
                if (resourceUrl != null) {
                    InputStream resStream = resourceUrl.openStream();
                    InputSource inputSource = new InputSource(resStream);
                    if (publicId != null && publicId.length() > 0) {
                        inputSource.setPublicId(publicId);
                    }
                    this.hasDTD = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug("[UtilXml.LocalResolver.resolveEntity] got LOCAL DTD/Schema input source with publicId [" + publicId + "] and the file/resource is [" + filename + "]");
                    }
                    return inputSource;
                }
                logger.warn("[UtilXml.LocalResolver.resolveEntity] could not find LOCAL DTD/Schema with publicId [" + publicId + "] and the file/resource is [" + filename + "]");
                return null;
            }
            return this.defaultResolver.resolveEntity(publicId, systemId);
        }

        public boolean hasDTD() {
            return this.hasDTD;
        }
    }
}

