/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.registry;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neogia.addonmanager.AddOnManager;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.Tree;
import org.neogia.addonmanager.TreeItem;
import org.neogia.addonmanager.addon.AddOn;
import org.neogia.addonmanager.addon.AddOnArchive;
import org.neogia.addonmanager.patch.Patch;
import org.neogia.addonmanager.patch.PatchService;
import org.neogia.addonmanager.registry.RegisteredAddOn;
import org.neogia.addonmanager.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Registry {
    private static final Log logger = LogFactory.getLog("addonmanager.registry");
    private static final String ADDONS_FILE = "add-ons.xml";
    public static final String BASE_TREE_ID = "base.tree";
    private AddOnManager addOnManager;
    private Tree baseTree;
    private LinkedHashMap<String, RegisteredAddOn> registeredAddOns = null;

    public Registry(AddOnManager addOnManager) {
        this.addOnManager = addOnManager;
        this.load();
    }

    public AddOnManager getAddOnManager() {
        return this.addOnManager;
    }

    public Tree getBaseTree() {
        if (this.baseTree == null) {
            this.baseTree = this.addOnManager.getRepository().readTree(BASE_TREE_ID);
        }
        return this.baseTree;
    }

    public RegisteredAddOn createAddOn(String addOnName, File addOnLocation) {
        if (addOnName == null || addOnName.length() == 0) {
            throw new AddOnManagerException("Unable to create an add-on with a null or empty name", new Object[0]);
        }
        if (this.registeredAddOns.containsKey(addOnName)) {
            throw new AddOnManagerException("Unable to create add-on '%s' due to existing add-on with the same name", addOnName);
        }
        if (addOnLocation == null) {
            addOnLocation = this.addOnManager.getRepository().getFile(addOnName);
        }
        AddOn addOn = AddOn.newAddOnFromScratch(addOnLocation, addOnName);
        return this.registerAddOn(addOn);
    }

    public void sealCurrentlyEditedAddOn(String version, String passephrase, String commitMsg, boolean httpPublish, boolean svnPublish) {
        RegisteredAddOn addOn = this.getCurrentlyEditedAddOn();
        if (addOn == null) {
            throw new AddOnManagerException("No add-on to seal", new Object[0]);
        }
        addOn.seal(version, passephrase, commitMsg, this, httpPublish, svnPublish);
        this.save();
        System.out.println("add-on '" + addOn.getArtifactId() + "' sealed to version '" + addOn.getVersion() + "'");
    }

    public RegisteredAddOn getAddOn(String addOnName) {
        return this.registeredAddOns.get(addOnName);
    }

    public RegisteredAddOn getLastAddOn() {
        RegisteredAddOn[] addOns = this.registeredAddOns.values().toArray(new RegisteredAddOn[0]);
        if (addOns.length > 0) {
            return addOns[addOns.length - 1];
        }
        return null;
    }

    public Tree getLastTree() {
        RegisteredAddOn lastAddOn = this.getLastAddOn();
        if (lastAddOn == null) {
            return this.getBaseTree();
        }
        return lastAddOn.getPostTree();
    }

    public File getCurrentFile(String path) {
        File file = this.addOnManager.getOfbizHomeRelativeFile(path);
        return file.exists() ? file : null;
    }

    public File getPreeFile(String path) {
        TreeItem item = this.getCurrentlyEditedAddOn().getPreTree().getTreeItem(path);
        if (item != null) {
            return item.getRepositoryFile();
        }
        return null;
    }

    public File getLastFile(String path) {
        TreeItem item = this.getLastTree().getTreeItem(path);
        if (item != null) {
            return item.getRepositoryFile();
        }
        return null;
    }

    public void installAddOn(File addOnLocation) {
        AddOn addOn = new AddOn(addOnLocation);
        RegisteredAddOn registeredAddOn = this.registerAddOn(addOn);
        try {
            registeredAddOn.applyPatchs();
            this.createHelpFile(addOnLocation, addOn.getArtifactId());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.unregisterAddOn(registeredAddOn);
            if (ex instanceof AddOnManagerException) {
                throw (AddOnManagerException)ex;
            }
            throw new AddOnManagerException("An unexpected exception occured while installing add-on '%s'", addOn.getArtifactId());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createHelpFile(File addOnLocation, String artifactId) {
        File addonHelpFile = null;
        String[] langs = Locale.getISOLanguages();
        if (addOnLocation.isDirectory()) {
            try {
                String line;
                boolean found = false;
                for (String lang : langs) {
                    String line2;
                    String helpFileName = "HELP_ADDON_" + artifactId + "_" + lang.toUpperCase() + ".xml";
                    addonHelpFile = new File(addOnLocation.getCanonicalPath() + "/helpdata", helpFileName);
                    if (addonHelpFile == null || !addonHelpFile.isFile()) continue;
                    found = true;
                    FileInputStream is = new FileInputStream(addonHelpFile);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    File admHelpDir = this.addOnManager.getHelpDir();
                    File helpAdmFile = new File(admHelpDir.getAbsolutePath(), helpFileName);
                    if (helpAdmFile.exists()) {
                        logger.warn("help file :" + helpAdmFile.getCanonicalPath() + " already exists");
                        continue;
                    }
                    BufferedWriter output = new BufferedWriter(new FileWriter(helpAdmFile));
                    StringBuilder content = new StringBuilder();
                    while ((line2 = reader.readLine()) != null) {
                        content.append(line2.concat("\n"));
                    }
                    output.write(content.toString());
                    ((Writer)output).close();
                }
                if (found) return;
                String helpFileName = "HELP_ADDON_" + artifactId + ".xml";
                addonHelpFile = new File(addOnLocation.getCanonicalPath() + "/helpdata", helpFileName);
                if (addonHelpFile == null || !addonHelpFile.isFile()) {
                    return;
                }
                found = true;
                FileInputStream is = new FileInputStream(addonHelpFile);
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                File admHelpDir = this.addOnManager.getHelpDir();
                File helpAdmFile = new File(admHelpDir.getAbsolutePath(), helpFileName);
                if (helpAdmFile.exists()) {
                    logger.warn("help file :" + helpAdmFile.getCanonicalPath() + " already exists");
                    return;
                }
                BufferedWriter output = new BufferedWriter(new FileWriter(helpAdmFile));
                StringBuilder content = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    content.append(line.concat("\n"));
                }
                output.write(content.toString());
                ((Writer)output).close();
                return;
            }
            catch (Exception e) {
                throw new AddOnManagerException(e.getMessage(), new Object[0]);
            }
        }
        if (!addOnLocation.isFile()) return;
        ZipFile theZip = null;
        try {
            File admHelpDir = this.addOnManager.getHelpDir();
            theZip = new ZipFile(addOnLocation);
            boolean found = false;
            for (String lang : langs) {
                String line;
                String helpFileName = "HELP_ADDON_" + artifactId + "_" + lang.toUpperCase() + ".xml";
                ZipEntry entry = theZip.getEntry("helpdata/" + helpFileName);
                if (entry == null) continue;
                InputStream is = theZip.getInputStream(entry);
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                File helpAdmFile = new File(admHelpDir.getAbsolutePath(), helpFileName);
                if (helpAdmFile.exists()) {
                    logger.warn("help file :" + helpAdmFile.getCanonicalPath() + " already exists");
                    continue;
                }
                helpAdmFile.createNewFile();
                BufferedWriter output = new BufferedWriter(new FileWriter(helpAdmFile));
                StringBuilder content = new StringBuilder("\n");
                while ((line = reader.readLine()) != null) {
                    content.append(line);
                    content.append("\n");
                }
                output.write(content.toString());
                ((Writer)output).close();
            }
            if (!found) {
                String helpFileName = "HELP_ADDON_" + artifactId + ".xml";
                ZipEntry entry = theZip.getEntry("helpdata/" + helpFileName);
                if (entry == null) {
                    return;
                }
                InputStream is = theZip.getInputStream(entry);
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                File helpAdmFile = new File(admHelpDir.getAbsolutePath(), helpFileName);
                if (helpAdmFile.exists()) {
                    logger.warn("help file :" + helpAdmFile.getCanonicalPath() + " already exists");
                } else {
                    String line;
                    helpAdmFile.createNewFile();
                    BufferedWriter output = new BufferedWriter(new FileWriter(helpAdmFile));
                    StringBuilder content = new StringBuilder("\n");
                    while ((line = reader.readLine()) != null) {
                        content.append(line);
                        content.append("\n");
                    }
                    output.write(content.toString());
                    ((Writer)output).close();
                }
            }
            theZip.close();
            return;
        }
        catch (Exception e) {
            logger.warn("Error copying the help files: " + e.toString());
        }
    }

    public void uninstallAddOns(String addOnName) {
        if (addOnName == null) {
            return;
        }
        RegisteredAddOn addOn = this.registeredAddOns.get(addOnName);
        RegisteredAddOn lastAddOn = this.getLastAddOn();
        if (addOn != null) {
            while (lastAddOn != addOn) {
                this.unregisterAddOn(lastAddOn);
                lastAddOn = this.getLastAddOn();
            }
            this.unregisterAddOn(addOn);
        }
    }

    public void uninstallAddOn(String addOnName) {
        if (addOnName == null) {
            return;
        }
        RegisteredAddOn addOn = this.registeredAddOns.get(addOnName);
        RegisteredAddOn lastAddOn = this.getLastAddOn();
        LinkedHashMap<String, RegisteredAddOn> removedAddOns = new LinkedHashMap<String, RegisteredAddOn>();
        LinkedList<String> toBeInstalled = new LinkedList<String>();
        if (addOn != null) {
            while (lastAddOn != addOn) {
                removedAddOns.put(lastAddOn.getName(), lastAddOn);
                toBeInstalled.add(0, lastAddOn.getName());
                this.unregisterAddOn(lastAddOn);
                lastAddOn = this.getLastAddOn();
            }
            this.unregisterAddOn(addOn);
            Iterator iterator = toBeInstalled.iterator();
            while (iterator.hasNext()) {
                RegisteredAddOn removedAddon = (RegisteredAddOn)removedAddOns.get(iterator.next());
                this.installAddOn(removedAddon.getLocation());
            }
        }
    }

    public void removeHelpFile(String addOnName) {
        File admHelpDir = this.addOnManager.getHelpDir();
        File helpFile = new File(admHelpDir.getAbsolutePath(), "HELP_ADDON_" + addOnName + ".xml");
        if (helpFile.exists() && !helpFile.delete()) {
            throw new AddOnManagerException("unable to delete file :'%s'", helpFile.getAbsolutePath());
        }
        File helpDir = new File(admHelpDir.getAbsolutePath());
        if (helpDir.listFiles().length == 0 && !helpDir.delete()) {
            throw new AddOnManagerException("unable to delete directory :'%s'", helpDir.getAbsolutePath());
        }
    }

    public void uninstallAllAddOns() {
        RegisteredAddOn addOn = this.getLastAddOn();
        while (addOn != null) {
            this.unregisterAddOn(addOn);
            addOn = this.getLastAddOn();
        }
    }

    public RegisteredAddOn getCurrentlyEditedAddOn() {
        RegisteredAddOn lastAddOn = this.getLastAddOn();
        if (lastAddOn != null && !lastAddOn.isSealed()) {
            return lastAddOn;
        }
        return null;
    }

    public void addFile(String path, boolean overwrite, String nb) {
        this.addFile(path, overwrite, nb, false);
    }

    public void addFile(String path, boolean overwrite, String nb, boolean acceptDom) {
        List<Patch> newRevertPatchSet;
        RegisteredAddOn currentlyEditedAddOn = this.getCurrentlyEditedAddOn();
        ArrayList<Patch> patchSet = new ArrayList<Patch>();
        ArrayList<Patch> revertPatchSet = new ArrayList<Patch>();
        if (currentlyEditedAddOn == null) {
            throw new AddOnManagerException("Unable to add file(s) without an add-on being edited", path);
        }
        AddOnArchive archive = currentlyEditedAddOn.getArchive();
        File originalFile = this.getPreeFile(path);
        File modifiedFile = this.getCurrentFile(path);
        if (!overwrite) {
            if (archive.existPatch(path)) {
                throw new AddOnManagerException("File '%s' has already been added to add-on. Use -f flag to force add", path);
            }
        } else {
            originalFile = this.getLastFile(path);
            patchSet.addAll(currentlyEditedAddOn.getPatchs(path));
            revertPatchSet.addAll(currentlyEditedAddOn.getRevertPatchs(path));
        }
        PatchService patchService = new PatchService(acceptDom);
        if (nb == "") {
            patchSet.addAll(patchService.generatePatchs(originalFile, modifiedFile));
            archive.updatePatchs(path, patchSet);
            newRevertPatchSet = patchService.generatePatchs(modifiedFile, originalFile, true);
        } else {
            patchSet.addAll(patchService.generatePatchs(originalFile, modifiedFile, nb));
            archive.updatePatchs(path, patchSet);
            newRevertPatchSet = patchService.generatePatchs(modifiedFile, originalFile, nb, true);
        }
        for (Patch patch : newRevertPatchSet) {
            revertPatchSet.add(0, patch);
        }
        currentlyEditedAddOn.updateRevertData(path, revertPatchSet);
        if (originalFile == null) {
            System.out.println("N " + path);
        } else {
            System.out.println("P " + path);
        }
        Tree postTree = currentlyEditedAddOn.getPostTree();
        postTree.addOrUpdateItem(path, true);
        this.addOnManager.getRepository().writeTree(currentlyEditedAddOn.getPostTreeId(), postTree);
    }

    public void addDirectory(String path, boolean overwrite, String nb) {
        File dir = new File(path);
        if (!dir.isDirectory()) {
            throw new AddOnManagerException("Argument passed to add-directory command is not a directory", path);
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File child = files[i];
            if (child.isFile()) {
                this.addFile(child.getAbsolutePath(), overwrite, nb);
                continue;
            }
            if (!child.isDirectory()) continue;
            this.addDirectory(child.getAbsolutePath(), overwrite, nb);
        }
    }

    public void removeFile(String path) {
        RegisteredAddOn currentlyEditedAddOn = this.getCurrentlyEditedAddOn();
        if (currentlyEditedAddOn == null) {
            throw new AddOnManagerException("Unable to remove file(s) without an add-on being edited", path);
        }
        AddOnArchive archive = currentlyEditedAddOn.getArchive();
        archive.removePatchs(path);
        currentlyEditedAddOn.updateRevertData(path, new ArrayList<Patch>(0));
        Tree preTree = currentlyEditedAddOn.getPreTree();
        TreeItem preTreeItem = preTree.getTreeItem(path);
        Tree postTree = currentlyEditedAddOn.getPostTree();
        if (preTreeItem != null) {
            postTree.addOrUpdateItem(preTreeItem);
        } else {
            postTree.removeItem(path);
        }
        this.addOnManager.getRepository().writeTree(currentlyEditedAddOn.getPostTreeId(), postTree);
        System.out.println("'" + path + "' is no more part of add-on " + currentlyEditedAddOn.getArtifactId());
    }

    private RegisteredAddOn registerAddOn(AddOn addOn) {
        if (this.registeredAddOns.containsKey(addOn.getArtifactId())) {
            throw new AddOnManagerException("Add-on '%s' already registred in addonmanager", addOn.getArtifactId());
        }
        RegisteredAddOn lastRegisteredAddOn = this.getLastAddOn();
        RegisteredAddOn registeredAddOn = new RegisteredAddOn(this, addOn);
        this.registeredAddOns.put(addOn.getArtifactId(), registeredAddOn);
        this.save();
        registeredAddOn.linkAfter(lastRegisteredAddOn);
        registeredAddOn.registered();
        System.out.println("Add-on " + addOn.getArtifactId() + " registered");
        return registeredAddOn;
    }

    private void unregisterAddOn(RegisteredAddOn registeredAddOn) {
        if (registeredAddOn != null) {
            registeredAddOn.revertPatchs();
            this.registeredAddOns.remove(registeredAddOn.getArtifactId());
            this.save();
            registeredAddOn.unlink();
            registeredAddOn.unregistered();
            this.removeHelpFile(registeredAddOn.getArtifactId());
            logger.info("Add-on " + registeredAddOn.getArtifactId() + " unregistered");
        }
    }

    void load() {
        this.registeredAddOns = new LinkedHashMap();
        File file = this.addOnManager.getRepository().getFile(ADDONS_FILE);
        if (!file.exists()) {
            return;
        }
        Document doc = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Reading file '" + file.getAbsolutePath() + "'");
            }
            doc = UtilXml.readXmlDocument(new FileInputStream(file), null);
        }
        catch (Exception ex) {
            throw new AddOnManagerException("Unable to read xml file '%s'", file.getAbsolutePath(), ex);
        }
        Element root = doc.getDocumentElement();
        RegisteredAddOn lastRegisteredAddOn = null;
        NodeList nodeList = root.getElementsByTagName("add-on");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element addOnElement = (Element)nodeList.item(index);
            File location = new File(addOnElement.getAttribute("location"));
            if (!location.isAbsolute()) {
                location = this.addOnManager.getRepository().getFile(addOnElement.getAttribute("location"));
            }
            logger.debug("Loading add-on from '" + location.getAbsolutePath() + "'");
            AddOn addOn = new AddOn(location);
            logger.debug("AddOn '" + addOn.getArtifactId() + "' loaded");
            RegisteredAddOn registeredAddOn = new RegisteredAddOn(this, addOn);
            this.registeredAddOns.put(addOn.getArtifactId(), registeredAddOn);
            registeredAddOn.linkAfter(lastRegisteredAddOn);
            lastRegisteredAddOn = registeredAddOn;
        }
    }

    public void save() {
        this.save(null);
    }

    public void save(String defaultUrl) {
        File localStore = this.addOnManager.getRepository().getFile(ADDONS_FILE).getParentFile();
        String prefix = localStore.getAbsolutePath();
        if (defaultUrl == null) {
            defaultUrl = this.getDefaultRepositoryUrl();
        }
        Document doc = UtilXml.makeEmptyXmlDocument("add-ons");
        Element root = doc.getDocumentElement();
        for (RegisteredAddOn addOn : this.registeredAddOns.values()) {
            Element addOnElement = doc.createElement("add-on");
            String addonLocation = addOn.getLocation().getAbsolutePath();
            if (addonLocation.startsWith(prefix)) {
                addonLocation = addonLocation.substring(prefix.length() + 1);
            }
            addOnElement.setAttribute("location", addonLocation);
            root.appendChild(addOnElement);
        }
        Element repositories = doc.createElement("repositories");
        root.appendChild(repositories);
        String userHome = "";
        String userName = "";
        try {
            userHome = System.getProperty("user.home");
            userName = System.getProperty("user.name");
        }
        catch (Exception e) {
            // empty catch block
        }
        Element repository = doc.createElement("repository");
        repository.setAttribute("artifactId", "default");
        repository.setAttribute("location", defaultUrl == null ? "http://addons.neogia.org/addons/" : defaultUrl);
        repository.setAttribute("type", "url");
        repositories.appendChild(repository);
        repository = doc.createElement("repository");
        repository.setAttribute("artifactId", "http");
        repository.setAttribute("location", this.getHttpRepositoryUrl() == null ? "addons.neogia.org" : this.getHttpRepositoryUrl());
        repository.setAttribute("userName", this.getHttpRepositoryUser() == null ? userName : this.getHttpRepositoryUser());
        repository.setAttribute("port", this.getHttpRepositoryPort() == null ? "22" : this.getHttpRepositoryPort());
        repository.setAttribute("dir", this.getHttpRepositoryDir() == null ? "/var/publishedAddons" : this.getHttpRepositoryDir());
        repository.setAttribute("pKPath", this.getHttpRepositoryPKPath() == null ? userHome.concat("/.ssh/id_rsa") : this.getHttpRepositoryPKPath());
        repository.setAttribute("type", "url");
        repositories.appendChild(repository);
        repository = doc.createElement("repository");
        repository.setAttribute("artifactId", "svn");
        repository.setAttribute("location", this.getSvnRepositoryUrl() == null ? "svn+ssh://labs.libre-entreprise.org/svnroot/ofbizaddons" : this.getSvnRepositoryUrl());
        repository.setAttribute("userName", this.getSvnRepositoryUser() == null ? userName : this.getSvnRepositoryUser());
        repository.setAttribute("port", this.getSvnRepositoryPort() == null ? "22" : this.getSvnRepositoryPort());
        repository.setAttribute("pKPath", this.getSvnRepositoryPKPath() == null ? userHome.concat("/.ssh/id_rsa") : this.getSvnRepositoryPKPath());
        repository.setAttribute("type", "url");
        repositories.appendChild(repository);
        File file = this.addOnManager.getRepository().getFile(ADDONS_FILE);
        FileOutputStream out = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Writing file '" + file.getAbsolutePath() + "'");
            }
            out = new FileOutputStream(file, false);
            UtilXml.writeXmlDocument(out, (Node)doc);
        }
        catch (Exception ex) {
            throw new AddOnManagerException("Unable to write xml file '%s'", file.getAbsolutePath(), ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ignoredException) {}
            }
        }
    }

    public String getHttpRepositoryUrl() {
        File file = this.addOnManager.getRepository().getFile(ADDONS_FILE);
        if (!file.exists()) {
            return null;
        }
        Document doc = null;
        try {
            doc = UtilXml.readXmlDocument(new FileInputStream(file), null);
        }
        catch (Exception ex) {
            throw new AddOnManagerException("Unable to read xml file '%s'", file.getAbsolutePath(), ex);
        }
        Element root = doc.getDocumentElement();
        NodeList list = root.getElementsByTagName("repositories");
        Element repositories = (Element)list.item(0);
        if (repositories == null) {
            return null;
        }
        NodeList nodeList = repositories.getElementsByTagName("repository");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element repository = (Element)nodeList.item(index);
            if (!"http".equals(repository.getAttribute("artifactId")) || !"url".equals(repository.getAttribute("type"))) continue;
            return repository.getAttribute("location");
        }
        return null;
    }

    public String getHttpRepositoryPort() {
        File file = this.addOnManager.getRepository().getFile(ADDONS_FILE);
        if (!file.exists()) {
            return null;
        }
        Document doc = null;
        try {
            doc = UtilXml.readXmlDocument(new FileInputStream(file), null);
        }
        catch (Exception ex) {
            throw new AddOnManagerException("Unable to read xml file '%s'", file.getAbsolutePath(), ex);
        }
        Element root = doc.getDocumentElement();
        NodeList list = root.getElementsByTagName("repositories");
        Element repositories = (Element)list.item(0);
        if (repositories == null) {
            return null;
        }
        NodeList nodeList = repositories.getElementsByTagName("repository");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element repository = (Element)nodeList.item(index);
            if (!"http".equals(repository.getAttribute("artifactId")) || !"url".equals(repository.getAttribute("type"))) continue;
            return repository.getAttribute("port");
        }
        return null;
    }

    public String getHttpRepositoryUser() {
        File file = this.addOnManager.getRepository().getFile(ADDONS_FILE);
        if (!file.exists()) {
            return null;
        }
        Document doc = null;
        try {
            doc = UtilXml.readXmlDocument(new FileInputStream(file), null);
        }
        catch (Exception ex) {
            throw new AddOnManagerException("Unable to read xml file '%s'", file.getAbsolutePath(), ex);
        }
        Element root = doc.getDocumentElement();
        NodeList list = root.getElementsByTagName("repositories");
        Element repositories = (Element)list.item(0);
        if (repositories == null) {
            return null;
        }
        NodeList nodeList = repositories.getElementsByTagName("repository");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element repository = (Element)nodeList.item(index);
            if (!"http".equals(repository.getAttribute("artifactId")) || !"url".equals(repository.getAttribute("type"))) continue;
            return repository.getAttribute("userName");
        }
        return null;
    }

    public String getHttpRepositoryDir() {
        File file = this.addOnManager.getRepository().getFile(ADDONS_FILE);
        if (!file.exists()) {
            return null;
        }
        Document doc = null;
        try {
            doc = UtilXml.readXmlDocument(new FileInputStream(file), null);
        }
        catch (Exception ex) {
            throw new AddOnManagerException("Unable to read xml file '%s'", file.getAbsolutePath(), ex);
        }
        Element root = doc.getDocumentElement();
        NodeList list = root.getElementsByTagName("repositories");
        Element repositories = (Element)list.item(0);
        if (repositories == null) {
            return null;
        }
        NodeList nodeList = repositories.getElementsByTagName("repository");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element repository = (Element)nodeList.item(index);
            if (!"http".equals(repository.getAttribute("artifactId")) || !"url".equals(repository.getAttribute("type"))) continue;
            return repository.getAttribute("dir");
        }
        return null;
    }

    public String getHttpRepositoryPKPath() {
        File file = this.addOnManager.getRepository().getFile(ADDONS_FILE);
        if (!file.exists()) {
            return null;
        }
        Document doc = null;
        try {
            doc = UtilXml.readXmlDocument(new FileInputStream(file), null);
        }
        catch (Exception ex) {
            throw new AddOnManagerException("Unable to read xml file '%s'", file.getAbsolutePath(), ex);
        }
        Element root = doc.getDocumentElement();
        NodeList list = root.getElementsByTagName("repositories");
        if (list.getLength() == 0) {
            return null;
        }
        Element repositories = (Element)list.item(0);
        if (repositories == null) {
            return null;
        }
        NodeList nodeList = repositories.getElementsByTagName("repository");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element repository = (Element)nodeList.item(index);
            if (!"http".equals(repository.getAttribute("artifactId")) || !"url".equals(repository.getAttribute("type"))) continue;
            return repository.getAttribute("pKPath");
        }
        return null;
    }

    public String getAddonFile() {
        return ADDONS_FILE;
    }

    public File getIvyFile(File addonLocation) {
        File ivy = null;
        if (!addonLocation.exists()) {
            return null;
        }
        try {
            if (addonLocation.isDirectory()) {
                ivy = new File(addonLocation.getPath(), "ivy.xml");
                if (ivy.exists()) {
                    return ivy;
                }
            } else if (addonLocation.isFile()) {
                String line;
                ZipFile addonJar = new ZipFile(addonLocation);
                ZipEntry ivyfile = addonJar.getEntry("ivy.xml");
                if (ivyfile == null) {
                    return null;
                }
                InputStream is = addonJar.getInputStream(ivyfile);
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                File tmpFile = File.createTempFile("ivy", ".xml");
                BufferedWriter output = new BufferedWriter(new FileWriter(tmpFile));
                StringBuilder content = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    content.append(line + "\n");
                }
                output.write(content.toString());
                ((Writer)output).flush();
                addonJar.close();
                return tmpFile;
            }
        }
        catch (IOException ex) {
            return null;
        }
        return null;
    }

    public String getSvnRepositoryUrl() {
        File file = this.addOnManager.getRepository().getFile(ADDONS_FILE);
        if (!file.exists()) {
            return null;
        }
        Document doc = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Reading file '" + file.getAbsolutePath() + "'");
            }
            doc = UtilXml.readXmlDocument(new FileInputStream(file), null);
        }
        catch (Exception ex) {
            return null;
        }
        Element root = doc.getDocumentElement();
        NodeList list = root.getElementsByTagName("repositories");
        if (list.getLength() == 0) {
            return null;
        }
        Element repositories = (Element)list.item(0);
        if (repositories == null) {
            return null;
        }
        NodeList nodeList = repositories.getElementsByTagName("repository");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element repository = (Element)nodeList.item(index);
            if (!"svn".equals(repository.getAttribute("artifactId")) || !"url".equals(repository.getAttribute("type"))) continue;
            return repository.getAttribute("location");
        }
        return null;
    }

    public String getSvnRepositoryPort() {
        File file = this.addOnManager.getRepository().getFile(ADDONS_FILE);
        if (!file.exists()) {
            return null;
        }
        Document doc = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Reading file '" + file.getAbsolutePath() + "'");
            }
            doc = UtilXml.readXmlDocument(new FileInputStream(file), null);
        }
        catch (Exception ex) {
            return null;
        }
        Element root = doc.getDocumentElement();
        NodeList list = root.getElementsByTagName("repositories");
        if (list.getLength() == 0) {
            return null;
        }
        Element repositories = (Element)list.item(0);
        if (repositories == null) {
            return null;
        }
        NodeList nodeList = repositories.getElementsByTagName("repository");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element repository = (Element)nodeList.item(index);
            if (!"svn".equals(repository.getAttribute("artifactId")) || !"url".equals(repository.getAttribute("type"))) continue;
            return repository.getAttribute("port");
        }
        return null;
    }

    public String getSvnRepositoryUser() {
        File file = this.addOnManager.getRepository().getFile(ADDONS_FILE);
        if (!file.exists()) {
            return null;
        }
        Document doc = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Reading file '" + file.getAbsolutePath() + "'");
            }
            doc = UtilXml.readXmlDocument(new FileInputStream(file), null);
        }
        catch (Exception ex) {
            return null;
        }
        Element root = doc.getDocumentElement();
        NodeList list = root.getElementsByTagName("repositories");
        if (list.getLength() == 0) {
            return null;
        }
        Element repositories = (Element)list.item(0);
        if (repositories == null) {
            return null;
        }
        NodeList nodeList = repositories.getElementsByTagName("repository");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element repository = (Element)nodeList.item(index);
            if (!"svn".equals(repository.getAttribute("artifactId")) || !"url".equals(repository.getAttribute("type"))) continue;
            return repository.getAttribute("userName");
        }
        return null;
    }

    public String getSvnRepositoryPKPath() {
        File file = this.addOnManager.getRepository().getFile(ADDONS_FILE);
        if (!file.exists()) {
            return null;
        }
        Document doc = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Reading file '" + file.getAbsolutePath() + "'");
            }
            doc = UtilXml.readXmlDocument(new FileInputStream(file), null);
        }
        catch (Exception ex) {
            return null;
        }
        Element root = doc.getDocumentElement();
        NodeList list = root.getElementsByTagName("repositories");
        if (list.getLength() == 0) {
            return null;
        }
        Element repositories = (Element)list.item(0);
        if (repositories == null) {
            return null;
        }
        NodeList nodeList = repositories.getElementsByTagName("repository");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element repository = (Element)nodeList.item(index);
            if (!"svn".equals(repository.getAttribute("artifactId")) || !"url".equals(repository.getAttribute("type"))) continue;
            return repository.getAttribute("pKPath");
        }
        return null;
    }

    public void SetRepositoryParameters(String repositoryType, String host, String userName, String pKPath, String dir, String port) {
        if (repositoryType == null || "".equals(repositoryType)) {
            throw new AddOnManagerException("Repository type can not be empty", new Object[0]);
        }
        File oldFile = this.addOnManager.getRepository().getFile(ADDONS_FILE);
        Document oldDoc = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Reading file '" + oldFile.getAbsolutePath() + "'");
            }
            oldDoc = UtilXml.readXmlDocument(new FileInputStream(oldFile), null);
        }
        catch (Exception ex) {
            throw new AddOnManagerException(ex.toString(), new Object[0]);
        }
        Element root = oldDoc.getDocumentElement();
        NodeList list = root.getElementsByTagName("repositories");
        Element repositories = null;
        boolean found = false;
        if (list.getLength() > 0) {
            repositories = (Element)list.item(0);
            if (repositories != null) {
                NodeList nodeList = repositories.getElementsByTagName("repository");
                for (int index = 0; index < nodeList.getLength(); ++index) {
                    Element repository = (Element)nodeList.item(index);
                    if (!repositoryType.equals(repository.getAttribute("artifactId"))) continue;
                    found = true;
                    repository.setAttribute("location", host);
                    repository.setAttribute("userName", userName);
                    repository.setAttribute("port", port);
                    repository.setAttribute("pKPath", pKPath);
                    if (dir == null) continue;
                    repository.setAttribute("dir", dir);
                }
            }
        } else {
            repositories = oldDoc.createElement("repositories");
        }
        if (!found) {
            Element newRepository = oldDoc.createElement("repository");
            newRepository.setAttribute("artifactId", repositoryType);
            newRepository.setAttribute("location", host);
            newRepository.setAttribute("userName", userName);
            newRepository.setAttribute("port", port);
            newRepository.setAttribute("pKPath", pKPath);
            newRepository.setAttribute("type", "url");
            if (dir != null) {
                newRepository.setAttribute("dir", dir);
            }
            repositories.appendChild(newRepository);
        }
        File newFile = this.addOnManager.getRepository().getFile(ADDONS_FILE);
        FileOutputStream out = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Writing file '" + newFile.getAbsolutePath() + "'");
            }
            out = new FileOutputStream(newFile, false);
            UtilXml.writeXmlDocument(out, (Node)oldDoc);
        }
        catch (Exception ex) {
            throw new AddOnManagerException("Unable to write xml file '%s'", newFile.getAbsolutePath(), ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ignoredException) {}
            }
        }
    }

    public String getDefaultRepositoryUrl() {
        File file = this.addOnManager.getRepository().getFile(ADDONS_FILE);
        if (!file.exists()) {
            return null;
        }
        Document doc = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Reading file '" + file.getAbsolutePath() + "'");
            }
            doc = UtilXml.readXmlDocument(new FileInputStream(file), null);
        }
        catch (Exception ex) {
            return null;
        }
        Element root = doc.getDocumentElement();
        NodeList list = root.getElementsByTagName("repositories");
        if (list.getLength() == 0) {
            return null;
        }
        Element repositories = (Element)list.item(0);
        if (repositories == null) {
            return null;
        }
        NodeList nodeList = repositories.getElementsByTagName("repository");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element repository = (Element)nodeList.item(index);
            if (!"default".equals(repository.getAttribute("artifactId")) || !"url".equals(repository.getAttribute("type"))) continue;
            return repository.getAttribute("location");
        }
        return null;
    }

    public String getDefaultRepositoryUser() {
        File file = this.addOnManager.getRepository().getFile(ADDONS_FILE);
        if (!file.exists()) {
            return null;
        }
        Document doc = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Reading file '" + file.getAbsolutePath() + "'");
            }
            doc = UtilXml.readXmlDocument(new FileInputStream(file), null);
        }
        catch (Exception ex) {
            return null;
        }
        Element root = doc.getDocumentElement();
        NodeList list = root.getElementsByTagName("repositories");
        if (list.getLength() == 0) {
            return null;
        }
        Element repositories = (Element)list.item(0);
        if (repositories == null) {
            return null;
        }
        NodeList nodeList = repositories.getElementsByTagName("repository");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element repository = (Element)nodeList.item(index);
            if (!"default".equals(repository.getAttribute("artifactId")) || !"url".equals(repository.getAttribute("type"))) continue;
            return repository.getAttribute("userName");
        }
        return null;
    }

    public String getDefaultRepositoryPKPath() {
        File file = this.addOnManager.getRepository().getFile(ADDONS_FILE);
        if (!file.exists()) {
            return null;
        }
        Document doc = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Reading file '" + file.getAbsolutePath() + "'");
            }
            doc = UtilXml.readXmlDocument(new FileInputStream(file), null);
        }
        catch (Exception ex) {
            return null;
        }
        Element root = doc.getDocumentElement();
        NodeList list = root.getElementsByTagName("repositories");
        if (list.getLength() == 0) {
            return null;
        }
        Element repositories = (Element)list.item(0);
        if (repositories == null) {
            return null;
        }
        NodeList nodeList = repositories.getElementsByTagName("repository");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element repository = (Element)nodeList.item(index);
            if (!"default".equals(repository.getAttribute("artifactId")) || !"url".equals(repository.getAttribute("type"))) continue;
            return repository.getAttribute("pKPath");
        }
        return null;
    }

    public void updateAddonIvyFile(AddOn addon, String version) {
        File ivyFile = new File(addon.getLocation(), "ivy.xml");
        Document doc = null;
        Element root = null;
        if (!ivyFile.exists()) {
            doc = UtilXml.makeEmptyXmlDocument("ivy-module");
            root = doc.getDocumentElement();
            root.setAttribute("version", "2.0");
            Element info = doc.createElement("info");
            info.setAttribute("organisation", "org.neogia");
            info.setAttribute("module", addon.getArtifactId());
            info.setAttribute("revision", version);
            root.appendChild(info);
            root.appendChild(doc.createElement("dependencies"));
            try {
                UtilXml.writeXmlDocument(new FileOutputStream(ivyFile), (Node)doc);
            }
            catch (Exception ex) {
                logger.error("Error writing the ivy.xml file for the addon " + addon.getArtifactId() + " at location: " + ivyFile.getAbsolutePath());
                ex.printStackTrace();
                return;
            }
        }
        try {
            doc = UtilXml.readXmlDocument(new FileInputStream(ivyFile), null);
            root = doc.getDocumentElement();
            NodeList listInfo = root.getElementsByTagName("info");
            Element oldInfo = (Element)listInfo.item(0);
            oldInfo.setAttribute("revision", version);
            try {
                UtilXml.writeXmlDocument(new FileOutputStream(ivyFile), (Node)doc);
            }
            catch (Exception ex) {
                logger.error("Error writing the ivy.xml file for the addon " + addon.getArtifactId() + " at location: " + ivyFile.getAbsolutePath());
                ex.printStackTrace();
                return;
            }
        }
        catch (Exception ex) {
            logger.error("Error reading the existing ivy.xml file for the addon " + addon.getArtifactId() + " location: " + ivyFile.getAbsolutePath());
            ex.printStackTrace();
            return;
        }
    }

    public List<String> detectFileRelatedAddons(String path) {
        ArrayList<String> addonList = new ArrayList<String>();
        for (RegisteredAddOn addon = this.getLastAddOn(); addon != null; addon = addon.getPreviousAddOn()) {
            List<Patch> patches = addon.getPatchs(path);
            if (patches == null || patches.size() == 0) continue;
            addonList.add(0, addon.getArtifactId());
        }
        return addonList;
    }
}

