/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neogia.addonmanager.AddOnManager;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.Repository;
import org.neogia.addonmanager.Tree;
import org.neogia.addonmanager.TreeItem;
import org.neogia.addonmanager.addon.AddOn;
import org.neogia.addonmanager.addon.AddOnArchive;
import org.neogia.addonmanager.addon.AddOnInterface;
import org.neogia.addonmanager.addon.DirectoryAddOnArchive;
import org.neogia.addonmanager.patch.Patch;
import org.neogia.addonmanager.patch.PatchAnalyser;
import org.neogia.addonmanager.patch.PatchException;
import org.neogia.addonmanager.patch.PatchService;
import org.neogia.addonmanager.patch.PlainOldPatch;
import org.neogia.addonmanager.patch.PlainOldPatchFactory;
import org.neogia.addonmanager.registry.Registry;
import org.neogia.addonmanager.util.io.ToByteArrayStreamConsumer;

public class RegisteredAddOn
implements AddOnInterface {
    private static final Log logger = LogFactory.getLog("addonmanager.registeredAddon");
    private static final String POST_TREE_ID_SUFFIX = "-post.tree";
    private static final String REVERT_DATA_DIR = ".revert";
    private static final String DOM_TREE_ID_SUFFIX = "-dom.tree";
    private Registry registry;
    private AddOn addOn;
    private RegisteredAddOn nextAddOn;
    private RegisteredAddOn previousAddOn;
    private Tree postTree;
    private AddOnArchive revertArchive;

    public RegisteredAddOn(Registry registry, AddOn addOn) {
        this.registry = registry;
        this.addOn = addOn;
    }

    void linkAfter(RegisteredAddOn previousAddOn) {
        this.previousAddOn = previousAddOn;
        this.nextAddOn = this.previousAddOn != null ? this.previousAddOn.nextAddOn : null;
        if (this.nextAddOn != null) {
            this.nextAddOn.previousAddOn = this;
        }
        if (this.previousAddOn != null) {
            this.previousAddOn.nextAddOn = this;
        }
    }

    void unlink() {
        if (this.previousAddOn != null) {
            this.previousAddOn.nextAddOn = this.nextAddOn;
        }
        if (this.nextAddOn != null) {
            this.nextAddOn.previousAddOn = this.previousAddOn;
        }
        this.nextAddOn = null;
        this.previousAddOn = null;
    }

    public String getPostTreeId() {
        return this.getArtifactId() + POST_TREE_ID_SUFFIX;
    }

    public String getDomTreeId() {
        return this.getArtifactId() + DOM_TREE_ID_SUFFIX;
    }

    public Tree getPostTree() {
        if (this.postTree == null) {
            this.postTree = this.registry.getAddOnManager().getRepository().readTree(this.getPostTreeId());
        }
        return this.postTree;
    }

    public Tree getPreTree() {
        if (this.previousAddOn == null) {
            return this.registry.getBaseTree();
        }
        return this.previousAddOn.getPostTree();
    }

    private File getRevertDir() {
        return this.registry.getAddOnManager().getRepository().getFile(".revert/" + this.getArtifactId());
    }

    void registered() {
        this.registry.getAddOnManager().getRepository().writeTree(this.getPostTreeId(), this.getPreTree());
        this.getRevertDir().mkdirs();
    }

    void unregistered() {
        this.registry.getAddOnManager().deleteFile(this.getRevertDir());
        this.registry.getAddOnManager().getRepository().deleteTree(this.getPostTreeId());
        this.registry.getAddOnManager().getRepository().deleteTree(this.getDomTreeId());
    }

    void updateRevertData(Map<String, List<Patch>> revertData) {
        for (String path : revertData.keySet()) {
            this.updateRevertData(path, revertData.get(path));
        }
    }

    void updateRevertData(String path, List<Patch> revertPatchs, boolean keepLastPatch) {
        if (this.revertArchive == null) {
            this.revertArchive = new DirectoryAddOnArchive(this.getRevertDir());
        }
        this.revertArchive.updatePatchs(path, revertPatchs, keepLastPatch);
    }

    void updateRevertData(String path, List<Patch> revertPatchs) {
        this.updateRevertData(path, revertPatchs, false);
    }

    public File copy(File file) {
        try {
            File result = File.createTempFile(file.getName(), "");
            FileInputStream in = new FileInputStream(file);
            FileOutputStream out = new FileOutputStream(result, false);
            byte[] buffer = new byte[4096];
            int read = 0;
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
            out.close();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AddOnManagerException(e.toString(), new Object[0]);
        }
    }

    public List<Patch> generateRelativePatch(Tree baseTree, String path) {
        PatchService patchService = new PatchService();
        File resultingPatch = null;
        ArrayList<File> files = new ArrayList<File>();
        TreeItem baseItem = baseTree.getTreeItem(path);
        String pathBaseHash = "";
        if (baseItem != null) {
            pathBaseHash = baseItem.getHash();
        }
        String pathCurrentHash = Repository.computeHash(this.registry.getCurrentFile(path));
        File base = baseTree.getTreeItem(path) == null ? null : baseTree.getTreeItem(path).getRepositoryFile();
        File last = this.registry.getCurrentFile(path);
        if (base == null || last == null) {
            return null;
        }
        if (pathBaseHash.equals(pathCurrentHash)) {
            return null;
        }
        List<Patch> resultingPatchset = null;
        File baseCopy = this.copy(base);
        List<Patch> patchSet = null;
        try {
            patchSet = patchService.generatePatchs(base, last);
            for (Patch patch : patchSet) {
                if ("pop".equals(patch.getPatchTypeId())) continue;
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        List<Patch> newPatchset = this.addOn.getPatchs(path);
        for (Patch patch : newPatchset) {
            if ("pop".equals(patch.getPatchTypeId())) continue;
            return null;
        }
        if (patchSet == null || newPatchset == null || patchSet.size() < 1 || newPatchset.size() < 1) {
            return null;
        }
        patchSet.addAll(newPatchset);
        int i = 0;
        try {
            for (Patch patch : patchSet) {
                InputStream in = patch.getPatchStream();
                File file = File.createTempFile("patch" + i, ".patc");
                FileOutputStream out = new FileOutputStream(file, false);
                byte[] buffer = new byte[4096];
                int read = 0;
                while ((read = in.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                out.close();
                ++i;
                files.add(0, file);
            }
            resultingPatch = PatchAnalyser.merg(files);
            ToByteArrayStreamConsumer consumer = new ToByteArrayStreamConsumer(new FileInputStream(resultingPatch));
            consumer.run();
            if (consumer.getException() != null) {
                throw new PatchException("An unexpected exception occured during reading patch data", new Object[]{consumer.getException()});
            }
            PlainOldPatch patch1 = new PlainOldPatch(new PlainOldPatchFactory(), consumer.getByteArray());
            patch1.apply(path, baseCopy);
            resultingPatchset = patchService.generatePatchs(last, baseCopy);
        }
        catch (Exception e) {
            if (AddOnManager.logger.isDebugEnabled()) {
                AddOnManager.logger.debug("failure when merging patchs for " + path);
            }
            return null;
        }
        return resultingPatchset;
    }

    public Tree getPreviousTreeRelatedToFile(RegisteredAddOn addon, String path) {
        for (RegisteredAddOn previous = addon.getPreviousAddOn(); previous != null; previous = previous.getPreviousAddOn()) {
            Tree tree = previous.getPostTree();
            if (tree.getTreeItem(path) == null) continue;
            return tree;
        }
        return null;
    }

    void applyPatchs() {
        Tree postTree = this.getPostTree();
        block4: for (String path : this.getPathsToPatch()) {
            boolean itsOk;
            List<Patch> patchSet;
            block13: {
                patchSet = null;
                itsOk = true;
                boolean containsDom = false;
                try {
                    patchSet = this.addOn.getPatchs(path);
                    for (Patch p : patchSet) {
                        if (!p.getClass().getSimpleName().equals("DomPatch")) continue;
                        containsDom = true;
                    }
                    if (containsDom) {
                        this.applySinglePatch(path, patchSet, true);
                    } else {
                        this.applySinglePatch(path, patchSet);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    itsOk = false;
                    if (!logger.isDebugEnabled()) break block13;
                    logger.debug("file : " + path + "  can't be patched, trying patch merge if other addon modify the same file");
                }
            }
            if (itsOk) continue;
            List<String> relatedAddon = this.registry.detectFileRelatedAddons(path);
            if (relatedAddon.size() <= 1) {
                throw new PatchException("Patch failed for File:" + path, new Object[0]);
            }
            int baseAddonIndex = relatedAddon.size() - 2;
            boolean success = false;
            while (!success) {
                success = true;
                RegisteredAddOn previousAddon = this.registry.getAddOn(relatedAddon.get(baseAddonIndex)).getPreviousAddOn();
                Tree baseTree = null;
                baseTree = previousAddon != null ? previousAddon.getPostTree() : this.registry.getBaseTree();
                patchSet = this.generateRelativePatch(baseTree, path);
                if (patchSet != null && patchSet.size() > 0) {
                    try {
                        this.applySinglePatch(path, patchSet);
                    }
                    catch (PatchException ex) {
                        success = false;
                    }
                    if (success) {
                        continue block4;
                    }
                } else {
                    success = false;
                }
                if (--baseAddonIndex >= 0) continue;
                throw new PatchException("File: " + path + " cannot be patched even after merging patches", new Object[0]);
            }
        }
        this.registry.getAddOnManager().getRepository().writeTree(this.getPostTreeId(), postTree);
    }

    void applySinglePatch(String path, List<Patch> patchSet, boolean keepLastPatch) {
        ArrayList<Patch> revertPatchs = new ArrayList<Patch>();
        for (Patch patch : patchSet) {
            revertPatchs.addAll(0, patch.apply(path, this.registry.getAddOnManager().getOfbizHomeRelativeFile(path)));
        }
        this.updateRevertData(path, revertPatchs, keepLastPatch);
        this.postTree.addOrUpdateItem(path, true);
    }

    void applySinglePatch(String path, List<Patch> patchSet) {
        this.applySinglePatch(path, patchSet, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void revertPatchs() {
        Tree postTree = this.getPostTree();
        LinkedList<String> revertedPatchToBeUpdated = new LinkedList<String>();
        HashMap toBeReverted = new HashMap();
        if (this.revertArchive == null) {
            this.revertArchive = new DirectoryAddOnArchive(this.getRevertDir());
        }
        try {
            for (String path : this.revertArchive.getPathsWithPatch()) {
                File currentFile = this.registry.getCurrentFile(path);
                TreeItem postTreeItem = postTree.getTreeItem(path);
                if (currentFile == null) {
                    if (postTreeItem != null) {
                        throw new IllegalStateException("file has been deleted since it has been patched");
                    }
                } else if (currentFile.isFile()) {
                    if (postTreeItem == null) {
                        throw new IllegalStateException("file has been deleted by a patch but is always present");
                    }
                    String currentHash = Repository.computeHash(currentFile);
                    if (!currentHash.equals(postTreeItem.getHash())) {
                        throw new IllegalStateException("The Uninstall fails due to modified file : " + path);
                    }
                } else if (currentFile.isDirectory()) {
                    throw new IllegalStateException();
                }
                List<Patch> revertPatchs = this.revertArchive.getPatchs(path);
                LinkedList<Patch> revertPatchsForPath = new LinkedList<Patch>();
                try {
                    while (!revertPatchs.isEmpty()) {
                        Patch patch = revertPatchs.get(0);
                        revertPatchsForPath.addAll(patch.apply(path, this.registry.getAddOnManager().getOfbizHomeRelativeFile(path)));
                        revertPatchs.remove(0);
                        postTree.addOrUpdateItem(path, true);
                    }
                }
                finally {
                    revertedPatchToBeUpdated.add(path);
                    toBeReverted.put(path, revertPatchsForPath);
                }
            }
            for (String path : revertedPatchToBeUpdated) {
                this.updateRevertData(path, new ArrayList<Patch>(0));
            }
            this.registry.getAddOnManager().getRepository().writeTree(this.getPostTreeId(), postTree);
        }
        catch (Exception e) {
            for (String aPath : toBeReverted.keySet()) {
                LinkedList toBeInstalled = (LinkedList)toBeReverted.get(aPath);
                LinkedList<Patch> toRestore = new LinkedList<Patch>();
                while (!toBeInstalled.isEmpty()) {
                    Patch patch = (Patch)toBeInstalled.get(0);
                    toRestore.addAll(patch.apply(aPath, this.registry.getAddOnManager().getOfbizHomeRelativeFile(aPath)));
                    toBeInstalled.remove(0);
                }
                postTree.addOrUpdateItem(aPath, true);
            }
            e.printStackTrace();
            throw new AddOnManagerException(e.toString(), new Object[0]);
        }
    }

    @Override
    public AddOnArchive getArchive() {
        return this.addOn.getArchive();
    }

    @Override
    public Set<String> getPathsToPatch() {
        return this.addOn.getPathsToPatch();
    }

    @Override
    public File getLocation() {
        return this.addOn.getLocation();
    }

    @Override
    public String getArtifactId() {
        return this.addOn.getArtifactId();
    }

    @Override
    public String getName() {
        return this.addOn.getName();
    }

    @Override
    public String getDescription() {
        return this.addOn.getDescription();
    }

    @Override
    public List<Patch> getPatchs(String path) {
        return this.addOn.getPatchs(path);
    }

    public List<Patch> getRevertPatchs(String path) {
        DirectoryAddOnArchive archive = new DirectoryAddOnArchive(this.getRevertDir());
        return archive.getPatchs(path);
    }

    @Override
    public String getVersion() {
        return this.addOn.getVersion();
    }

    @Override
    public boolean isSealed() {
        return this.addOn.isSealed();
    }

    @Override
    public File seal(String finalVersion, String passphrase, String commitMsg, Registry registry, boolean httpPublish, boolean svnPublish) {
        return this.addOn.seal(finalVersion, passphrase, commitMsg, registry, httpPublish, svnPublish);
    }

    public RegisteredAddOn getPreviousAddOn() {
        return this.previousAddOn;
    }
}

