/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.patch;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.patch.Patch;
import org.neogia.addonmanager.patch.PatchException;
import org.neogia.addonmanager.patch.PatchFactory;
import org.neogia.addonmanager.patch.PlainOldPatch;
import org.neogia.addonmanager.util.io.ToByteArrayStreamConsumer;

public class PlainOldPatchFactory
implements PatchFactory {
    public static final Log logger = LogFactory.getLog("addonmanager.patch");

    @Override
    public Set<String> getSupportedPatchTypeId() {
        LinkedHashSet<String> supportedPatchTypeIds = new LinkedHashSet<String>();
        supportedPatchTypeIds.add("pop");
        return supportedPatchTypeIds;
    }

    @Override
    public boolean isFileTypeSupported(File file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] buffer = new byte[4096];
            int read = ((InputStream)in).read(buffer);
            for (int i = 0; i < read; ++i) {
                if (buffer[i] != 0) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public List<Patch> generatePatches(File oldFile, File newFile) {
        ProcessBuilder processBuilder = new ProcessBuilder("diff", "-U6", oldFile.getAbsolutePath(), newFile.getAbsolutePath());
        processBuilder.environment().put("LC_ALL", "C");
        Process diffProcess = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting diff process ...");
            }
            diffProcess = processBuilder.start();
        }
        catch (IOException ex) {
            throw new AddOnManagerException("Unable to launch GNU diff process : %s", ex.getMessage(), ex);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Reading diff process output ...");
        }
        ToByteArrayStreamConsumer stdErrConsumer = new ToByteArrayStreamConsumer(diffProcess.getErrorStream());
        Thread stdErrConsumerThread = new Thread(stdErrConsumer);
        stdErrConsumerThread.start();
        ToByteArrayStreamConsumer stdOutConsumer = new ToByteArrayStreamConsumer(diffProcess.getInputStream());
        stdOutConsumer.run();
        if (logger.isDebugEnabled()) {
            logger.debug("Reading diff process exit code ...");
        }
        int diffResult = 2;
        try {
            diffResult = diffProcess.waitFor();
        }
        catch (InterruptedException e) {
            diffProcess.destroy();
        }
        try {
            stdErrConsumerThread.join();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (stdOutConsumer.getException() != null) {
            throw new PatchException("An unexpected exception occured during reading of diff stdout", new Object[]{stdOutConsumer.getException()});
        }
        if (stdErrConsumer.getException() != null) {
            throw new PatchException("An unexpected exception occured during reading of diff stderr", new Object[]{stdErrConsumer.getException()});
        }
        ArrayList<Patch> patchList = new ArrayList<Patch>();
        switch (diffResult) {
            case 0: {
                break;
            }
            case 1: {
                try {
                    String diffOutput = new String(stdOutConsumer.getByteArray(), "ISO-8859-1");
                    int offset = diffOutput.indexOf("@@");
                    if (offset < 0) {
                        throw new IllegalStateException("Diff output not recognized");
                    }
                    patchList.add(new PlainOldPatch(this, diffOutput.substring(offset).getBytes("ISO-8859-1")));
                }
                catch (UnsupportedEncodingException ignoredException) {}
                break;
            }
            default: {
                throw new PatchException("Diff program returned an error code '%d', stdout='%s', stderr='%s'", diffResult, new String(stdOutConsumer.getByteArray()), new String(stdErrConsumer.getByteArray()));
            }
        }
        return patchList;
    }

    @Override
    public List<Patch> generatePatches(File oldFile, File newFile, String nb) {
        ProcessBuilder processBuilder = new ProcessBuilder("diff", "-U" + nb, oldFile.getAbsolutePath(), newFile.getAbsolutePath());
        processBuilder.environment().put("LC_ALL", "C");
        Process diffProcess = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting diff process ...");
            }
            diffProcess = processBuilder.start();
        }
        catch (IOException ex) {
            throw new AddOnManagerException("Unable to launch GNU diff process : %s", ex.getMessage(), ex);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Reading diff process output ...");
        }
        ToByteArrayStreamConsumer stdErrConsumer = new ToByteArrayStreamConsumer(diffProcess.getErrorStream());
        Thread stdErrConsumerThread = new Thread(stdErrConsumer);
        stdErrConsumerThread.start();
        ToByteArrayStreamConsumer stdOutConsumer = new ToByteArrayStreamConsumer(diffProcess.getInputStream());
        stdOutConsumer.run();
        if (logger.isDebugEnabled()) {
            logger.debug("Reading diff process exit code ...");
        }
        int diffResult = 2;
        try {
            diffResult = diffProcess.waitFor();
        }
        catch (InterruptedException e) {
            diffProcess.destroy();
        }
        try {
            stdErrConsumerThread.join();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (stdOutConsumer.getException() != null) {
            throw new PatchException("An unexpected exception occured during reading of diff stdout", new Object[]{stdOutConsumer.getException()});
        }
        if (stdErrConsumer.getException() != null) {
            throw new PatchException("An unexpected exception occured during reading of diff stderr", new Object[]{stdErrConsumer.getException()});
        }
        ArrayList<Patch> patchList = new ArrayList<Patch>();
        switch (diffResult) {
            case 0: {
                break;
            }
            case 1: {
                try {
                    String diffOutput = new String(stdOutConsumer.getByteArray(), "ISO-8859-1");
                    int offset = diffOutput.indexOf("@@");
                    if (offset < 0) {
                        throw new IllegalStateException("Diff output not recognized");
                    }
                    patchList.add(new PlainOldPatch(this, diffOutput.substring(offset).getBytes("ISO-8859-1")));
                }
                catch (UnsupportedEncodingException ignoredException) {}
                break;
            }
            default: {
                throw new PatchException("Diff program returned an error code '%d', stdout='%s', stderr='%s'", diffResult, new String(stdOutConsumer.getByteArray()), new String(stdErrConsumer.getByteArray()));
            }
        }
        return patchList;
    }

    @Override
    public Patch parsePatch(String patchTypeId, InputStream in) {
        ToByteArrayStreamConsumer consumer = new ToByteArrayStreamConsumer(in);
        consumer.run();
        if (consumer.getException() != null) {
            throw new PatchException("An unexpected exception occured during reading patch data", new Object[]{consumer.getException()});
        }
        return new PlainOldPatch(this, consumer.getByteArray());
    }

    @Override
    public List<Patch> generatePatches(File oldFile, File newFile, boolean isRevert) {
        return this.generatePatches(oldFile, newFile);
    }

    @Override
    public List<Patch> generatePatches(File oldFile, File newFile, String nb, boolean isRevert) {
        return this.generatePatches(oldFile, newFile, nb);
    }
}

