/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.patch;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neogia.addonmanager.patch.AbstractPatch;
import org.neogia.addonmanager.patch.Patch;
import org.neogia.addonmanager.patch.PatchException;
import org.neogia.addonmanager.patch.PlainOldPatchFactory;

public class PlainOldPatch
extends AbstractPatch {
    public static final Log logger = LogFactory.getLog("addonmanager.patch");
    public static final String PATCH_TYPE_ID = "pop";
    private byte[] data;

    public PlainOldPatch(PlainOldPatchFactory factory, byte[] data) {
        super(factory);
        this.data = data;
    }

    public byte[] getInternalRepresentation() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public List<Patch> apply(String path, File fileToPatch) {
        File tmpFileToPatch = null;
        File tmpPatchFile = null;
        FileOutputStream patchStream = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Duplicating file to patch '" + fileToPatch.getAbsolutePath() + "' ...");
            }
            tmpFileToPatch = PlainOldPatch.duplicateFile(fileToPatch);
            tmpPatchFile = File.createTempFile("patch", null);
            if (logger.isDebugEnabled()) {
                logger.debug("Creating patch file '" + tmpPatchFile.getAbsolutePath());
            }
            patchStream = new FileOutputStream(tmpPatchFile, false);
            Formatter header = new Formatter();
            header.format("Index: %s%n", tmpFileToPatch.getName());
            header.format("--- %s%n", tmpFileToPatch.getName());
            header.format("+++ %s%n", tmpFileToPatch.getName());
            patchStream.write(header.toString().getBytes());
            patchStream.write(this.data);
            patchStream.close();
            Process patchProcess = null;
            try {
                ProcessBuilder patchProcessBuilder = new ProcessBuilder("patch", "-f", "--posix", tmpFileToPatch.getName(), tmpPatchFile.getAbsolutePath());
                patchProcessBuilder.directory(tmpFileToPatch.getParentFile());
                patchProcessBuilder.redirectErrorStream(true);
                patchProcessBuilder.environment().put("LC_ALL", "C");
                if (logger.isDebugEnabled()) {
                    logger.debug("Starting patch process '" + patchProcessBuilder.toString() + "' ...");
                }
                patchProcess = patchProcessBuilder.start();
            }
            catch (Exception ex) {
                throw new PatchException("Unable to launch GNU patch program : %s", ex.getMessage(), ex);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Reading patch process output ...");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(patchProcess.getInputStream()));
            StringBuilder patchProcessOutput = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                patchProcessOutput.append(line);
            }
            reader.close();
            logger.debug(patchProcessOutput.toString());
            if (logger.isDebugEnabled()) {
                logger.debug("Reading patch process exit code ...");
            }
            int patchExitCode = 2;
            try {
                patchExitCode = patchProcess.waitFor();
            }
            catch (InterruptedException ex) {
                patchProcess.destroy();
            }
            switch (patchExitCode) {
                case 0: {
                    List<Patch> revertPatchs = this.factory.generatePatches(tmpFileToPatch, fileToPatch);
                    PlainOldPatch.copyFile(tmpFileToPatch, fileToPatch);
                    if (fileToPatch.getCanonicalPath().contains(System.getProperty("ofbiz.home"))) {
                        System.out.println("[P] " + path);
                    }
                    List<Patch> list = revertPatchs;
                    return list;
                }
            }
            try {
                throw new PatchException("Patch failed for File: " + path, new Object[0]);
            }
            catch (IOException ex) {
                throw new PatchException("An unexpected exception occured during patch for file: " + path + "  message was %s", ex.getMessage(), ex);
            }
        }
        finally {
            try {
                patchStream.close();
            }
            catch (Exception ignoredException) {}
            try {
                tmpFileToPatch.delete();
            }
            catch (Exception ignoredException) {}
            try {
                tmpPatchFile.delete();
            }
            catch (Exception ignoredException) {}
        }
    }

    public String toString() {
        return new String(this.data);
    }

    @Override
    public String getPatchTypeId() {
        return PATCH_TYPE_ID;
    }

    @Override
    public InputStream getPatchStream() {
        return new ByteArrayInputStream(this.data);
    }
}

