/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.patch;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.patch.BinaryPatchFactory;
import org.neogia.addonmanager.patch.CreateFilePatch;
import org.neogia.addonmanager.patch.DeleteFilePatch;
import org.neogia.addonmanager.patch.DomPatchFactory;
import org.neogia.addonmanager.patch.Patch;
import org.neogia.addonmanager.patch.PatchFactory;
import org.neogia.addonmanager.patch.PlainOldPatchFactory;

public class PatchService {
    private LinkedHashMap<String, PatchFactory> factories = new LinkedHashMap();

    public PatchService() {
        this(false);
    }

    public PatchService(boolean acceptDom) {
        if (acceptDom) {
            this.registerSubPatchFactory(new DomPatchFactory());
        }
        this.registerSubPatchFactory(new PlainOldPatchFactory());
        this.registerSubPatchFactory(new BinaryPatchFactory());
    }

    protected void registerSubPatchFactory(PatchFactory factory) {
        for (String patchTypeId : factory.getSupportedPatchTypeId()) {
            if (this.factories.containsKey(patchTypeId)) continue;
            this.factories.put(patchTypeId, factory);
        }
    }

    public List<Patch> generatePatchs(File oldFile, File newFile) {
        return this.generatePatchs(oldFile, newFile, false);
    }

    public List<Patch> generatePatchs(File oldFile, File newFile, boolean isRevert) {
        ArrayList<Patch> patchSet = null;
        if (newFile != null) {
            if (oldFile != null) {
                for (PatchFactory subFactory : this.factories.values()) {
                    if (!subFactory.isFileTypeSupported(newFile)) continue;
                    return subFactory.generatePatches(oldFile, newFile, isRevert);
                }
                throw new AddOnManagerException("Unsupported file type for file '%s'", newFile.getAbsolutePath());
            }
            patchSet = new ArrayList<Patch>(1);
            patchSet.add(new CreateFilePatch(null, newFile));
        } else if (oldFile != null) {
            patchSet = new ArrayList(1);
            patchSet.add(new DeleteFilePatch(null));
        } else {
            throw new IllegalStateException("oldFile and newFile are null");
        }
        return patchSet;
    }

    public List<Patch> generatePatchs(File oldFile, File newFile, String nb) {
        return this.generatePatchs(oldFile, newFile, nb, false);
    }

    public List<Patch> generatePatchs(File oldFile, File newFile, String nb, boolean isRevert) {
        ArrayList<Patch> patchSet = null;
        if (newFile != null) {
            if (oldFile != null) {
                for (PatchFactory subFactory : this.factories.values()) {
                    if (!subFactory.isFileTypeSupported(newFile)) continue;
                    return subFactory.generatePatches(oldFile, newFile, nb, isRevert);
                }
                throw new AddOnManagerException("Unsupported file type for file '%s'", newFile.getAbsolutePath());
            }
            patchSet = new ArrayList<Patch>(1);
            patchSet.add(new CreateFilePatch(null, newFile));
        } else if (oldFile != null) {
            patchSet = new ArrayList(1);
            patchSet.add(new DeleteFilePatch(null));
        } else {
            throw new IllegalStateException("oldFile and newFile are null");
        }
        return patchSet;
    }

    public Patch parsePatch(String patchTypeId, InputStream in) {
        Patch patch = null;
        if ("cfp".equals(patchTypeId)) {
            patch = new CreateFilePatch(null, in);
        } else if ("dfp".equals(patchTypeId)) {
            patch = new DeleteFilePatch(null);
        } else {
            PatchFactory subFactory = this.factories.get(patchTypeId);
            if (subFactory != null) {
                patch = subFactory.parsePatch(patchTypeId, in);
            } else {
                throw new AddOnManagerException("Unsupported patch type '%s'", patchTypeId);
            }
        }
        return patch;
    }
}

