/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.patch;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PatchAnalyser {
    public static File merg(List<File> files) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (File f : files) {
            Document fdoc = PatchAnalyser.parseFile(f);
            Element fRoot = fdoc.getDocumentElement();
            NodeList els = fRoot.getElementsByTagName("hunk");
            for (int index = 0; index < els.getLength(); ++index) {
                elements.add((Element)els.item(index));
            }
        }
        List<Element> es = PatchAnalyser.AscSort(elements);
        return PatchAnalyser.writeFile(es);
    }

    public static File writeFile(List<Element> elements) {
        File tmp = null;
        try {
            tmp = File.createTempFile("testing1", ".patch");
            BufferedWriter output = new BufferedWriter(new FileWriter(tmp));
            StringBuilder sb = new StringBuilder();
            for (Element el : elements) {
                sb.append(el.getAttribute("header"));
                sb.append(el.getAttribute("text"));
            }
            output.write(sb.toString());
            ((Writer)output).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AddOnManagerException(e.toString(), new Object[0]);
        }
        return tmp;
    }

    public static List<Element> AscSort(List<Element> source) {
        ArrayList<Object> tmp = new ArrayList();
        ArrayList<Element> dest = new ArrayList<Element>();
        for (Element el : source) {
            boolean inserted = false;
            if (dest.size() == 0) {
                dest.add(el);
                continue;
            }
            tmp = dest;
            dest = new ArrayList();
            for (Element element : tmp) {
                if (Integer.parseInt(element.getAttribute("position")) < Integer.parseInt(el.getAttribute("position"))) {
                    dest.add(element);
                    continue;
                }
                if (inserted) {
                    dest.add(element);
                    continue;
                }
                dest.add(el);
                dest.add(element);
                inserted = true;
            }
            if (inserted) continue;
            dest.add(el);
        }
        return dest;
    }

    public static Document parseFile(File file) {
        if (!file.exists()) {
            return null;
        }
        boolean processing = false;
        Document doc = UtilXml.makeEmptyXmlDocument("FHunks");
        Element root = doc.getDocumentElement();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String line = null;
            Element element = doc.createElement("hunk");
            String text = "";
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("@@") && line.endsWith("@@")) {
                    if (processing) {
                        element.setAttribute("text", text.concat("\n"));
                    }
                    text = "";
                    element = doc.createElement("hunk");
                    element.setAttribute("header", line);
                    String position = line.substring(line.indexOf("-") + 1, line.indexOf("+") - 1);
                    if (position.contains(",")) {
                        position = position.substring(0, position.indexOf(","));
                    }
                    element.setAttribute("position", position);
                    root.appendChild(element);
                    processing = true;
                    continue;
                }
                if (!processing) continue;
                text = text.concat("\n").concat(line);
            }
            if (processing) {
                element.setAttribute("text", text.concat("\n"));
            }
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AddOnManagerException(e.toString(), new Object[0]);
        }
    }
}

