/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.patch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.patch.DomPatch;
import org.neogia.addonmanager.patch.Patch;
import org.neogia.addonmanager.patch.PatchException;
import org.neogia.addonmanager.patch.PatchFactory;
import org.neogia.addonmanager.patch.PlainOldPatch;
import org.neogia.addonmanager.patch.PlainOldPatchFactory;
import org.neogia.addonmanager.util.io.ToByteArrayStreamConsumer;
import org.neogia.addonmanager.xml.dom.AttributeNode;
import org.neogia.addonmanager.xml.dom.SpaceNode;
import org.neogia.addonmanager.xml.dom.parser.XMLParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomPatchFactory
implements PatchFactory {
    public static final Log logger = LogFactory.getLog("addonmanager.patch");
    private Map<String, String> idMap = DomPatchFactory.loadMapId();
    private String patch = "";
    private String writeBuffer = "";

    @Override
    public Set<String> getSupportedPatchTypeId() {
        LinkedHashSet<String> supportedPatchTypeIds = new LinkedHashSet<String>();
        supportedPatchTypeIds.add("dop");
        return supportedPatchTypeIds;
    }

    @Override
    public boolean isFileTypeSupported(File file) {
        Scanner scanner = null;
        try {
            scanner = new Scanner(file);
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        return scanner.hasNextLine() && scanner.nextLine().matches("^<\\?xml(.+)$");
    }

    @Override
    public List<Patch> generatePatches(File oldFile, File newFile) {
        return this.generatePatches(oldFile, newFile, false);
    }

    @Override
    public List<Patch> generatePatches(File oldFile, File newFile, boolean isRevert) {
        Document newDoc;
        Document oldDoc;
        ArrayList<Patch> patches = new ArrayList();
        try {
            XMLParser p = new XMLParser(new FileReader(oldFile));
            oldDoc = p.parse();
            p = new XMLParser(new FileReader(newFile));
            newDoc = p.parse();
        }
        catch (Exception ex) {
            PlainOldPatchFactory popf = new PlainOldPatchFactory();
            patches = popf.generatePatches(oldFile, newFile);
            return patches;
        }
        this.patch = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<patch>\n";
        NodeList oldNodeList = oldDoc.getDocumentElement().getChildNodes();
        NodeList newNodeList = newDoc.getDocumentElement().getChildNodes();
        this.diffNodeList(oldNodeList, newNodeList, "/");
        this.patch = this.patch.concat("</patch>");
        PlainOldPatchFactory popf = new PlainOldPatchFactory();
        List<Patch> popList = popf.generatePatches(oldFile, newFile);
        ArrayList<PlainOldPatch> editedPopList = new ArrayList<PlainOldPatch>();
        for (Patch pop : popList) {
            editedPopList.add(this.editPop((PlainOldPatch)pop, this.patch));
        }
        DomPatch dop = new DomPatch(this, this.patch.getBytes());
        if (isRevert) {
            return popList;
        }
        if (editedPopList.size() != 1 || editedPopList.get(0) != null) {
            patches.addAll(editedPopList);
        }
        patches.add(dop);
        return patches;
    }

    @Override
    public List<Patch> generatePatches(File oldFile, File newFile, String nb, boolean isRevert) {
        return this.generatePatches(oldFile, newFile, isRevert);
    }

    @Override
    public List<Patch> generatePatches(File oldFile, File newFile, String nb) {
        return this.generatePatches(oldFile, newFile, nb, false);
    }

    @Override
    public Patch parsePatch(String patchTypeId, InputStream in) {
        ToByteArrayStreamConsumer consumer = new ToByteArrayStreamConsumer(in);
        consumer.run();
        if (consumer.getException() != null) {
            throw new PatchException("An unexpected exception occured during reading patch data", new Object[]{consumer.getException()});
        }
        return new DomPatch(this, consumer.getByteArray());
    }

    private void diffNodeList(NodeList oldNodeList, NodeList newNodeList, String originalPath) {
        HashMap<String, String> elementMap;
        int i;
        ArrayList newElementList = new ArrayList();
        int nbNewNodes = newNodeList.getLength();
        int nbOldNodes = oldNodeList.getLength();
        String path = originalPath;
        String previousPath = originalPath;
        for (i = 0; i < nbNewNodes; ++i) {
            Node newNode = newNodeList.item(i);
            if (newNode.getNodeType() != 1 || !DomPatchFactory.isId(newNode, this.idMap)) continue;
            String idNew = DomPatchFactory.getId(newNode, this.idMap);
            elementMap = new HashMap<String, String>();
            elementMap.put(newNode.getNodeName(), idNew);
            newElementList.add(elementMap);
            previousPath = path;
            path = originalPath + newNode.getNodeName() + "[" + idNew + "]" + "/";
            Boolean exist = false;
            for (int j = 0; j < nbOldNodes; ++j) {
                String idOld;
                Node oldNode = oldNodeList.item(j);
                if (oldNode.getNodeType() != 1 || (idOld = DomPatchFactory.getId(oldNode, this.idMap)) == null || !oldNode.getNodeName().equals(newNode.getNodeName()) || !idOld.equals(idNew)) continue;
                if (!oldNode.isEqualNode(newNode)) {
                    NamedNodeMap oldAttrList = oldNode.getAttributes();
                    NamedNodeMap newAttrList = newNode.getAttributes();
                    this.diffAttrList(oldAttrList, newAttrList, path, newNode.getNodeName());
                    this.diffNodeList(oldNode.getChildNodes(), newNode.getChildNodes(), path);
                }
                exist = true;
                break;
            }
            if (exist.booleanValue()) continue;
            this.write("<x:add path=\"" + originalPath + "\" previous=\"" + previousPath + "\">");
            this.addTextOrComment(newNode.getPreviousSibling(), true);
            this.write(newNode.toString());
            this.addTextOrComment(newNode.getNextSibling(), false);
            this.clearBuffer();
            this.write("</x:add>\n");
        }
        for (i = 0; i < nbOldNodes; ++i) {
            Node oldNode = oldNodeList.item(i);
            if (oldNode.getNodeType() != 1 || !DomPatchFactory.isId(oldNode, this.idMap)) continue;
            String idOld = DomPatchFactory.getId(oldNode, this.idMap);
            elementMap = new HashMap();
            elementMap.put(oldNode.getNodeName(), idOld);
            path = originalPath + oldNode.getNodeName() + "[" + idOld + "]" + "/";
            if (newElementList.contains(elementMap)) continue;
            this.write("<x:delete path=\"" + path + "\" />\n");
        }
    }

    private void diffAttrList(NamedNodeMap oldList, NamedNodeMap newList, String path, String elementName) {
        int i;
        int nbNewAttr = newList.getLength();
        int nbOldAttr = oldList.getLength();
        ArrayList<String> newAttrList = new ArrayList<String>();
        for (i = 0; i < nbNewAttr; ++i) {
            Node newAttr = newList.item(i);
            Boolean exist = false;
            String nameNewAttr = newAttr.getNodeName();
            String valueNewAttr = newAttr.getNodeValue();
            newAttrList.add(nameNewAttr);
            if (DomPatchFactory.checkAttrId(elementName, nameNewAttr, this.idMap)) continue;
            for (int j = 0; j < nbOldAttr; ++j) {
                Node oldAttr = oldList.item(j);
                String nameOldAttr = oldAttr.getNodeName();
                String valueOldAttr = oldAttr.getNodeValue();
                if (!nameOldAttr.equals(nameNewAttr)) continue;
                if (!valueOldAttr.equals(valueNewAttr)) {
                    this.write("<x:delete path=\"" + path + "@" + nameOldAttr + "\" />\n");
                    if (newAttr instanceof AttributeNode) {
                        AttributeNode attr = (AttributeNode)newAttr;
                        SpaceNode spaceNode = attr.getSpaceNode();
                        String space = spaceNode.getData();
                        String spaceCode = this.getSpaceCode(space);
                        this.write("<x:add path=\"" + path + "@" + nameNewAttr + "#" + i + "!" + spaceCode + "\" value=\"" + valueNewAttr + "\" />\n");
                    } else {
                        this.write("<x:add path=\"" + path + "@" + nameNewAttr + "#" + i + "\" value=\"" + valueNewAttr + "\" />\n");
                    }
                }
                exist = true;
                break;
            }
            if (exist.booleanValue()) continue;
            if (newAttr instanceof AttributeNode) {
                AttributeNode attr = (AttributeNode)newAttr;
                SpaceNode spaceNode = attr.getSpaceNode();
                String space = spaceNode.getData();
                String spaceCode = this.getSpaceCode(space);
                this.write("<x:add path=\"" + path + "@" + nameNewAttr + "#" + i + "!" + spaceCode + "\" value=\"" + valueNewAttr + "\" />\n");
                continue;
            }
            this.write("<x:add path=\"" + path + "@" + nameNewAttr + "#" + i + "\" value=\"" + valueNewAttr + "\" />\n");
        }
        for (i = 0; i < nbOldAttr; ++i) {
            Node oldAttr = oldList.item(i);
            String nameOldAttr = oldAttr.getNodeName();
            if (newAttrList.contains(nameOldAttr)) continue;
            this.write("<x:delete path=\"" + path + "/@" + nameOldAttr + "\" />\n");
        }
    }

    @Deprecated
    private PlainOldPatch editPop(PlainOldPatch pop, String dop) {
        BufferedReader reader = new BufferedReader(new StringReader(pop.toString()));
        String newPop = "";
        try {
            String str;
            String buffer = "";
            String oldCurrentElement = "";
            String newCurrentElement = "";
            int oldBegin = 0;
            int oldLength = 0;
            int newBegin = 0;
            int newLength = 0;
            int interval = 0;
            int oldInterval = 0;
            Boolean dopInARow = false;
            Boolean blockEdited = false;
            while ((str = reader.readLine()) != null) {
                String[] elementTab;
                String[] tmp;
                if (str.length() > 0 && str.getBytes()[0] == 64) {
                    if (buffer != "" && blockEdited.booleanValue()) {
                        newPop = newPop.concat("@@ -" + oldBegin + "," + oldLength + " +" + (newBegin -= oldInterval) + "," + (newLength -= interval) + " @@\n");
                        newPop = newPop.concat(buffer);
                        oldInterval += interval;
                    }
                    String[] tab = str.split(" ");
                    String begin = tab[1].replaceFirst("-", "");
                    String end = tab[2].replaceFirst("\\+", "");
                    String[] beginTab = begin.split(",");
                    String[] endTab = end.split(",");
                    oldBegin = Integer.valueOf(beginTab[0]);
                    oldLength = Integer.valueOf(beginTab[1]);
                    newBegin = Integer.valueOf(endTab[0]);
                    newLength = Integer.valueOf(endTab[1]);
                    blockEdited = false;
                    buffer = "";
                    interval = 0;
                    continue;
                }
                if (str.length() > 0 && str.getBytes()[0] == 32 || str.getBytes()[0] == 92) {
                    dopInARow = false;
                    if (str.matches(">")) {
                        oldCurrentElement = "";
                        newCurrentElement = "";
                    } else if (str.matches("<")) {
                        tmp = str.split("</?");
                        elementTab = tmp[1].split("[\\s|>]");
                        oldCurrentElement = elementTab[0];
                        newCurrentElement = elementTab[0];
                    }
                    buffer = buffer.concat(str + "\n");
                    continue;
                }
                if (str.length() > 0 && str.getBytes()[0] == 45) {
                    dopInARow = false;
                    tmp = str.split("</?");
                    if (tmp.length > 1) {
                        elementTab = tmp[1].split("[\\s|>]");
                        oldCurrentElement = elementTab[0];
                        if (DomPatchFactory.isId(oldCurrentElement, this.idMap)) {
                            buffer = buffer.concat(" ".concat(str.substring(1) + "\n"));
                            --interval;
                        } else {
                            buffer = buffer.concat(str + "\n");
                            blockEdited = true;
                        }
                    }
                    if (str.matches(">")) {
                        oldCurrentElement = "";
                    }
                    if (tmp.length > 1) continue;
                    if (DomPatchFactory.isId(oldCurrentElement, this.idMap)) {
                        buffer = buffer.concat(" ".concat(str.substring(1) + "\n"));
                        --interval;
                        continue;
                    }
                    buffer = buffer.concat(str + "\n");
                    blockEdited = true;
                    continue;
                }
                if (str.length() <= 0 || str.getBytes()[0] != 43) continue;
                tmp = str.split("</?");
                if (tmp.length > 1) {
                    elementTab = tmp[1].split("[\\s|>]");
                    newCurrentElement = elementTab[0];
                    if (!DomPatchFactory.isId(newCurrentElement, this.idMap)) {
                        BufferedReader readerDop = new BufferedReader(new StringReader(dop));
                        String line = "";
                        Boolean exist = false;
                        while ((line = readerDop.readLine()) != null) {
                            if (!line.startsWith(str.substring(1))) continue;
                            exist = true;
                            break;
                        }
                        if (!exist.booleanValue()) {
                            dopInARow = false;
                            buffer = buffer.concat(str + "\n");
                            blockEdited = true;
                        } else {
                            dopInARow = true;
                            ++interval;
                        }
                    } else {
                        ++interval;
                    }
                }
                if (str.matches(">")) {
                    newCurrentElement = "";
                }
                if (tmp.length > 1) continue;
                if (!DomPatchFactory.isId(newCurrentElement, this.idMap)) {
                    if (dopInARow.booleanValue()) {
                        BufferedReader readerDop = new BufferedReader(new StringReader(dop));
                        String line = "";
                        Boolean exist = false;
                        while ((line = readerDop.readLine()) != null) {
                            if (!line.startsWith(str.substring(1))) continue;
                            exist = true;
                            break;
                        }
                        if (!exist.booleanValue()) {
                            buffer = buffer.concat(str + "\n");
                            blockEdited = true;
                            dopInARow = false;
                            continue;
                        }
                        dopInARow = true;
                        ++interval;
                        continue;
                    }
                    buffer = buffer.concat(str + "\n");
                    blockEdited = true;
                    continue;
                }
                ++interval;
            }
            reader.close();
            if (blockEdited.booleanValue()) {
                newPop = newPop.concat("@@ -" + oldBegin + "," + oldLength + " +" + (newBegin -= oldInterval) + "," + (newLength -= interval) + " @@\n");
                newPop = newPop.concat(buffer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new AddOnManagerException("Unable to edit pop file", new Object[0]);
        }
        reader = new BufferedReader(new StringReader(newPop));
        String line = "";
        Boolean isEdited = false;
        try {
            while ((line = reader.readLine()) != null) {
                if (line.getBytes()[0] != 43 && line.getBytes()[0] != 45) continue;
                isEdited = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new AddOnManagerException("Unable to edit pop file", new Object[0]);
        }
        PlainOldPatch nPop = null;
        if (isEdited.booleanValue()) {
            PlainOldPatchFactory popf = new PlainOldPatchFactory();
            nPop = new PlainOldPatch(popf, newPop.getBytes());
        }
        return nPop;
    }

    private void addTextOrComment(Node previous, boolean before) {
        if (previous == null) {
            return;
        }
        if (previous.getNodeType() == 3 || previous.getNodeType() == 8) {
            if (before) {
                this.addTextOrComment(previous.getPreviousSibling(), before);
            }
        } else {
            return;
        }
        if (previous.getNodeType() == 8) {
            String value = previous.getNodeValue();
            if (before && !value.startsWith("#Bam#") || !before && !value.startsWith("#Eam#")) {
                return;
            }
            this.write(previous.toString());
        } else {
            this.write(previous.getNodeValue(), true);
        }
        if (!before) {
            this.addTextOrComment(previous.getNextSibling(), before);
        }
    }

    private void write(String content, boolean inBuffer) {
        if (inBuffer) {
            this.writeBuffer = this.writeBuffer.concat(content);
        } else {
            if (!this.writeBuffer.isEmpty()) {
                this.patch = this.patch.concat(this.writeBuffer);
                this.clearBuffer();
            }
            this.patch = this.patch.concat(content);
        }
    }

    private void write(String content) {
        this.write(content, false);
    }

    private void clearBuffer() {
        this.writeBuffer = "";
    }

    private String getSpaceCode(String space) {
        String code = "";
        byte[] bytes = space.getBytes();
        int length = space.length();
        byte previous = 0;
        int nb = 0;
        for (int i = 0; i < length; ++i) {
            byte b = bytes[i];
            if (previous == b || nb == 0) {
                ++nb;
                previous = b;
                continue;
            }
            code = code.concat(String.valueOf(nb));
            if (previous == 10) {
                code = code.concat("R");
            } else if (previous == 32) {
                code = code.concat("S");
            }
            nb = 1;
            previous = b;
        }
        code = code.concat(String.valueOf(nb));
        if (previous == 10) {
            code = code.concat("R");
        } else if (previous == 32) {
            code = code.concat("S");
        }
        return code;
    }

    public static String getId(Node node, Map<String, String> idMap) {
        String id = "";
        if (node.getNodeType() != 1) {
            return null;
        }
        String idValueList = idMap.get(node.getNodeName());
        if (idValueList == null) {
            return null;
        }
        String[] idValueTable = idValueList.split("\\|");
        int i = 0;
        for (String value : idValueTable) {
            ++i;
            if (node.getAttributes().getNamedItem(value) != null) {
                id = id.concat(node.getAttributes().getNamedItem(value).getNodeValue());
            }
            if (i == idValueTable.length) continue;
            id = id.concat("|");
        }
        return id;
    }

    public static boolean isId(Node node, Map<String, String> idMap) {
        if (node.getNodeType() != 1) {
            return false;
        }
        return idMap.containsKey(node.getNodeName());
    }

    public static boolean isId(String elementName, Map<String, String> idMap) {
        return idMap.containsKey(elementName);
    }

    public static boolean checkAttrId(String element, String attr, Map<String, String> idMap) {
        String[] idValueTable;
        String idValueList = idMap.get(element);
        if (element == null) {
            return false;
        }
        for (String value : idValueTable = idValueList.split("\\|")) {
            if (value != attr) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> loadMapId() {
        HashMap<String, String> idMap = new HashMap<String, String>();
        idMap.put("service", "name");
        idMap.put("attribute", "name");
        idMap.put("implements", "service");
        idMap.put("override", "name");
        idMap.put("permission-service", "service-name");
        idMap.put("check-permission", "permission");
        idMap.put("exclude", "field-name");
        idMap.put("resource-loader", "name");
        idMap.put("classpath", "location");
        idMap.put("entity-resource", "location");
        idMap.put("service-resource", "location");
        idMap.put("test-suite", "location");
        idMap.put("webapp", "name");
        idMap.put("property", "key");
        idMap.put("value", "xml:lang");
        idMap.put("entity", "entity-name");
        idMap.put("view-entity", "entity-name");
        idMap.put("member-entity", "entity-alias");
        idMap.put("alias", "entity-alias|name");
        idMap.put("view-link", "entity-alias|rel-entity-alias");
        idMap.put("field", "name|use-when");
        idMap.put("prim-key", "field");
        idMap.put("relation", "fk-name|rel-entity-name");
        idMap.put("key-map", "field-name");
        idMap.put("index", "name");
        idMap.put("index-field", "name");
        idMap.put("simple-method", "method-name");
        idMap.put("include", "location");
        idMap.put("handler", "name");
        idMap.put("request-map", "uri");
        idMap.put("response", "name");
        idMap.put("event", "invoke");
        idMap.put("view-map", "name");
        idMap.put("screen", "name");
        idMap.put("form", "name");
        idMap.put("classpathentry", "path");
        idMap.put("menu", "name");
        idMap.put("menu-item", "name");
        idMap.put("link", "target");
        return idMap;
    }
}

