/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.patch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.patch.AbstractPatch;
import org.neogia.addonmanager.patch.DomPatchFactory;
import org.neogia.addonmanager.patch.Patch;
import org.neogia.addonmanager.patch.PatchFactory;
import org.neogia.addonmanager.patch.PlainOldPatchFactory;
import org.neogia.addonmanager.xml.dom.AttributeNode;
import org.neogia.addonmanager.xml.dom.NamedNodeMap;
import org.neogia.addonmanager.xml.dom.SpaceNode;
import org.neogia.addonmanager.xml.dom.parser.XMLParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomPatch
extends AbstractPatch {
    public static final Log logger = LogFactory.getLog("addonmanager.patch");
    public static final String PATCH_TYPE_ID = "dop";
    private byte[] data;
    private Map<String, String> idMap = DomPatchFactory.loadMapId();

    public DomPatch(PatchFactory patchFactory, byte[] data) {
        super(patchFactory);
        this.data = data;
    }

    @Override
    public List<Patch> apply(String path, File file) {
        ByteArrayInputStream in = new ByteArrayInputStream(this.data);
        Document patch = null;
        Document fileToPatch = null;
        try {
            XMLParser p = new XMLParser(new InputStreamReader(in));
            patch = p.parse();
            p = new XMLParser(new FileReader(file));
            fileToPatch = p.parse();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new AddOnManagerException("Unable to load dom tree", new Object[0]);
        }
        NodeList root = patch.getDocumentElement().getChildNodes();
        int length = root.getLength();
        for (int i = 0; i < length; ++i) {
            String pathAttr;
            Node element = root.item(i);
            if ("x:delete".equals(element.getNodeName())) {
                pathAttr = element.getAttributes().getNamedItem("path").getNodeValue();
                this.deleteNode(fileToPatch, pathAttr);
                continue;
            }
            if (!"x:add".equals(element.getNodeName())) continue;
            pathAttr = element.getAttributes().getNamedItem("path").getNodeValue();
            if (element.getAttributes().getNamedItem("previous") == null) {
                String value = element.getAttributes().getNamedItem("value").getNodeValue();
                this.addAttrNode(fileToPatch, pathAttr, value);
                continue;
            }
            String previous = element.getAttributes().getNamedItem("previous").getNodeValue();
            NodeList nodeToAdd = element.getChildNodes();
            this.addNode(fileToPatch, pathAttr, previous, nodeToAdd);
        }
        File tmpFileToPatch = null;
        PrintWriter out = null;
        try {
            tmpFileToPatch = DomPatch.duplicateFile(file);
            out = new PrintWriter(new FileWriter(tmpFileToPatch));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new AddOnManagerException("Error when duplicate file with the filepath : '%s'", path, ex);
        }
        out.print(fileToPatch.toString());
        List<Patch> revertPatchSet = null;
        try {
            out.close();
            PlainOldPatchFactory popf = new PlainOldPatchFactory();
            revertPatchSet = popf.generatePatches(tmpFileToPatch, file);
            DomPatch.copyFile(tmpFileToPatch, file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new AddOnManagerException("Unable to save the file : '%s'", path, ex);
        }
        System.out.println("[P] ".concat(path));
        return revertPatchSet;
    }

    @Override
    public String getPatchTypeId() {
        return PATCH_TYPE_ID;
    }

    @Override
    public InputStream getPatchStream() {
        return new ByteArrayInputStream(this.data);
    }

    private void deleteNode(Document doc, String path) {
        Node target = doc.getDocumentElement();
        Pattern p = Pattern.compile("([a-zA-Z\\-]*\\[[^\\[\\]]*\\]|@.*)");
        Matcher m = p.matcher(path);
        ArrayList<String> elementList = new ArrayList<String>();
        while (m.find()) {
            elementList.add(m.group());
        }
        int size = elementList.size();
        if (size != 0) {
            block1: for (int i = 0; i < size; ++i) {
                String element = (String)elementList.get(i);
                if (element.getBytes()[0] == 64) {
                    Element current = target;
                    current.removeAttribute(element.substring(1));
                    continue;
                }
                NodeList list = target.getChildNodes();
                String[] elementPart = element.split("\\[");
                String elementName = elementPart[0];
                String elementId = elementPart[1].split("\\]")[0];
                int length = list.getLength();
                for (int j = 0; j < length; ++j) {
                    Node current = list.item(j);
                    if (current.getNodeType() != 1 || !current.getNodeName().equals(elementName) || !elementId.equals(DomPatchFactory.getId(current, this.idMap))) continue;
                    if (i + 1 == size) {
                        Element t = target;
                        t.removeChild(current);
                        continue block1;
                    }
                    target = current;
                    continue block1;
                }
            }
        }
    }

    private void addAttrNode(Document doc, String path, String value) {
        Node target = doc.getDocumentElement();
        Pattern p = Pattern.compile("([a-zA-Z\\-]*\\[[^\\[\\]]*\\]|@.*)");
        Matcher m = p.matcher(path);
        ArrayList<String> elementList = new ArrayList<String>();
        while (m.find()) {
            elementList.add(m.group());
        }
        int size = elementList.size();
        if (size != 0) {
            block1: for (int i = 0; i < size; ++i) {
                String element = (String)elementList.get(i);
                if (element.getBytes()[0] == 64) {
                    String spaceCode;
                    Element current = target;
                    String[] attrPart = element.substring(1).split("!");
                    String attrNameAndPosition = attrPart[0];
                    String[] attrNameAndPositionSplited = attrNameAndPosition.split("#");
                    String attrName = attrNameAndPositionSplited[0];
                    String attrPos = attrNameAndPositionSplited[1];
                    Attr newAttr = doc.createAttribute(attrName);
                    newAttr.setValue(value);
                    if (attrPart.length > 1 && (spaceCode = attrPart[1]) != null) {
                        AttributeNode attr = (AttributeNode)newAttr;
                        attr.setSpaceNode(this.createSpaceNode(spaceCode));
                    }
                    if (current.getAttributes() instanceof NamedNodeMap) {
                        NamedNodeMap attrList = (NamedNodeMap)current.getAttributes();
                        attrList.add((int)Integer.valueOf(attrPos), (AttributeNode)newAttr);
                        continue;
                    }
                    current.getAttributes().setNamedItem(newAttr);
                    continue;
                }
                NodeList list = target.getChildNodes();
                String[] elementPart = element.split("\\[");
                String elementName = elementPart[0];
                String elementId = elementPart[1].split("\\]")[0];
                int length = list.getLength();
                for (int j = 0; j < length; ++j) {
                    Node current = list.item(j);
                    if (current.getNodeType() != 1 || !current.getNodeName().equals(elementName) || !elementId.equals(DomPatchFactory.getId(current, this.idMap))) continue;
                    target = current;
                    continue block1;
                }
            }
        }
    }

    private void addNode(Document doc, String path, String previous, NodeList nodeToAdd) {
        Node target = this.getNode(doc, path);
        Node nextNode = null;
        if (!previous.equals("//")) {
            Node previousNode = this.getNode(doc, previous);
            nextNode = target.isEqualNode(previousNode) ? this.lastNonIdElement(previousNode.getFirstChild()).getNextSibling() : previousNode.getNextSibling();
        }
        int length = nodeToAdd.getLength();
        for (int i = 0; i < length; ++i) {
            Node item = nodeToAdd.item(i);
            Node importNode = doc.importNode(item, true);
            target.insertBefore(importNode, nextNode);
        }
    }

    private Node getNode(Document doc, String path) {
        Node target = doc.getDocumentElement();
        Pattern p = Pattern.compile("[a-zA-Z\\-]*\\[[^\\[\\]]*\\]");
        Matcher m = p.matcher(path);
        ArrayList<String> elementList = new ArrayList<String>();
        while (m.find()) {
            elementList.add(m.group());
        }
        int size = elementList.size();
        if (size != 0) {
            block1: for (int i = 0; i < size; ++i) {
                String element = (String)elementList.get(i);
                NodeList list = target.getChildNodes();
                String[] elementPart = element.split("\\[");
                String elementName = elementPart[0];
                String elementId = elementPart[1].split("\\]")[0];
                int length = list.getLength();
                int j = 0;
                while (i < length) {
                    Node current = list.item(j);
                    if (current.getNodeType() == 1 && current.getNodeName().equals(elementName) && elementId.equals(DomPatchFactory.getId(current, this.idMap))) {
                        target = current;
                        continue block1;
                    }
                    ++j;
                }
            }
        }
        return target;
    }

    private Node lastNonIdElement(Node node) {
        Node lastNonId = node;
        Node currentNode = node;
        while (!(currentNode.getNodeType() == 1 && DomPatchFactory.isId(currentNode, this.idMap) || (currentNode = currentNode.getNextSibling()) == null)) {
            if (currentNode.getNodeType() != 1 || DomPatchFactory.isId(currentNode, this.idMap)) continue;
            lastNonId = currentNode;
        }
        return lastNonId;
    }

    private SpaceNode createSpaceNode(String spaceCode) {
        String space = "";
        byte[] bytes = spaceCode.getBytes();
        int length = spaceCode.length();
        for (int i = 0; i < length; i += 2) {
            String nbString = new String(new byte[]{bytes[i]});
            int nb = Integer.valueOf(nbString);
            byte spaceType = bytes[i + 1];
            for (int j = 0; j < nb; ++j) {
                space = spaceType == 82 ? space.concat("\n") : space.concat(" ");
            }
        }
        return new SpaceNode(space);
    }
}

