/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.patch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neogia.addonmanager.patch.AbstractPatch;
import org.neogia.addonmanager.patch.CreateFilePatch;
import org.neogia.addonmanager.patch.Patch;
import org.neogia.addonmanager.patch.PatchException;
import org.neogia.addonmanager.patch.PatchFactory;

public class DeleteFilePatch
extends AbstractPatch {
    public static final Log logger = LogFactory.getLog("addonmanager.patch");
    public static final String PATCH_TYPE_ID = "dfp";

    public DeleteFilePatch(PatchFactory patchFactory) {
        super(patchFactory);
    }

    @Override
    public List<Patch> apply(String path, File file) {
        if (!file.isFile()) {
            throw new PatchException("Unable to patch file '%s'", file.getAbsolutePath());
        }
        ArrayList<Patch> revertPatchSet = new ArrayList<Patch>(1);
        revertPatchSet.add(new CreateFilePatch(this.factory, file));
        if (!file.delete()) {
            throw new PatchException("Unable to delete file '%s'", file.getAbsolutePath());
        }
        System.out.println("[D] " + path);
        return revertPatchSet;
    }

    @Override
    public InputStream getPatchStream() {
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public String getPatchTypeId() {
        return PATCH_TYPE_ID;
    }
}

