/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.patch;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.neogia.addonmanager.Repository;
import org.neogia.addonmanager.patch.BinaryPatch;
import org.neogia.addonmanager.patch.Patch;
import org.neogia.addonmanager.patch.PatchFactory;

public class BinaryPatchFactory
implements PatchFactory {
    @Override
    public Set<String> getSupportedPatchTypeId() {
        LinkedHashSet<String> supportedPatchTypeIds = new LinkedHashSet<String>();
        supportedPatchTypeIds.add("bip");
        return supportedPatchTypeIds;
    }

    @Override
    public boolean isFileTypeSupported(File file) {
        return true;
    }

    @Override
    public List<Patch> generatePatches(File oldFile, File newFile) {
        ArrayList<Patch> patchSet = new ArrayList<Patch>(1);
        if (!Repository.computeHash(oldFile).equals(Repository.computeHash(newFile))) {
            patchSet.add(new BinaryPatch((PatchFactory)this, newFile));
        }
        return patchSet;
    }

    @Override
    public Patch parsePatch(String patchTypeId, InputStream in) {
        return new BinaryPatch((PatchFactory)this, in);
    }

    @Override
    public List<Patch> generatePatches(File oldFile, File newFile, String nb) {
        ArrayList<Patch> patchSet = new ArrayList<Patch>(1);
        if (!Repository.computeHash(oldFile).equals(Repository.computeHash(newFile))) {
            patchSet.add(new BinaryPatch((PatchFactory)this, newFile));
        }
        return patchSet;
    }

    @Override
    public List<Patch> generatePatches(File oldFile, File newFile, boolean isRevert) {
        return this.generatePatches(oldFile, newFile);
    }

    @Override
    public List<Patch> generatePatches(File oldFile, File newFile, String nb, boolean isRevert) {
        return this.generatePatches(oldFile, newFile, nb);
    }
}

