/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.patch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.patch.AbstractPatch;
import org.neogia.addonmanager.patch.Patch;
import org.neogia.addonmanager.patch.PatchException;
import org.neogia.addonmanager.patch.PatchFactory;

public class BinaryPatch
extends AbstractPatch {
    public static final Log logger = LogFactory.getLog("addonmanager.patch");
    public static final String PATCH_TYPE_ID = "bip";
    private File patchDataFile;

    public BinaryPatch(PatchFactory patchFactory, File file) {
        super(patchFactory);
        try {
            this.patchDataFile = BinaryPatch.duplicateFile(file);
        }
        catch (IOException ex) {
            throw new AddOnManagerException("Unable to duplicate file '%s'", file.getAbsolutePath(), ex);
        }
        this.patchDataFile.deleteOnExit();
    }

    public BinaryPatch(PatchFactory patchFactory, InputStream in) {
        super(patchFactory);
        try {
            this.patchDataFile = BinaryPatch.copyStreamToTemporaryFile(in);
        }
        catch (IOException ex) {
            throw new AddOnManagerException("Unable to duplicate patch data", new Object[]{ex});
        }
        this.patchDataFile.deleteOnExit();
    }

    @Override
    public List<Patch> apply(String path, File file) {
        if (!file.isFile()) {
            throw new PatchException("Unable to patch file '%s'", file.getAbsolutePath());
        }
        ArrayList<Patch> revertPatchSet = new ArrayList<Patch>(1);
        revertPatchSet.add(new BinaryPatch(this.factory, file));
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = this.getPatchStream();
            out = new FileOutputStream(file, false);
            byte[] buffer = new byte[4096];
            int read = 0;
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        catch (Exception ex) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ignoredException) {
                    // empty catch block
                }
            }
            out = null;
            throw new PatchException("An unexpected exception occured while applying patch to file '%s'", file.getAbsolutePath());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ignoredException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ignoredException) {}
            }
        }
        System.out.println("[P] " + path);
        return revertPatchSet;
    }

    @Override
    public String getPatchTypeId() {
        return PATCH_TYPE_ID;
    }

    @Override
    public InputStream getPatchStream() {
        try {
            return new FileInputStream(this.patchDataFile);
        }
        catch (FileNotFoundException ex) {
            throw new AddOnManagerException("Unable to access to patch data '%s'", this.patchDataFile, ex);
        }
    }
}

