/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.command;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class XMLDependencies {
    private String path;

    public XMLDependencies() {
        this.path = "";
    }

    public XMLDependencies(String path) {
        this.setPath(path);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (path.length() > 0 && path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        this.path = path;
    }

    public ArrayList<String> getDependencies(File lastIvy) {
        List listDependencies;
        Document ivyXML;
        Element racine;
        ArrayList<String> dependencies = null;
        if (lastIvy != null && (racine = (ivyXML = this.getFileXML(lastIvy)).getRootElement()).getChild("dependencies") != null && !(listDependencies = racine.getChild("dependencies").getChildren("dependency")).isEmpty()) {
            dependencies = new ArrayList<String>();
            for (Element e : listDependencies) {
                dependencies.add(e.getAttributeValue("name"));
            }
        }
        return dependencies;
    }

    public String getDependenciesVersion(File file) {
        Document ivyXML = this.getFileXML(file);
        Element racine = ivyXML.getRootElement();
        String dep = racine.getChild("info").getAttributeValue("revision");
        return dep;
    }

    public Document getFileXML(File file) {
        SAXBuilder sxb = new SAXBuilder();
        try {
            Document fileXML = sxb.build(file);
            return fileXML;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private File[] listFiles(String directoryPath) {
        File directoryToScan = new File(directoryPath);
        File[] files = directoryToScan.listFiles();
        return files;
    }

    public File getLastIvy() {
        ArrayList<File> ivyList = new ArrayList<File>();
        for (File f : this.listFiles(this.path)) {
            if (!f.isFile() || !f.getName().startsWith("ivy") || !f.getName().endsWith(".xml")) continue;
            ivyList.add(f);
        }
        return this.compareIvy(ivyList);
    }

    private File compareIvy(ArrayList<File> ivyList) {
        if (ivyList.size() > 1) {
            File lastIvyFile = ivyList.get(0);
            for (int i = 1; i < ivyList.size(); ++i) {
                File tmp = this.compareVersion(lastIvyFile, ivyList.get(i));
                if (tmp == null) {
                    if (lastIvyFile.getName().length() >= ivyList.get(i).getName().length()) continue;
                    lastIvyFile = ivyList.get(i);
                    continue;
                }
                lastIvyFile = tmp;
            }
            return lastIvyFile;
        }
        if (ivyList.isEmpty()) {
            return null;
        }
        return ivyList.get(0);
    }

    private File compareVersion(File f1, File f2) {
        String[] v1 = this.getVersion(f1);
        String[] v2 = this.getVersion(f2);
        if (v1 == null) {
            if (v2 == null) {
                return null;
            }
            return f2;
        }
        if (v2 == null) {
            return f1;
        }
        int nbNums = Math.min(v1.length, v2.length);
        for (int i = 0; i < nbNums; ++i) {
            if (Integer.parseInt(v1[i]) > Integer.parseInt(v2[i])) {
                return f1;
            }
            if (Integer.parseInt(v1[i]) >= Integer.parseInt(v2[i])) continue;
            return f2;
        }
        if (f1.getName().contains("-dev")) {
            if (f2.getName().contains("-dev")) {
                return f1;
            }
            return f2;
        }
        return f1;
    }

    private String[] getVersion(File f) {
        String name = f.getName();
        name = name.substring(0, name.lastIndexOf(46));
        String neogiaDelimiters = "[-]+";
        String delimiters = "[.]+";
        String[] decomposition = name.split(neogiaDelimiters);
        if (decomposition.length > 1) {
            String[] version;
            for (String num : version = decomposition[1].split(delimiters)) {
                for (char c : num.toCharArray()) {
                    if (!Character.isLetter(c)) continue;
                    return null;
                }
            }
            return version;
        }
        return null;
    }
}

