/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neogia.addonmanager.AddOnManager;
import org.neogia.addonmanager.Command;
import org.neogia.addonmanager.command.InitCommand;
import org.neogia.addonmanager.command.RevertCommand;
import org.neogia.addonmanager.command.StatusCommand;
import org.neogia.addonmanager.registry.RegisteredAddOn;
import org.neogia.addonmanager.registry.Registry;

public class UninstallAddOnCommand
extends Command {
    private String[] addOnNames;
    private Boolean force = false;
    private Boolean reload = false;

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public UninstallAddOnCommand(String[] addOnNames) {
        this.addOnNames = addOnNames;
    }

    @Override
    protected Map<String, Object> doExecute(AddOnManager addOnManager) {
        addOnManager.executeCommand(new InitCommand());
        Registry registry = addOnManager.getRegistry();
        RevertCommand com = new RevertCommand();
        StatusCommand status = new StatusCommand();
        List<String> l = status.getItems(addOnManager);
        ArrayList<String> ls = new ArrayList<String>();
        ls.addAll(l);
        for (String addOnName : this.addOnNames) {
            if (this.force.booleanValue()) {
                for (RegisteredAddOn addOn = registry.getLastAddOn(); addOn != null; addOn = addOn.getPreviousAddOn()) {
                    if (!addOn.getArtifactId().equals(addOnName)) continue;
                    for (int i = 0; i < ls.size(); ++i) {
                        if (!addOn.getArchive().existPatch((String)ls.get(i))) continue;
                        com.doExecute(addOnManager, (String)ls.get(i));
                    }
                }
                addOnManager.getRegistry().uninstallAddOn(addOnName);
                continue;
            }
            if (this.reload.booleanValue()) {
                addOnManager.getRegistry().uninstallAddOns(addOnName);
                continue;
            }
            addOnManager.getRegistry().uninstallAddOn(addOnName);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        return result;
    }
}

