/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neogia.addonmanager.AddOnManager;
import org.neogia.addonmanager.Command;
import org.neogia.addonmanager.Tree;
import org.neogia.addonmanager.TreeComparator;
import org.neogia.addonmanager.TreeItem;
import org.neogia.addonmanager.command.InitCommand;
import org.neogia.addonmanager.registry.RegisteredAddOn;
import org.neogia.addonmanager.registry.Registry;

public class StatusCommand
extends Command {
    Boolean detail = false;

    public void setDetail(boolean detail) {
        this.detail = detail;
    }

    @Override
    protected Map<String, Object> doExecute(AddOnManager addOnManager) {
        RegisteredAddOn addOn;
        int cpt;
        addOnManager.executeCommand(new InitCommand());
        Registry registry = addOnManager.getRegistry();
        Tree lastTree = addOnManager.getRegistry().getLastTree();
        HashMap<String, String> tempMap = null;
        Tree currentTree = addOnManager.getCurrentTree();
        currentTree.computeHash();
        TreeComparator comparator = new TreeComparator(lastTree, currentTree);
        comparator.compare();
        ArrayList removedPaths = new ArrayList();
        ArrayList addedPaths = new ArrayList();
        ArrayList modifiedPaths = new ArrayList();
        Set<TreeItem> items = comparator.getRemovedTreeItems();
        for (TreeItem deletedItem : items) {
            tempMap = new HashMap<String, String>();
            if (this.detail.booleanValue()) {
                System.out.print("D " + deletedItem.getPath() + ":");
                cpt = 0;
                for (addOn = registry.getLastAddOn(); addOn != null; addOn = addOn.getPreviousAddOn()) {
                    if (!addOn.getArchive().existPatch(deletedItem.getPath())) continue;
                    if (cpt == 0) {
                        System.out.print(addOn.getArtifactId());
                        ++cpt;
                        continue;
                    }
                    System.out.print("," + addOn.getArtifactId());
                }
                System.out.println();
                continue;
            }
            System.out.println("D " + deletedItem.getPath());
            tempMap.put("file", deletedItem.getPath());
            tempMap.put("status", "D");
            removedPaths.add(tempMap);
        }
        items = comparator.getAddedTreeItems();
        for (TreeItem addedItem : items) {
            tempMap = new HashMap();
            System.out.println("A " + addedItem.getPath());
            tempMap.put("file", addedItem.getPath());
            tempMap.put("status", "A");
            addedPaths.add(tempMap);
        }
        items = comparator.getModifiedTreeItems();
        for (TreeItem modifiedItem : items) {
            tempMap = new HashMap();
            if (this.detail.booleanValue()) {
                System.out.print("M " + modifiedItem.getPath() + ":");
                cpt = 0;
                for (addOn = registry.getLastAddOn(); addOn != null; addOn = addOn.getPreviousAddOn()) {
                    if (!addOn.getArchive().existPatch(modifiedItem.getPath())) continue;
                    if (cpt == 0) {
                        System.out.print(addOn.getArtifactId());
                        ++cpt;
                        continue;
                    }
                    System.out.print("," + addOn.getArtifactId());
                }
                System.out.println();
                continue;
            }
            System.out.println("M " + modifiedItem.getPath());
            tempMap.put("file", modifiedItem.getPath());
            tempMap.put("status", "M");
            modifiedPaths.add(tempMap);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("modified", modifiedPaths);
        result.put("removed", removedPaths);
        result.put("added", addedPaths);
        return result;
    }

    public List<String> getItems(AddOnManager addOnManager) {
        Tree lastTree = addOnManager.getRegistry().getLastTree();
        Tree currentTree = addOnManager.getCurrentTree();
        currentTree.computeHash();
        TreeComparator comparator = new TreeComparator(lastTree, currentTree);
        comparator.compare();
        ArrayList<String> temp = new ArrayList<String>();
        Set<TreeItem> itemsR = comparator.getRemovedTreeItems();
        for (TreeItem deletedItem : itemsR) {
            temp.add(deletedItem.getPath());
        }
        Set<TreeItem> itemsM = comparator.getModifiedTreeItems();
        for (TreeItem modifiedItem : itemsM) {
            temp.add(modifiedItem.getPath());
        }
        return temp;
    }

    public List<String> getModifiedItems(AddOnManager addOnManager) {
        Tree lastTree = addOnManager.getRegistry().getLastTree();
        Tree currentTree = addOnManager.getCurrentTree();
        currentTree.computeHash();
        TreeComparator comparator = new TreeComparator(lastTree, currentTree);
        comparator.compare();
        ArrayList<String> temp = new ArrayList<String>();
        Set<TreeItem> itemsM = comparator.getModifiedTreeItems();
        for (TreeItem modifiedItem : itemsM) {
            temp.add(modifiedItem.getPath());
        }
        return temp;
    }
}

