/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.command;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neogia.addonmanager.AddOnManager;
import org.neogia.addonmanager.Repository;
import org.neogia.addonmanager.Tree;
import org.neogia.addonmanager.TreeItem;
import org.neogia.addonmanager.command.PathSetCommand;
import org.neogia.addonmanager.command.StatusCommand;
import org.neogia.addonmanager.registry.Registry;

public class RevertCommand
extends PathSetCommand {
    private boolean revert = false;

    public void setRevert(boolean revert) {
        this.revert = revert;
    }

    @Override
    protected Map<String, Object> doExecute(AddOnManager addOnManager, String path) {
        if (this.revert) {
            this.doDirectoryRevert(addOnManager, path);
        } else {
            this.doFileRevert(addOnManager, path);
        }
        return new HashMap<String, Object>();
    }

    private void doDirectoryRevert(AddOnManager addOnManager, String path) {
        StatusCommand status = new StatusCommand();
        List<String> l = status.getItems(addOnManager);
        ArrayList<String> ls = new ArrayList<String>();
        ls.addAll(l);
        File dir = new File(path);
        File[] children = dir.listFiles();
        System.out.println(((Object)ls).toString());
        for (File child : children) {
            if (child.isFile() && ls.contains(child.getPath())) {
                this.doFileRevert(addOnManager, child.getPath());
                continue;
            }
            if (child.isFile()) continue;
            this.doDirectoryRevert(addOnManager, child.getPath());
        }
    }

    private void doFileRevert(AddOnManager addOnManager, String path) {
        Repository repository = addOnManager.getRepository();
        Registry registry = addOnManager.getRegistry();
        File file = registry.getCurrentFile(path);
        try {
            Tree lastTree = registry.getLastTree();
            TreeItem item = lastTree.getTreeItem(path);
            if (item == null) {
                if (file.isFile() && file.delete()) {
                    System.out.println("D " + path);
                }
            } else if (file == null) {
                File f = new File(item.getFile().getPath());
                if (repository.writeObject(item.getHash(), new FileOutputStream(f))) {
                    f.setLastModified(item.getLastModifiedDate());
                    System.out.println("R " + path);
                }
            } else if (repository.writeObject(item.getHash(), new FileOutputStream(file))) {
                file.setLastModified(item.getLastModifiedDate());
                System.out.println("R " + path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

