/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.command;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.neogia.addonmanager.AddOnManager;
import org.neogia.addonmanager.Command;
import org.neogia.addonmanager.command.InitCommand;
import org.neogia.addonmanager.registry.RegisteredAddOn;
import org.neogia.addonmanager.registry.Registry;

public class NewAddOnCommand
extends Command {
    private final String addOnName;
    private File addOnLocation;

    public NewAddOnCommand(String addOnName) {
        this(addOnName, null);
    }

    public NewAddOnCommand(String addOnName, File addOnLocation) {
        if (addOnName == null || addOnName.length() == 0) {
            throw new IllegalArgumentException("invalid add-on name : '" + addOnName + "'");
        }
        this.addOnName = addOnName;
        this.addOnLocation = addOnLocation;
    }

    public String getAddOnName() {
        return this.addOnName;
    }

    public File getAddOnLocation() {
        return this.addOnLocation;
    }

    @Override
    protected Map<String, Object> doExecute(AddOnManager addOnManager) {
        Registry registry = addOnManager.getRegistry();
        addOnManager.executeCommand(new InitCommand());
        RegisteredAddOn addOn = registry.getCurrentlyEditedAddOn();
        if (addOn != null && this.addOnName.equals(addOn.getArtifactId())) {
            return new HashMap<String, Object>();
        }
        registry.createAddOn(this.addOnName, this.addOnLocation);
        return new HashMap<String, Object>();
    }
}

