/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.command;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.neogia.addonmanager.AddOnManager;
import org.neogia.addonmanager.Command;
import org.neogia.addonmanager.Repository;
import org.neogia.addonmanager.Tree;
import org.neogia.addonmanager.TreeItem;
import org.neogia.addonmanager.registry.RegisteredAddOn;
import org.neogia.addonmanager.registry.Registry;

public class ListAddonFilesCommand
extends Command {
    private String addonName;

    public ListAddonFilesCommand(String name) {
        this.addonName = name;
    }

    @Override
    protected Map<String, Object> doExecute(AddOnManager addOnManager) {
        Registry registry = addOnManager.getRegistry();
        HashMap<String, Object> result = new HashMap<String, Object>();
        RegisteredAddOn addOn = registry.getAddOn(this.addonName);
        RegisteredAddOn lastAddOn = registry.getLastAddOn();
        if (addOn != null) {
            Tree newTree = addOn.getPostTree();
            System.out.println("Addon files for :" + this.addonName);
            Set<String> files = addOn.getPathsToPatch();
            if (lastAddOn != null && lastAddOn.getArtifactId().equals(this.addonName)) {
                for (String file : files) {
                    String newItemHash;
                    TreeItem item = newTree.getTreeItem(file);
                    String itemHash = item != null ? item.getHash() : "";
                    File currentFile = registry.getCurrentFile(file);
                    String string = newItemHash = currentFile != null ? Repository.computeHash(currentFile) : "";
                    if (itemHash.equals(newItemHash)) {
                        System.out.printf(" - %s", file);
                        System.out.println();
                        result.put(file, "N");
                        continue;
                    }
                    System.out.printf(" - %s (M)", file);
                    System.out.println();
                    result.put(file, "Y");
                }
            } else {
                for (String file : files) {
                    System.out.printf(" - %s", file);
                    System.out.println();
                    result.put(file, "N");
                }
            }
        } else {
            System.out.println("Addon " + this.addonName + " does not exist");
            return null;
        }
        return result;
    }
}

