/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.command;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neogia.addonmanager.AddOnManager;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.AddonDependency;
import org.neogia.addonmanager.Command;
import org.neogia.addonmanager.DependencyMgr;
import org.neogia.addonmanager.command.InitCommand;

public class InstallAddOnCommand
extends Command {
    private File addOnLocation;
    private String version;

    public InstallAddOnCommand(File addOnLocation, String version) {
        this.addOnLocation = addOnLocation;
        this.version = version;
    }

    @Override
    protected Map<String, Object> doExecute(AddOnManager addOnManager) {
        File ivySetting = null;
        System.setProperty("ivy.cache.dir", addOnManager.getDataDir().getPath());
        List<AddonDependency> resolvedAddons = null;
        addOnManager.executeCommand(new InitCommand());
        ivySetting = addOnManager.getDataFile("ivysettings.xml");
        try {
            if (!this.addOnLocation.isDirectory() && !this.addOnLocation.isFile()) {
                DependencyMgr mgr = new DependencyMgr(this.addOnLocation.getPath(), this.version, ivySetting, addOnManager);
                resolvedAddons = mgr.retreiveDependencies();
                String tagertAddonName = mgr.getTreeRootName();
                for (AddonDependency dependecny : resolvedAddons) {
                    if (tagertAddonName.equals(dependecny.getName()) || addOnManager.getRegistry().getAddOn(dependecny.getName()) != null) continue;
                    addOnManager.getRegistry().installAddOn(dependecny.getFile());
                }
            } else {
                File ivyFile = addOnManager.getRegistry().getIvyFile(this.addOnLocation);
                if (ivyFile != null && ivyFile.exists()) {
                    DependencyMgr mgr = new DependencyMgr(ivyFile, ivySetting, addOnManager);
                    resolvedAddons = mgr.retreiveDependencies();
                    String tagertAddonName = mgr.getTreeRootName();
                    for (AddonDependency dependecny : resolvedAddons) {
                        if (tagertAddonName.equals(dependecny.getName()) || addOnManager.getRegistry().getAddOn(dependecny.getName()) != null) continue;
                        addOnManager.getRegistry().installAddOn(dependecny.getFile());
                    }
                }
                addOnManager.getRegistry().installAddOn(this.addOnLocation);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new AddOnManagerException("Installation failed for : " + this.addOnLocation, new Object[0]);
        }
        return new HashMap<String, Object>();
    }
}

