/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.command;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neogia.addonmanager.AddOnManager;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.Tree;
import org.neogia.addonmanager.TreeItem;
import org.neogia.addonmanager.command.PathSetCommand;
import org.neogia.addonmanager.command.StatusCommand;
import org.neogia.addonmanager.patch.Patch;
import org.neogia.addonmanager.patch.PatchService;

public class DiffCommand
extends PathSetCommand {
    public String nb = "";
    public boolean index = false;
    public boolean revert = false;

    public void setIndex(boolean index) {
        this.index = index;
    }

    public void setNb(String nb) {
        this.nb = nb;
    }

    public void setRevert(boolean revert) {
        this.revert = revert;
    }

    @Override
    protected Map<String, Object> doExecute(AddOnManager addOnManager, String path) {
        File file = addOnManager.getOfbizHomeRelativeFile(path);
        if (file.isDirectory() && !this.revert) {
            this.doDirectoryDiff(addOnManager, path, file);
        } else if (file.isDirectory() && this.revert) {
            this.doDirectoryDiff(addOnManager, path);
        } else if (file.isFile()) {
            this.doFileDiff(addOnManager, path);
        } else {
            logger.error("Unable to do diff for path '" + path + "'");
        }
        return new HashMap<String, Object>();
    }

    private void doDirectoryDiff(AddOnManager addOnManager, String path, File dir) {
        File[] children;
        for (File child : children = dir.listFiles(addOnManager.getDefaultExcludeFileFilter())) {
            if (child.isDirectory()) {
                this.doDirectoryDiff(addOnManager, path + "/" + child.getName(), child);
                continue;
            }
            if (child.isFile()) {
                this.doFileDiff(addOnManager, path + "/" + child.getName());
                continue;
            }
            logger.error("Unable to do diff for path '" + child.getAbsolutePath() + "'");
        }
    }

    private void doDirectoryDiff(AddOnManager addOnManager, String path) {
        File[] children;
        StatusCommand status = new StatusCommand();
        List<String> l = status.getModifiedItems(addOnManager);
        ArrayList<String> ls = new ArrayList<String>();
        ls.addAll(l);
        File dir = new File(path);
        for (File child : children = dir.listFiles()) {
            if (child.isFile() && ls.contains(child.getPath())) {
                this.doFileDiff(addOnManager, child.getPath());
                System.out.println("*********************************************");
                continue;
            }
            if (child.isFile()) continue;
            this.doDirectoryDiff(addOnManager, child.getPath());
        }
    }

    private void doFileDiff(AddOnManager addOnManager, String path) {
        Tree lastTree = addOnManager.getRegistry().getLastTree();
        TreeItem item = lastTree.getTreeItem(path);
        if (item == null) {
            System.out.printf("New File : %s%n", path);
        } else if (item.hasChanged()) {
            PatchService patchService = new PatchService();
            List<Patch> patchSet = null;
            File tmpOldFile = null;
            try {
                tmpOldFile = item.getRepositoryFile();
                patchSet = this.nb == "" ? patchService.generatePatchs(tmpOldFile, item.getFile()) : patchService.generatePatchs(tmpOldFile, item.getFile(), this.nb);
                if (this.index) {
                    System.out.println("Index: " + item.getPath());
                }
                System.out.printf("---\t%s\t(%s)%n", item.getPath(), item.getHash());
                System.out.printf("+++\t%s%n", item.getPath());
                for (Patch patch : patchSet) {
                    System.out.println(patch.toString());
                }
            }
            catch (Exception ex) {
                throw new AddOnManagerException("An unexpected exception occured while doing diff for '%s'", item.getPath(), ex);
            }
            finally {
                if (tmpOldFile != null) {
                    tmpOldFile.delete();
                }
            }
        }
    }
}

